/**
 * %W% %E%
 * @Copyright
 */

package com.sun.javacard.cjck.invoke;

import java.io.PrintWriter;

import com.sun.javatest.Status;

import com.sun.javacard.cjck.userinterface.CJCKCardService;
import com.sun.javacard.cjck.userinterface.CardProxyException;

/**
 * This interface represents Scripts which contains the more than one
 * independent testcases.
 */
public interface MultiTestScript extends JavaCardScript {

    /**
     * returns the count of the testcases, which are contained in the current script.
     */
    public abstract int getTestCaseCount();
    
    /**
     * executes the testcase with the given index.
     * If the script implements this interface then runTestCase
     * will be used by CardProxyTest instead of the run method defined
     * in the JavaCardScript. The testcases are numbered from 0.
     * @param id given index
     */
    public abstract Status runTestCase(int id, CJCKCardService service,
                                       PrintWriter out, PrintWriter ref)
        throws CardProxyException;
}
