/**
 * %W% %E%
 * @Copyright
 */

package com.sun.javacard.cjck.invoke;

import java.io.PrintWriter;

import com.sun.javatest.Status;

import com.sun.javacard.cjck.userinterface.CJCKCardService;
import com.sun.javacard.cjck.userinterface.CardProxyException;

/**
 * This interface represents abstract script for Java Card TCK tests.
 * The scripts are executed after installation of the cap files and applets.
 */
public interface JavaCardScript {
    /**
     * executes scripts and returns Status of the the execution.
     */
    public abstract Status run(CJCKCardService service, PrintWriter out, PrintWriter ref)
        throws CardProxyException;

    /**
     * sets arguments for the current script.
     */
    public abstract void setArguments(String args[]);
    /**
     * sets excluded entries. The Test Run Framework does not modify or
     * filter excluded entries. All entries defined by -exclude option
     * are transferred to all script of the current test.
     * @param entries list of the excluded entries.
     */
    public abstract void setExcludeEntries(String[] entries);

    /**
     * returns name of the current script. This name is used for
     * debugging information in the .jtr file.
     */
    public abstract String getName();
}
