/*
 * %W% %E%
 *
 * @Copyright
 */
package com.sun.javacard.cjck.invoke;

import java.util.Enumeration;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.scripts.ScriptFailException;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javatest.Status;
import com.sun.javatest.lib.MultiStatus;

/**
 * The base class for the modes which require applet executions, such as
 * install, loadClassFiles and loadCapFiles.
 */
public abstract class ExecuteMode extends RunMode {
    protected CardProxyArguments args;
    protected ConfigFileReader configFile;
    
    public Status run(CardProxyArguments args, ConfigFileReader configFile) 
        throws CardProxyException {
        this.args = args;
        this.configFile = configFile;
        Status retVal = load();
        return (retVal.isPassed() || args.isLoadStatusIgnored()) ? executeTestScripts() : retVal;
    }

    /**
     * loads application on the card using procedure specific for the run mode.
     * @return true if loading is succesful and false otherwise.
     * @throws CardProxyException
     */
    protected abstract Status load() throws CardProxyException;
    
    /**
     * executes the scripts.
     * @return
     * @throws CardProxyException
     */
    protected Status executeTestScripts() throws CardProxyException {
        // send the test scripts to the Proxy
        Enumeration e = args.getScriptFiles();
        String[] excluded = args.getExcludedTestCases();
        while (e.hasMoreElements()) {
            JavaCardScript
                script = ((ScriptDefinition)e.nextElement()).loadScript();
            log(I18n.getString("process.script", getName(), script.getName()));
            script.setExcludeEntries(excluded);
            if (script instanceof ConfiguredScript) {
                log(I18n.getString("set.configfilereader.for", getName(), script.getName()));
                ((ConfiguredScript)script).setConfigFileReader(configFile);
            }
            if (script instanceof CustomizableScript) {
                log(I18n.getString("set.cardproxyarg.for", getName(), script.getName()));
                ((CustomizableScript)script).setCardProxyArguments(args);
            }

            Status status = ((script instanceof MultiTestScript)
                             ? runMultiTestScript((MultiTestScript)script)
                             : script.run(cardService, logWriter, refWriter));
                
            log(I18n.getString("script.status", getName(), status));
            ref(I18n.getString("script.status", getName(), status));
            if (!status.isPassed()) {
                return status;
            }
        }
        return Status.passed("");
    }

    private Status runMultiTestScript(MultiTestScript script)
        throws CardProxyException {
        MultiStatus retVal = new MultiStatus();
        int count = script.getTestCaseCount();
        int bundle_size = args.getBundleSize();
        StringBuffer footer = new StringBuffer();
        for (int i = 1; i <= count; i++) {
            if ((bundle_size != 0) && (i != 1) && (i % bundle_size == 0)) {
                reinstallCode(args, configFile);
            }
            String id = I18n.getString("testcase.id.1", new Integer(i));
            try {
                Status current = script.runTestCase(i, cardService,
                                                     logWriter, refWriter);
                // TODO Implement loading of the testcase names specific for the
                // test
                ref(I18n.getString("multitest.testcase.status", new Integer(i),
                                    current));
                retVal.add(id, current);
            } catch (ScriptFailException e) {
                ref(I18n.getString("multitest.testcase.status", new Integer(i),
                                    e.getStatus()));
                retVal.add(id, e.getStatus());
            }
        }
        return retVal.getStatus();
    }

    
    protected Status reinstallCode(CardProxyArguments args, 
                                   ConfigFileReader configFile)
        throws CardProxyException {
        log(I18n.getString("reinstall.code", getName()));
        cardService.powerDown();
        cardService.stopTest();
        cardService.startTest(args.getOutputDir(),
                              args.getNuberOfReset());
        return load();
    }

    protected String getFullCapFileName(String capname) throws CardProxyException {
        String[] dirs = new String[] {
                args.getCapFileDir(),
                args.getLibraryRoot(),
                args.getRefCapFileDir()
        };

        for (int i = 0; i < dirs.length; i++) {
            String name = Utils.getCanonicalName(dirs[i], capname);
            String info = Utils.fileInfo(name);
            if (dirs[i] == null) {
                    throw new CardProxyException(I18n.getString("can.not.find.capfile", name, info));
            }
            if (info != null) {
                return name;
            }
        }
        throw new CardProxyException(I18n.getString("can.not.find.capfile", capname, null));
    }
}
