/*
 * %W% %E%
 * @Copyright
 */

package com.sun.javacard.cjck.invoke;

import com.sun.javacard.cjck.I18n;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

/**
 *
 * @author Mikhail Smirnov
 */
public class DelayedPrintWriter extends PrintWriter {


    protected Writer outputDestination;

    /**
     * Creates a new DelayedPrintWriter
     *
     * @param  out        A character-output stream
     */
    public DelayedPrintWriter (Writer out) {
	this(out, false);
    }

    /**
     * Creates a new DelayedPrintWriter.
     *
     * @param  out        A character-output stream
     * @param  autoFlush  ignored - autoflush is set to false
     */
    public DelayedPrintWriter(Writer out,
		       boolean autoFlush) {
	super(new CharArrayWriter(), false);
        outputDestination = out;
    }

    /**
     * Creates a new DelayedPrintWriter, without automatic line flushing, from an
     * existing OutputStream.  This convenience constructor creates the
     * necessary intermediate OutputStreamWriter, which will convert characters
     * into bytes using the default character encoding.
     *
     * @param  out        An output stream
     *
     */
    public DelayedPrintWriter(OutputStream out) {
	this(out, false);
    }

    /**
     * Creates a new DelayedPrintWriter from an existing OutputStream.  This
     * convenience constructor creates the necessary intermediate
     * OutputStreamWriter, which will convert characters into bytes using the
     * default character encoding.
     *
     * @param  out        An output stream
     * @param  autoFlush  ignored, autoFlush is set to false
     *
     */
    public DelayedPrintWriter(OutputStream out, boolean autoFlush) {
	super(new CharArrayWriter(), false);
        outputDestination = new OutputStreamWriter(out);
    }

    public void flushData() {
        try {
            outputDestination.write(out.toString());
        } catch (IOException ex) {
            System.err.println(I18n.getString("io.exception", ex));
        }
    }

    public void resetData() {
        //flushData(); //FIXME: remove this
        ((CharArrayWriter)out).reset();
    }
}
