/**
 * %W% %E%
 * @Copyright
 */

package com.sun.javacard.cjck.invoke;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import com.sun.javacard.cjck.I18n;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public class CardProxyArguments extends ArgumentParser {

    /**
     * defines default major version of the created cap files.
     */
    public static final String DEFAULT_MAJOR_VERSION = "1";
    
    /**
     * defines default minor version of the created cap files.
     */
    public static final String DEFAULT_MINOR_VERSION = "0";

    public static final String DEFAULT_BUNDLE_SIZE = "0";
            
    static final String DEFAULT_SCRIPT_CLASS_NAME = "com.sun.javacard.cjck.scripts.DoTestScript";

    private boolean[] status;
    private Hashtable excludedScripts = new Hashtable();
    private Vector<ScriptDefinition> scripts;
    private ClassLoader loader;
    
    public CardProxyArguments(String[] args) {
        super(
            new String[] { // The one position arguments
                "-v", // Command: 
                "-Verbose", // Command: 
                "-verbose", // Command:
                "-cjasm",
                "-bothIO",
                "-loadStatusIgnore",
                "-legacyMode"
            },
            new String[] {
                "-C", // Command: CardService class
                "-B", // BiometricDataProvider class
                "-classpath", // class path for loading of CardService class.
                "-M", // Command: script file name 
                "-Property", // Command: Defines properties
                "-R", // Test: Response
                "-Test", // Command: -Test $test
                "-TestCount", // Test: 
                "-capfile", // Test: defines cap file which will be installed
                "-capfiledir", //  The directory of the cap files
                "-classdir",  // Command: 
                "-exclude", // JavaTest: 
                "-exportdir", // Command: 
                "-exportmapfile", // Command: ?
                "-majorversion", // Command: 
                "-minorversion", // Command: 
                "-mode", // Command: 
                "-o", "-outputrootdir", // Command: 
                "-x", // Test: 
                "-executeClass", //  
                "-noConversion",
                "-refcapfiledir", //  The directory of the reference cap files
                "-s",
                "-bundle_size",
                "-get_response_cla_byte",
                "-libcapfile",
                "-libdir",
                "-libCfg"
            },
            new String[] {
                "-Property",
                "-capfile",
                "-exclude",
                "-noConversion",
                "-s",
                "-libcapfile",
                "-libCfg",
                "-legacyMode"
            });
        Vector simpleArgs = new Vector();
        this.scripts = new Vector<ScriptDefinition>();
        ScriptDefinition script = null;
        boolean isDefault = false;
        for (int i = 0; i < args.length; i++) {
            if (args[i].equals("-scriptClass")
                && (i < (args.length - 1))) {
                script = new ScriptDefinition(args[++i]);
                this.scripts.addElement(script);
            } else if (args[i].equals("-scriptArg") &&
                       (i < (args.length - 1))) {
                if (script == null) {
                    throw new IllegalArgumentException(I18n.getString("bad.script.argument"));
                }
                script.addArgument(args[++i]);
            } else {
                if (args[i].equals("-TestCount") && (i < (args.length - 1))) {
                    isDefault = true;
                } 
                simpleArgs.addElement(args[i]);
            }
        }
        parseArgs((String[])simpleArgs.toArray(new String[simpleArgs.size()]));
        for (Enumeration e = this.scripts.elements(); e.hasMoreElements();) {
            ScriptDefinition sd = (ScriptDefinition)e.nextElement();
            if (sd.isScriptFile()) {
                sd.addArguments("-workDir", getTestDir());
            }
        }
        if (isDefault && (this.scripts.size() == 0)) {
            String scriptName = DEFAULT_SCRIPT_CLASS_NAME;
            this.scripts.addElement(new ScriptDefinition(scriptName,
                                                         new String[] {
                                                             "-testCount",
                                                             Integer.toString(getTestCaseCount()),
                                                             "-executeClass",
                                                             getExecuteClass(),
                                                             "-legacyMode"
                                                         }));
        }
        String path = getClassPath();
        loader = (path == null)
                    ? getClass().getClassLoader()
                    : createPathClassLoader(path);
    }



    /**
     * creates URLClassLoader for a given path. The path is assumed as list of
     * the files or directories separated by OS dependent path separator.
     * @param path
     * @return
     */
    protected ClassLoader createPathClassLoader(final String path)  {
        ArrayList retVal = new ArrayList();
        for (StringTokenizer e = new StringTokenizer(path, File.pathSeparator);
        e.hasMoreTokens();) {
            File f = new File(e.nextToken());
            try {
                if (f.exists()) {
                    retVal.add(f.toURL());
                }
            } catch (Exception e1) {
            }
        }
        return new URLClassLoader((URL[])retVal.toArray(new URL[retVal.size()]),
                this.getClass().getClassLoader());
    }

    public String getClassPath() {
        return getSingleOption("-classpath", true);
    }

    public ClassLoader getClassLoader() {
        return loader;
    }
        
    public String getExecuteClass() {
        return getSingleOption("-executeClass", false);
    }
    
    public String getRunMode() {
        return getSingleOption("-mode", false);
    }


    public String getCardServiceClass() {
        return this.getSingleOption("-C", false);
    }
    
    /**
     * @return  BiomerticDataProvider implementation class name
     *          or null if not specified
     */
    public String getBiometricDataProviderClass() {
        return this.getSingleOption("-B", true);
    }

    public String getConfigFile() {
        return getTestDir() + File.separator + getSingleOption("-M", false);
    }
    
    public Enumeration getLibConfigFiles() {
        Vector list = new Vector();
        Enumeration e = getOption("-libCfg");
        if (e.hasMoreElements()) {
            String dir = getLibraryRoot() + File.separator;
            while (e.hasMoreElements()) {
                list.addElement(dir + e.nextElement());
            }
        }
        return list.elements();
    }

    public int getTestCaseCount() {
        return parseInt(getSingleOption("-TestCount", false), "-TestCount");
    }

    public int getScriptFileCount() {
        return this.scripts.size();
    }
    
    
    public Enumeration getCapFiles() {
        Vector retVal = new Vector();
        for (Enumeration e = getOption("-libcapfile"); e.hasMoreElements(); retVal.addElement(e.nextElement()));
        for (Enumeration e = getOption("-capfile"); e.hasMoreElements(); retVal.addElement(e.nextElement()));
        return retVal.elements();
    }
    
    public Enumeration getLibraryCapFiles() {
        return getOption("-libcapfile");
    }

    public Enumeration getScriptFiles() {
        return this.scripts.elements();
    }
    
    public Enumeration getNoConvertPackages() {
        return getOption("-noConversion");
    }

    public boolean doConversion(String packagename) {
        for (Enumeration nc = getNoConvertPackages(); nc.hasMoreElements();)
            if (packagename.equals((String)nc.nextElement()))
                return false;
        return true;
    }
    
    public Properties getProperties() {
        Properties retVal = new Properties();
        for (Enumeration e = getOption("-Property"); e.hasMoreElements();) {
            putPropertyLine(retVal, (String)e.nextElement());
        }
        return retVal;
    }
    
    public String getTestDir() {
        return getDirname(getSingleOption("-Test", false));
    }

    public String getClassDir() {
        return this.getSingleOption("-classdir", false);
    }
    
    public String getExportDir() {
        return this.getSingleOption("-exportdir", true);
    }

    public String getOutputDir() {
        return getFirstSingleOptionFromList(new String[] {"-outputrootdir", "-o"},
                                            false);
    }

    public String getCapFileDir() {
        String name = getSingleOption("-capfiledir", false);
        File test = new File(name);
        if (!test.exists() || test.isDirectory()) {
            return name;
        } else {
            return getDirname(name);
        }
    }
    
    public String getRefCapFileDir() {
        String name = getSingleOption("-refcapfiledir", true);
        if (name == null)
            return null;
        File test = new File(name);
        if (!test.exists() || test.isDirectory()) {
            return name;
        } else {
            return getDirname(name);
        }
    }

    public String getLibraryRoot() {
        return getSingleOption("-libdir", false);
    }

    public String getExportMapFile() {
        return this.getSingleOption("-exportmapfile", true);
    }
   
    public boolean intSupport() {
        return "intSupport".equals(this.getSingleOption("-x", "noIntSupport"));
    }

    public int getMajorVersion() {
        return parseInt(this.getSingleOption("-majorversion", DEFAULT_MAJOR_VERSION),
                        "major_version");
    }
    
    public int getMinorVersion() {
        return parseInt(this.getSingleOption("-minorversion", DEFAULT_MINOR_VERSION),
                        "minor_version");
    }

    public boolean isVerbose() {
        return (getFirstSingleOptionFromList(new String[] {"-v", "-Verbose",
                                                           "-verbose"},
                                             true) != null);
    }

    public String[] getCardServiceArgs() {
        Vector args = getOptionVector("-s");
        return (String[])((args == null) ? new String[0]
                          : args.toArray(new String[args.size()]));
    }
    

    public int getBundleSize() {
        return parseInt(this.getSingleOption("-bundle_size", DEFAULT_BUNDLE_SIZE),
                        "-bundle_size");
    }
    /**
     * This method parse Property line, which has the format &lt;key&gt;=&lt;value&gt;
     * and puts value to the given Properties.
     * If the line does not satisfies this format, then method does nothing.
     */
    private void putPropertyLine(Properties res, String line) {
        if (line != null) {
            int pos = line.indexOf('=');
            if ((pos > 0) && (pos < line.length() - 1)) {
                res.setProperty(line.substring(0, pos),
                                line.substring(pos + 1));
            }
        }
    }
    public String[] getExcludedTestCases() {
        Vector args = getOptionVector("-s");
        Vector retVal = new Vector();
        for (Enumeration e = getOption("-exclude"); e.hasMoreElements();) {
            StringTokenizer tokens = new StringTokenizer((String)e.nextElement(),
                                                         ",");
            while (tokens.hasMoreTokens()) {
                retVal.addElement(tokens.nextToken());
            }
        }
        return (String[])retVal.toArray(new String[retVal.size()]);
    }

    public byte getGET_RESPONSE_CLA_BYTE() {
        return (byte)parseInt(this.getSingleOption("-get_response_cla_byte", "0"),
                              "-get_response_cla_byte");
    }
    
    private int parseInt(String value, String name) {
        try {
            return Integer.parseInt(value);
        } catch (NumberFormatException e) {
            throw new IllegalArgumentException(I18n.getString("invalid.integer.value", name, value, e));
        }
    }

    public int getNuberOfReset() {
        return 10;
    }
    
    public boolean isDuplicatedByBothIO() {
        return (getSingleOption("-bothIO", null) != null);
    }
    
    public boolean isLoadStatusIgnored() {
        return (getSingleOption("-loadStatusIgnore", null) != null);
    }
};
