/**
 * %W% %E%
 * @Copyright
 */

package com.sun.javacard.cjck.invoke;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.NoSuchElementException;
import com.sun.javacard.cjck.I18n;

public class ArgumentParser {
    private Hashtable set;
    private Hashtable duplicates;
    private Hashtable one;
    private Hashtable two;
    
    public ArgumentParser() {
        this(null, null, null);
    }

    public ArgumentParser (String [] onePosition, String [] twoPosition,
                           String [] allowDuplicate) {
        this.set = new Hashtable();
        this.duplicates = createKeyHash(allowDuplicate);
        this.one = createKeyHash(onePosition);
        this.two = createKeyHash(twoPosition);
    }
    
    public void parseArgs(String args[]) {
        for (int i = 0; i < args.length; i++) {
            if (this.one.get(args[i]) != null) {
                this.setOption(args[i], "");
            } else if (this.two.get(args[i]) != null) {
                if (i < args.length - 1) {
                    this.setOption(args[i], args[++i]);
                } else {
                    throw new IllegalArgumentException(I18n.getString("bad.argument", args[i]));
                }
            } else {
                throw new IllegalArgumentException(I18n.getString("argument.not.specified", args[i]));
            }
        }
    }
    
    private Hashtable createKeyHash(String[] keys) {
        Hashtable retVal = new Hashtable();
        
        if (keys != null) {
            for (int i = 0; i < keys.length; i++) {
                retVal.put(keys[i], "ok");
            }
        }
        return retVal;
    }
        
    public void setOption(String option, String value, boolean isDuplicate) {
        Vector h = (Vector)set.get(option);
        if (h == null) {
            h = new Vector();
            set.put(option, h);
        } else {
            if (!isDuplicate) {
                throw new IllegalArgumentException(I18n.getString("option.can.not.duplicated", option));
            }
        }
        h.addElement(value);
    }
    
    public void setOption(String option, String value) {
        this.setOption(option, value, (duplicates.get(option) != null));
    }
    
    public String getSingleOption(String option, String defaultOption) {
        String retVal = getSingleOption(option, true);
        return (retVal == null) ? defaultOption : retVal;
    }
    
    public String getSingleOption(String option, boolean returnNull) {
        Vector h = (Vector)set.get(option);
        if (h == null) {
            if (returnNull) {
                return null;
            } else {
                throw new IllegalArgumentException(I18n.getString("undefined.option", option));
            }
        }
        if (h.size() != 1) {
            throw new IllegalArgumentException(I18n.getString("not.single.option", option, h));
        }
        return (String)h.elementAt(0);
    }
    
    public Enumeration getOption(String option) {
        Vector h = (Vector)set.get(option);
        if (h == null) {
            return new Vector().elements();
        } else {
            return h.elements();
        }
    }
    
    public Vector getOptionVector(String option) {
        return (Vector)set.get(option);
    }
        
      
    public int getOptionCount(String option) {
         Vector h = (Vector)set.get(option);
         if (h == null)
             return 0;
         return h.size();
    }
    
    public boolean contains(String option) {
        return (set.get(option) != null);
    }
    public String getFirstSingleOptionFromList(String options[],
                                               boolean returnNull) {
        String retVal = null;
        if ((options == null) || options.length == 0) {
            return getSingleOption(null, returnNull);
        }
            
        for (int i = 0; i < options.length - 1; i++) {
            retVal = getSingleOption(options[i], true);
            if (retVal != null)
                return retVal;
        }
        return getSingleOption(options[options.length - 1], returnNull);
    }
    
    public static String getDirname(String name) {
        int pos = name.lastIndexOf(java.io.File.separator);
        return (pos > 0) ? name.substring(0, pos) : "";
    }

    public static String getBasename(String name) {
        int pos = name.lastIndexOf(java.io.File.separator);
        if (pos < 0) {
            return name;
        }
        return (pos < name.length() - 1) ? name.substring(pos + 1) : name;
    }


}
