/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.javacard.cjck;

import java.text.DateFormat;
import java.text.MessageFormat;

import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18n {
    public static final String LOGGING_NAME = "com.sun.javacard.cjck.i18n";
    
    public static final String BUNDLE_NAME = "com/sun/javacard/cjck/i18n";
    private static ResourceBundle bundle;
    private static final DateFormat date_format = DateFormat.getDateInstance(DateFormat.LONG);
    private static final DateFormat time_format =  DateFormat.getDateInstance(DateFormat.LONG);

    static {
        try {
            bundle = ResourceBundle.getBundle(BUNDLE_NAME);
        } catch (MissingResourceException e) {
            e.printStackTrace();
        }
    }

    public static String getDate(Date date) {
        return date_format.format(date);
    }

    public static String getTime(Date date) {
        return time_format.format(date);
    }

    public static String getString(String key) {
        String retVal = getStringInternal(key);
        if (retVal == null) {
            return key;
        } else {
            return retVal;
        }
    }
    
    private static String getStringInternal(String key) {
        if (bundle == null) {
            return key;
        }
        try {
            return bundle.getString(key);
        } catch (Exception e) {
            return null;
        }
    }

    public static String getString(String pattern, Object[] params) {
        String iPattern = getStringInternal(pattern);
        if (iPattern == null) {
            return formatInternal(iPattern, params);
        }
        try {
            MessageFormat format = new MessageFormat(iPattern);
            return format.format(params);
        } catch (Exception e) {
            String retVal = formatInternal(iPattern, params);
            return retVal;
        }
    }
    
    public static String getString(String format, Object param1) {
        return getString(format, new Object[] {param1});
    }
    
    public static String getString(String format, Object param1, Object param2) {
        return getString(format, new Object[] {param1, param2});
    }
    
    public static String getString(String format, Object param1, Object param2, Object param3) {
        return getString(format, new Object[] {param1, param2, param3});
    }
    
    private static String formatInternal(String format, Object[] params) {
        StringBuffer buff = new StringBuffer(format);
        buff.append(':');
        for (int i = 0; i < params.length; i++) {
            buff.append(params[i]);
            buff.append(',');
        }
        return buff.toString();
    }
}
