/******************************************************************************
 *
 ******************************************************************************/
package uicc.hci.services.readermode;

import uicc.hci.framework.HCIService;

/** 
 * Service which enable Contactless Reader functionality.
 **/
public interface ReaderService extends HCIService {
    
    // ------------ Type --------------------
    /** ISO/IEC 14443 Type B reader RF */
    public final static byte TYPE_B_READER_RF = 0x11;
    
    /** ISO/IEC 14443 Type A reader RF */
    public final static byte TYPE_A_READER_RF = 0x13;

 
    /** 
     * This method returns the RF technology which the card is using,
     * that was discovered by the CLF.
     * 
     * <P>possible return values:
     * <ul>
     * <li>TYPE_B_READER_RF
     * <li>TYPE_A_READER_RF
     * </ul>
     * @return the reader RF type on which the service is connected.
     */
    public byte getReaderRFType();
}
