/******************************************************************************
 *
 ******************************************************************************/
package uicc.hci.services.readermode;

import uicc.hci.framework.HCIException;
import uicc.hci.framework.HCIMessage;
import javacard.framework.*;

/** 
 * The ReaderMessage offers specialized methods for generate
 * Contactless Reader commands or events.
 **/
public interface ReaderMessage extends HCIMessage {

    /** An Applet level time-out occurred.
     <span style="color:red"> it's the ANY_ Parameter not defined in HCIMessage ??? </span>  */
    public static final byte RESP_ANY_E_TIMEOUT = (byte) 0x09;
    
    /** The target has returned an RF error. */
    public static final byte RESP_WR_RF_ERROR = (byte) 0x10;
 
    /**  when there is a single target in the reader field and 
     * the activation of the target is completed 
     * */
    public final static byte SINGLE_TARGET_STATUS = (byte) 0x00;
    
    /**  
     * when there are several targets in the field irrespective 
     * of the RF technology */
    public final static byte MULTIPLE_TARGET_STATUS = (byte) 0x03;    
    
    // ------------ Type A parameters --------------------
    /** UID as defined in ISO/IEC 14443-3 for type A */
    public final static byte PARAM_ID_TYPE_A_READER_UID = (byte)0x02;
    
    /** Pre-formatted ATQA as defined in ISO/IEC 14443-3 for type A
     * (see TS 102 622 for coding of the value)
     */
    public final static byte PARAM_ID_TYPE_A_READER_ATQA = (byte)0x04;
    
    /** The historical bytes as defined in ISO/IEC 14443-3 for type A */
    public final static byte PARAM_ID_TYPE_A_READER_APPLICATION_DATA = (byte)0x05;
    
    /** Pre-formatted SAK as defined in ISO/IEC 14443-3 for type A */
    public final static byte PARAM_ID_TYPE_A_READER_SAK = (byte)0x03;
    
    /** SFGT Frame waiting time and start-up frame guard time as 
     * defined in ISO/IEC 14443-4 for type A*/
    public final static byte PARAM_ID_TYPE_A_READER_FWI = (byte)06;
    
    /** Maximum data rate supported */
    public final static byte PARAM_ID_TYPE_A_READER_DATARATE_MAX = (byte)0x01;

    // ------------ Type B parameters --------------------
     /** PUPI as defined in ISO/IEC 14443-3 for type B */
    public final static byte PARAM_ID_TYPE_B_READER_PUPI = (byte)0x03;
    
     /** Application data as defined in ISO/IEC 14443-3 for ATQB */
    public final static byte PARAM_ID_TYPE_B_READER_APPLICATION_DATA = (byte)0x04;
    
     /** Application family identifier as defined in ISO/IEC 14443-3 
      * for type B used by the reader to poll the target */
    public final static byte PARAM_ID_TYPE_B_READER_AFI = (byte)0x02;
    
     /** Higher layer response as defined in ISO/IEC 14443-3 for answer 
      * to ATTRIB command */
    public final static byte PARAM_ID_TYPE_B_READER_HIGHER_LAYER_RESPONSE = (byte)0x01;
    
     /** Higher layer data as defined in ISO/IEC 14443-3 for ATTRIB command */
    public final static byte PARAM_ID_TYPE_B_READER_HIGHER_LAYER_DATA = (byte)0x05;

    /** Time out values <span style="color:red"> does it make sense to have these values here defined how does the Applet developer know how to use them ??? </span>*/
    public final static byte TIMEOUT_300_MICS  = (byte)0x01;
    public final static byte TIMEOUT_600_MICS  = (byte)0x02;
    public final static byte TIMEOUT_1200_MICS = (byte)0x03;
    public final static byte TIMEOUT_2400_MICS = (byte)0x04;
    public final static byte TIMEOUT_4800_MICS = (byte)0x05;
    public final static byte TIMEOUT_9600_MICS = (byte)0x06;
    public final static byte TIMEOUT_19_MS     = (byte)0x07;
    public final static byte TIMEOUT_38_MS     = (byte)0x08;
    public final static byte TIMEOUT_77_MS     = (byte)0x09;
    public final static byte TIMEOUT_154_MS    = (byte)0x0A;
    public final static byte TIMEOUT_309_MS    = (byte)0x0B;
    public final static byte TIMEOUT_618_MS    = (byte)0x0C;
    public final static byte TIMEOUT_1_S       = (byte)0x0D;
    public final static byte TIMEOUT_2_S       = (byte)0x0E;
    public final static byte TIMEOUT_4_S       = (byte)0x0F;
    
    /** 
     * This method builds the HCI command ANY_GET_PARAMETER for the
     * indicated information and sends it to the Contactless Reader Gate of the CLF.
     *
     * The prepareGetParameterCommand method should only be called when the CLF 
     * has successfully discovered a card in the field, i.e. after reception of 
     * the HCI event EVT_TARGET_DISCOVERED.
     * 
     * @param paramID, shall be one of the PARAM_* values defined in this interface
     * @throws HCIException (editor's note: add exceptions)
     * @exception SystemException with the following reason code: <ul>
     *      <li><code>ILLEGAL_VALUE</code> <ul><li>if the paramID does not match with the predefined values</li></ul>
     * </span>
     */
    public void prepareAndSendGetParameterCommand(byte paramID) throws HCIException, SystemException;

    
    /**
     * This method builds the HCI command WR_XCHG_DATA with the data passed
     * in the parameter data and sends it to the Contactless Reader Gate of the CLF.
     * The response data from the CLF will be transferred to the UICC with the event
     * ReaderListener.EVENT_WRITE_EXCHANGE_DATA_RESPONSE.
     * <span style="color:red">
     * @param timeout -1 if no timeout, or one of the TIMEOUT_* values defined in this interface
     * @param data bytearray holding the data to send to the CLF
     * @param offset into the bytearray indicating the start of the data to send to the CLF
     * @param len overall length of data that will be send to the CLF
     * @throws uicc.hci.framework.HCIException (editor's note: add exceptions)
     * @exception NullPointerException  if <code>data</code> is <code>null</code>
     * @exception ArrayIndexOutOfBoundsException if operation would cause access of data outside
     *            array bounds.
     * @exception SystemException with the following reason code: <ul>
     *      <li><code>ILLEGAL_VALUE</code> <ul><li>if the timeout value does not match with the predefined values</li></ul>
     * </span>
     */
    public void prepareAndSendWriteXchgDataCommand(byte timeout, byte[] data, short offset, short len) throws HCIException,
                                                                                                              NullPointerException,
                                                                                                              ArrayIndexOutOfBoundsException,
                                                                                                              SystemException;
    

    /**
     * <span style="color:red">
     * This method sends first the HCI event EVT_END_OPERATION and then the
     * HCI event EVT_READER_REQUESTED.
     * </span>
     * This method is intended to recover from the following error states:
     * <li>reception of RESP_ANY_E_TIMEOUT
     * <li>reception of RESP_WR_RF_ERROR 
     * <li>reception of EVT_TARGET_DISCOVERED with a MULTIPLE_TARGET_STATUS
     * <span style="color:red">
     * @throws HCIException
     * (editor's note: which exceptions? 
     * new reason code 'not activated' or excisting exception: ACCESS_NOT_GRANTED)
     * </span>
     * 
     */
    public void restartReaderModeProcedure() throws HCIException;
}

