/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile.attributes;

import com.sun.javacard.classfile.attributes.JAttribute;
import com.sun.javacard.classfile.attributes.JExceptionRecord;
import com.sun.javacard.classfile.attributes.JLineNumberTableAttr;
import com.sun.javacard.classfile.attributes.JLocalVarTableAttr;
import com.sun.javacard.classfile.constants.JConstantPool;
import com.sun.javacard.classfile.instructions.JInstruction;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ResourceBundle;

public class JCodeAttr
extends JAttribute {
    protected static ResourceBundle messages = ResourceBundle.getBundle("com/sun/javacard/converter/MessagesBundle");
    private int max_stack;
    private int max_locals;
    private JInstruction code = null;
    private JExceptionRecord[] exceptions = null;
    private JLineNumberTableAttr linenumber_table_att = null;
    private JLocalVarTableAttr local_vars_table_att = null;
    private JAttribute[] attributes;

    JCodeAttr(JConstantPool cp) {
        super(cp);
    }

    public int getMaxStack() {
        return this.max_stack;
    }

    public int getMaxLocals() {
        return this.max_locals;
    }

    public JInstruction getCode() {
        return this.code;
    }

    public JExceptionRecord[] getExceptions() {
        return this.exceptions;
    }

    public JLineNumberTableAttr getLineNumberTableAttr() {
        return this.linenumber_table_att;
    }

    public JLocalVarTableAttr getLocalVarTableAttr() {
        return this.local_vars_table_att;
    }

    public JAttribute[] getAttributes() {
        return this.attributes;
    }

    public void resolve() {
        int i;
        JInstruction instr;
        for (instr = this.code; instr != null; instr = instr.getNextInstr()) {
            instr.resolve();
        }
        for (i = 0; i < this.exceptions.length; ++i) {
            this.exceptions[i].resolve();
        }
        for (i = 0; i < this.attributes.length; ++i) {
            if (this.attributes[i] instanceof JLineNumberTableAttr) {
                if (null != this.linenumber_table_att) {
                    throw new ClassFormatError(messages.getString("attr.1"));
                }
                this.linenumber_table_att = (JLineNumberTableAttr)this.attributes[i];
            }
            if (this.attributes[i] instanceof JLocalVarTableAttr) {
                if (null != this.local_vars_table_att) {
                    throw new ClassFormatError(messages.getString("attr.2"));
                }
                this.local_vars_table_att = (JLocalVarTableAttr)this.attributes[i];
            }
            this.attributes[i].resolve();
        }
        if (this.linenumber_table_att != null) {
            for (instr = this.code; instr != null; instr = instr.getNextInstr()) {
                int line_number = this.linenumber_table_att.getLineNumber(instr.getPC());
                instr.setSournceLineNumber(line_number);
            }
        }
    }

    public void parse(DataInputStream dis) throws IOException {
        JInstruction i;
        int length = dis.readInt();
        this.max_stack = dis.readUnsignedShort();
        this.max_locals = dis.readUnsignedShort();
        int code_length = dis.readInt();
        JInstruction prev_instr = this.code;
        for (int pc = 0; pc < code_length; pc += i.getSizeInBytes()) {
            int opcode = dis.readUnsignedByte();
            i = JInstruction.create(this.cp, pc, opcode);
            i.parse(dis);
            if (this.code == null) {
                this.code = i;
                prev_instr = i;
                continue;
            }
            prev_instr.setNextInstr(i);
            i.setPrevInstr(prev_instr);
            prev_instr = i;
        }
        int except_table_length = dis.readUnsignedShort();
        this.exceptions = new JExceptionRecord[except_table_length];
        for (int i2 = 0; i2 < except_table_length; ++i2) {
            int start_pc = dis.readUnsignedShort();
            int end_pc = dis.readUnsignedShort();
            int handler_pc = dis.readUnsignedShort();
            int catch_type_index = dis.readUnsignedShort();
            this.exceptions[i2] = new JExceptionRecord(start_pc, end_pc, handler_pc, catch_type_index, this.cp);
        }
        int attrib_count = dis.readUnsignedShort();
        this.attributes = new JAttribute[attrib_count];
        for (int i3 = 0; i3 < attrib_count; ++i3) {
            int index = dis.readUnsignedShort();
            this.attributes[i3] = JAttribute.create(this.cp, index);
            this.attributes[i3].parse(dis);
        }
    }
}

