/*
 * Decompiled with CFR 0.152.
 */
package javax.help.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.Enumeration;
import java.util.Vector;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.IndexItem;
import javax.help.IndexView;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelpContentViewer;
import javax.help.JHelpGlossaryNavigator;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.help.plaf.HelpNavigatorUI;
import javax.help.plaf.basic.BasicHelpUI;
import javax.help.plaf.basic.BasicIndexCellRenderer;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.RepaintManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class BasicGlossaryNavigatorUI
extends HelpNavigatorUI
implements HelpModelListener,
TreeSelectionListener,
PropertyChangeListener,
ActionListener,
Serializable {
    protected JHelpGlossaryNavigator index;
    protected JScrollPane sp;
    protected DefaultMutableTreeNode topNode;
    protected JTree tree;
    protected JTextField searchField;
    protected RuleBasedCollator rbc;
    protected String oldText;
    protected DefaultMutableTreeNode currentFindNode;
    protected JHelpContentViewer viewer;
    private static boolean debug = false;
    static /* synthetic */ Class class$javax$help$plaf$basic$BasicGlossaryNavigatorUI;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicGlossaryNavigatorUI((JHelpGlossaryNavigator)jComponent);
    }

    public BasicGlossaryNavigatorUI(JHelpGlossaryNavigator jHelpGlossaryNavigator) {
        this.setIcon(BasicHelpUI.getIcon(class$javax$help$plaf$basic$BasicGlossaryNavigatorUI == null ? (class$javax$help$plaf$basic$BasicGlossaryNavigatorUI = BasicGlossaryNavigatorUI.class$("javax.help.plaf.basic.BasicGlossaryNavigatorUI")) : class$javax$help$plaf$basic$BasicGlossaryNavigatorUI, "images/glossary.gif"));
    }

    public void installUI(JComponent jComponent) {
        BasicGlossaryNavigatorUI.debug("installUI");
        this.index = (JHelpGlossaryNavigator)jComponent;
        HelpModel helpModel = this.index.getModel();
        this.index.setLayout(new BorderLayout());
        this.index.addPropertyChangeListener(this);
        if (helpModel != null) {
            helpModel.addHelpModelListener(this);
        }
        this.topNode = new DefaultMutableTreeNode();
        JLabel jLabel = new JLabel(HelpUtilities.getString(HelpUtilities.getLocale(jComponent), "index.findLabel"));
        this.searchField = new JTextField();
        jLabel.setLabelFor(this.searchField);
        this.searchField.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jLabel);
        jPanel.add(this.searchField);
        this.index.add("North", jPanel);
        this.tree = new JTree(this.topNode);
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        treeSelectionModel.addTreeSelectionListener(this);
        this.tree.setShowsRootHandles(false);
        this.tree.setRootVisible(false);
        this.setCellRenderer(this.index.getNavigatorView(), this.tree);
        this.sp = new JScrollPane();
        this.sp.getViewport().add(this.tree);
        this.index.add("Center", this.sp);
        this.viewer = new JHelpContentViewer(helpModel.getHelpSet());
        this.sp = new JScrollPane();
        this.sp.getViewport().add(this.viewer);
        this.index.add("South", this.sp);
        this.reloadData();
    }

    protected void setCellRenderer(NavigatorView navigatorView, JTree jTree) {
        jTree.setCellRenderer(new BasicIndexCellRenderer());
    }

    public void uninstallUI(JComponent jComponent) {
        BasicGlossaryNavigatorUI.debug("uninstallUI");
        HelpModel helpModel = this.index.getModel();
        this.index.removePropertyChangeListener(this);
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        treeSelectionModel.removeTreeSelectionListener(this);
        this.index.setLayout(null);
        this.index.removeAll();
        if (helpModel != null) {
            helpModel.removeHelpModelListener(this);
        }
        this.index = null;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return new Dimension(200, 100);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return new Dimension(100, 100);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    private void reloadData() {
        BasicGlossaryNavigatorUI.debug("reloadData");
        if (this.index.getModel() == null) {
            return;
        }
        this.topNode.removeAllChildren();
        IndexView indexView = (IndexView)this.index.getNavigatorView();
        if (indexView == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = indexView.getDataAsTree();
        while (defaultMutableTreeNode.getChildCount() > 0) {
            this.topNode.add((DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild());
        }
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.setVisibility(this.topNode);
    }

    public void merge(NavigatorView navigatorView) {
        BasicGlossaryNavigatorUI.debug("merging data");
        IndexView indexView = (IndexView)navigatorView;
        DefaultMutableTreeNode defaultMutableTreeNode = indexView.getDataAsTree();
        while (defaultMutableTreeNode.getChildCount() > 0) {
            this.topNode.add((DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild());
        }
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.setVisibility(this.topNode);
    }

    public void remove(NavigatorView navigatorView) {
        BasicGlossaryNavigatorUI.debug("removing " + navigatorView);
        Enumeration<TreeNode> enumeration = this.topNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            BasicGlossaryNavigatorUI.debug("  A child of topNode: " + defaultMutableTreeNode);
        }
        this.remove(this.topNode, navigatorView.getHelpSet());
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.setVisibility(this.topNode);
    }

    private void remove(DefaultMutableTreeNode defaultMutableTreeNode, HelpSet helpSet) {
        BasicGlossaryNavigatorUI.debug("remove(" + defaultMutableTreeNode + ", " + helpSet + ")");
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            BasicGlossaryNavigatorUI.debug("  considering " + defaultMutableTreeNode2);
            IndexItem indexItem = (IndexItem)defaultMutableTreeNode2.getUserObject();
            HelpSet helpSet2 = indexItem.getHelpSet();
            if (helpSet2 != null && helpSet.contains(helpSet2)) {
                BasicGlossaryNavigatorUI.debug("  tagging for removal: " + defaultMutableTreeNode2);
                vector.addElement(defaultMutableTreeNode2);
                continue;
            }
            this.remove(defaultMutableTreeNode2, helpSet);
        }
        int n = 0;
        while (n < vector.size()) {
            BasicGlossaryNavigatorUI.debug("  removing " + vector.elementAt(n));
            defaultMutableTreeNode.remove((DefaultMutableTreeNode)vector.elementAt(n));
            ++n;
        }
    }

    private void setVisibility(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.tree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
        if (!defaultMutableTreeNode.isLeaf()) {
            int n = defaultMutableTreeNode.getChildCount();
            int n2 = 0;
            while (n2 < n) {
                this.setVisibility((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2));
                ++n2;
            }
        }
    }

    public void idChanged(HelpModelEvent helpModelEvent) {
        Map.ID iD;
        Serializable serializable;
        IndexItem indexItem;
        Object object;
        TreePath treePath;
        Map.ID iD2 = helpModelEvent.getID();
        HelpModel helpModel = this.index.getModel();
        BasicGlossaryNavigatorUI.debug("idChanged(" + helpModelEvent + ")");
        if (helpModelEvent.getSource() != helpModel) {
            System.err.println("Internal inconsistency!");
            System.err.println("  " + helpModelEvent.getSource() + " != " + helpModel);
            throw new Error("Internal error");
        }
        if (iD2 == null) {
            // empty if block
        }
        if ((treePath = this.tree.getSelectionPath()) != null && (object = treePath.getLastPathComponent()) instanceof DefaultMutableTreeNode && (indexItem = (IndexItem)(serializable = (DefaultMutableTreeNode)object).getUserObject()) != null && (iD = indexItem.getID()) != null && iD.equals(iD2)) {
            return;
        }
        object = this.findID(this.topNode, iD2);
        if (object == null) {
            this.tree.clearSelection();
            return;
        }
        serializable = new TreePath(((DefaultMutableTreeNode)object).getPath());
        this.tree.expandPath((TreePath)serializable);
        this.tree.setSelectionPath((TreePath)serializable);
        this.tree.scrollPathToVisible((TreePath)serializable);
    }

    private DefaultMutableTreeNode findID(DefaultMutableTreeNode defaultMutableTreeNode, Map.ID iD) {
        BasicGlossaryNavigatorUI.debug("findID: (" + iD + ")");
        BasicGlossaryNavigatorUI.debug("  node: " + defaultMutableTreeNode);
        if (iD == null) {
            return null;
        }
        IndexItem indexItem = (IndexItem)defaultMutableTreeNode.getUserObject();
        if (indexItem != null) {
            Map.ID iD2 = indexItem.getID();
            BasicGlossaryNavigatorUI.debug("  testID: " + iD2);
            if (iD2 != null && iD2.equals(iD)) {
                return defaultMutableTreeNode;
            }
        }
        int n = defaultMutableTreeNode.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
            DefaultMutableTreeNode defaultMutableTreeNode3 = this.findID(defaultMutableTreeNode2, iD);
            if (defaultMutableTreeNode3 != null) {
                return defaultMutableTreeNode3;
            }
            ++n2;
        }
        return null;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = this.tree.getSelectionPath();
        BasicGlossaryNavigatorUI.debug("valueChanged; path: " + treePath);
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        IndexItem indexItem = (IndexItem)defaultMutableTreeNode.getUserObject();
        if (indexItem != null && indexItem.getID() != null) {
            try {
                this.viewer.getModel().setCurrentID(indexItem.getID());
            }
            catch (InvalidHelpSetContextException invalidHelpSetContextException) {
                BasicGlossaryNavigatorUI.debug("BadID");
                return;
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        BasicGlossaryNavigatorUI.debug("propertyChange: " + propertyChangeEvent.getSource() + " " + propertyChangeEvent.getPropertyName());
        if (propertyChangeEvent.getSource() == this.index) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("helpModel")) {
                this.reloadData();
            } else if (string.equals("font")) {
                BasicGlossaryNavigatorUI.debug("Font change");
                Font font = (Font)propertyChangeEvent.getNewValue();
                this.tree.setFont(font);
                RepaintManager.currentManager(this.tree).markCompletelyDirty(this.tree);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.searchField) {
            this.rbc = (RuleBasedCollator)Collator.getInstance(this.index.getLocale());
            String string = this.searchField.getText();
            if (string != null) {
                string = string.toLowerCase();
            }
            if (this.oldText != null && string.compareTo(this.oldText) != 0) {
                this.currentFindNode = null;
            }
            this.oldText = string;
            DefaultMutableTreeNode defaultMutableTreeNode = this.searchName(this.topNode, string);
            if (defaultMutableTreeNode == null) {
                this.currentFindNode = null;
                this.index.getToolkit().beep();
                return;
            }
            this.currentFindNode = defaultMutableTreeNode;
            TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            this.tree.scrollPathToVisible(treePath);
            this.tree.expandPath(treePath);
            this.tree.setSelectionPath(treePath);
        }
    }

    private DefaultMutableTreeNode searchName(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        if (this.currentFindNode == null) {
            String string2;
            IndexItem indexItem = (IndexItem)defaultMutableTreeNode.getUserObject();
            if (indexItem != null && (string2 = indexItem.getName()) != null && HelpUtilities.isStringInString(this.rbc, string, string2 = string2.toLowerCase())) {
                return defaultMutableTreeNode;
            }
        } else if (this.currentFindNode == defaultMutableTreeNode) {
            this.currentFindNode = null;
        }
        int n = defaultMutableTreeNode.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
            DefaultMutableTreeNode defaultMutableTreeNode3 = this.searchName(defaultMutableTreeNode2, string);
            if (defaultMutableTreeNode3 != null) {
                return defaultMutableTreeNode3;
            }
            ++n2;
        }
        return null;
    }

    private static void debug(String string) {
        if (debug) {
            System.out.println("BasicGlossaryNavigatorUI: " + string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

