/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import java.util.Vector;

public class Timer {
    private static int threadInitNumber;
    private Vector entries = new Vector();
    private boolean acceptingRequests = true;

    public Timer() {
        Thread thread = new Thread(){

            public void run() {
                try {
                    Entry entry;
                    while ((entry = Timer.this.getNextEntry()) != null) {
                        entry.obj.timeout();
                        entry = null;
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        };
        thread.setName("Timer" + Timer.nextThreadNum());
        thread.setDaemon(true);
        thread.start();
    }

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Entry requestDelayedCallback(Timeable timeable, long l) {
        Entry entry;
        try {
            long l2 = System.currentTimeMillis() + l;
            Entry entry2 = new Entry(timeable, l2);
            int n = 0;
            while (true) {
                if (n >= this.entries.size()) {
                    this.entries.addElement(entry2);
                    entry = entry2;
                    break;
                }
                entry = (Entry)this.entries.elementAt(n);
                if (entry2.expiration < entry.expiration) {
                    this.entries.insertElementAt(entry2, n);
                    Entry entry3 = entry2;
                    Object var11_8 = null;
                    this.notify();
                    return entry3;
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            this.notify();
            throw throwable;
        }
        Object var11_9 = null;
        this.notify();
        return entry;
    }

    public synchronized void cancel(Entry entry) {
        this.entries.removeElement(entry);
        this.notify();
    }

    public synchronized void finished() {
        this.acceptingRequests = false;
        this.notify();
    }

    private synchronized Entry getNextEntry() throws InterruptedException {
        while (this.acceptingRequests) {
            if (this.entries.size() == 0) {
                this.wait();
                continue;
            }
            long l = System.currentTimeMillis();
            Entry entry = (Entry)this.entries.elementAt(0);
            if (entry.expiration <= l) {
                this.entries.removeElementAt(0);
                return entry;
            }
            this.wait(entry.expiration - l);
            l = System.currentTimeMillis();
        }
        return null;
    }

    public class Entry {
        Timeable obj;
        long expiration;

        Entry(Timeable timeable, long l) {
            this.obj = timeable;
            this.expiration = l;
        }
    }

    public static interface Timeable {
        public void timeout();
    }
}

