/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class TextWriter
extends FilterWriter {
    private boolean autoFlush = false;
    private String lineSeparator;

    public TextWriter(Writer writer) {
        this(writer, false);
    }

    public TextWriter(Writer writer, boolean bl) {
        super(writer);
        this.autoFlush = bl;
        this.lineSeparator = System.getProperty("line.separator");
    }

    public void print(boolean bl) throws IOException {
        this.write(bl ? "true" : "false");
    }

    public void print(char c) throws IOException {
        this.write(String.valueOf(c));
    }

    public void print(int n) throws IOException {
        this.write(String.valueOf(n));
    }

    public void print(long l) throws IOException {
        this.write(String.valueOf(l));
    }

    public void print(float f) throws IOException {
        this.write(String.valueOf(f));
    }

    public void print(double d) throws IOException {
        this.write(String.valueOf(d));
    }

    public void print(char[] cArray) throws IOException {
        this.write(cArray);
    }

    public void print(String string) throws IOException {
        if (string == null) {
            string = "null";
        }
        this.write(string);
    }

    public void print(Object object) throws IOException {
        this.write(String.valueOf(object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.write(this.lineSeparator);
            if (this.autoFlush) {
                this.out.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(boolean bl) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(bl);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char c) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(c);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(n);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(l);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(float f) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(f);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(double d) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(d);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] cArray) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(cArray);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String string) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(string);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object object) throws IOException {
        Object object2 = this.lock;
        synchronized (object2) {
            this.print(object);
            this.println();
        }
    }
}

