/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class PrefixMap
implements Map {
    private Map map;
    private String prefix;

    public PrefixMap(Map map, String string) {
        this.map = map;
        this.prefix = string + ".";
    }

    public void clear() {
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.startsWith(this.prefix)) continue;
            iterator.remove();
        }
    }

    public String getPrefix() {
        if (this.prefix.length() > 1) {
            return this.prefix.substring(0, this.prefix.length() - 1);
        }
        return "";
    }

    public boolean containsKey(Object object) {
        return this.map.containsKey(this.prefix + object);
    }

    public boolean containsValue(Object object) {
        Iterator iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            if (!string.startsWith(this.prefix) || !entry.getValue().equals(object)) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        HashMap hashMap = new HashMap();
        Iterator iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            if (!string.startsWith(this.prefix)) continue;
            hashMap.put(string.substring(this.prefix.length()), entry.getValue());
        }
        return hashMap.entrySet();
    }

    public Object get(Object object) {
        return this.map.get(this.prefix + object);
    }

    public int hashCode() {
        return this.map.hashCode() + this.prefix.hashCode();
    }

    public boolean isEmpty() {
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.startsWith(this.prefix)) continue;
            return false;
        }
        return true;
    }

    public Set keySet() {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.startsWith(this.prefix)) continue;
            hashSet.add(string.substring(this.prefix.length()));
        }
        return hashSet;
    }

    public Object put(Object object, Object object2) {
        return this.map.put(this.prefix + object, object2);
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            this.put(this.prefix + string, entry.getValue());
        }
    }

    public Object remove(Object object) {
        return this.map.remove(this.prefix + object);
    }

    public int size() {
        int n = 0;
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.startsWith(this.prefix)) continue;
            ++n;
        }
        return n;
    }

    public Collection values() {
        Vector vector = new Vector();
        Iterator iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            if (!string.startsWith(this.prefix)) continue;
            vector.add(entry.getValue());
        }
        return vector;
    }
}

