/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

public class Fifo {
    private static final int defaultInitialSlots = 16;
    private Object[] buf;
    private int bufSize;
    private int insertSlot;
    private int removeSlot;
    private int entries;

    public Fifo() {
        this(16);
    }

    public Fifo(int n) {
        this.bufSize = n;
        this.buf = new Object[this.bufSize];
        this.insertSlot = 0;
        this.removeSlot = 0;
        this.entries = 0;
    }

    public synchronized boolean isEmpty() {
        return this.entries == 0;
    }

    public synchronized int size() {
        return this.entries;
    }

    public synchronized void insert(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.entries == this.bufSize) {
            int n = 2 * this.bufSize;
            Object[] objectArray = new Object[n];
            int n2 = this.entries;
            int n3 = 0;
            while (this.entries > 0) {
                objectArray[n3] = this.remove();
                ++n3;
            }
            this.entries = n2;
            this.buf = objectArray;
            this.bufSize = n;
            this.removeSlot = 0;
            this.insertSlot = this.entries;
        }
        this.buf[this.insertSlot] = object;
        this.insertSlot = (this.insertSlot + 1) % this.bufSize;
        ++this.entries;
    }

    public synchronized Object remove() {
        if (this.entries == 0) {
            return null;
        }
        Object object = this.buf[this.removeSlot];
        this.buf[this.removeSlot] = null;
        this.removeSlot = (this.removeSlot + 1) % this.bufSize;
        --this.entries;
        return object;
    }

    public synchronized void flush() {
        this.insertSlot = 0;
        this.removeSlot = 0;
        this.entries = 0;
        int n = 0;
        while (n < this.buf.length) {
            this.buf[n] = null;
            ++n;
        }
    }
}

