/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import java.lang.reflect.Array;

public final class DynamicArray {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object[] append(Object[] objectArray, Object object) {
        Object[] objectArray2;
        if (objectArray == null) {
            if (object == null) throw new IllegalArgumentException("Cannot add null item to null array.");
            objectArray2 = (Object[])Array.newInstance(object.getClass(), 1);
            objectArray2[0] = object;
            return objectArray2;
        } else {
            objectArray2 = (Object[])Array.newInstance(DynamicArray.getArrayClass(objectArray), objectArray.length + 1);
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            objectArray2[objectArray2.length - 1] = object;
        }
        return objectArray2;
    }

    public static Object[] append(Object[] objectArray, Object object, Class clazz) {
        Object[] objectArray2 = objectArray == null && clazz != null ? (Object[])Array.newInstance(clazz, 0) : objectArray;
        return DynamicArray.append(objectArray2, object);
    }

    public static Object[] join(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            return objectArray2;
        }
        if (objectArray2 == null) {
            return objectArray;
        }
        Class<?> clazz = objectArray.getClass().getComponentType();
        int n = objectArray.length + objectArray2.length;
        Object[] objectArray3 = (Object[])Array.newInstance(clazz, n);
        System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
        System.arraycopy(objectArray2, 0, objectArray3, objectArray.length, objectArray2.length);
        return objectArray3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object[] insert(Object[] objectArray, Object object, int n) {
        Object[] objectArray2;
        if (objectArray == null) {
            if (object == null) throw new IllegalArgumentException("Cannot add null item to null array.");
            objectArray2 = (Object[])Array.newInstance(object.getClass(), 1);
            objectArray2[0] = object;
            return objectArray2;
        } else {
            if (n > objectArray.length) {
                throw new IllegalArgumentException("Index location too large (" + n + ").");
            }
            objectArray2 = (Object[])Array.newInstance(DynamicArray.getArrayClass(objectArray), objectArray.length + 1);
            if (n == 0) {
                objectArray2[0] = object;
                System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
                return objectArray2;
            } else {
                System.arraycopy(objectArray, 0, objectArray2, 0, n);
                objectArray2[n] = object;
                System.arraycopy(objectArray, n, objectArray2, n + 1, objectArray.length - n);
            }
        }
        return objectArray2;
    }

    public static Object[] remove(Object[] objectArray, int n) {
        Object[] objectArray2;
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot remove from null array.");
        }
        if (n > objectArray.length - 1 || n < 0) {
            throw new IllegalArgumentException("Index to remove from array is invalid (too small/large).");
        }
        if (n == 0) {
            objectArray2 = (Object[])Array.newInstance(DynamicArray.getArrayClass(objectArray), objectArray.length - 1);
            System.arraycopy(objectArray, 1, objectArray2, 0, objectArray.length - 1);
        } else if (n == objectArray.length - 1) {
            objectArray2 = (Object[])Array.newInstance(DynamicArray.getArrayClass(objectArray), objectArray.length - 1);
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length - 1);
        } else {
            objectArray2 = (Object[])Array.newInstance(DynamicArray.getArrayClass(objectArray), objectArray.length - 1);
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
            System.arraycopy(objectArray, n + 1, objectArray2, n, objectArray.length - n - 1);
        }
        return objectArray2;
    }

    public static Object[] remove(Object[] objectArray, Object object) {
        int n;
        Object[] objectArray2 = objectArray == null ? objectArray : ((n = DynamicArray.find(objectArray, object)) != -1 ? DynamicArray.remove(objectArray, n) : objectArray);
        return objectArray2;
    }

    public static int find(Object[] objectArray, Object object) {
        int n = -1;
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2] == object) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    protected static Class getArrayClass(Object[] objectArray) {
        if (objectArray != null) {
            return objectArray.getClass().getComponentType();
        }
        return null;
    }
}

