/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;

public class DirectoryClassLoader
extends ClassLoader {
    private File loadDir;
    private Hashtable classes = new Hashtable();

    public DirectoryClassLoader(File file) {
        this.loadDir = file;
    }

    public DirectoryClassLoader(String string) {
        this.loadDir = new File(string);
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = (Class)this.classes.get(string);
        if (clazz == null) {
            try {
                clazz = this.findSystemClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = this.locateClass(string);
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    public InputStream getResourceAsStream(String string) {
        URL uRL = this.getResource(string);
        try {
            return uRL != null ? uRL.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public URL getResource(String string) {
        URL uRL = ClassLoader.getSystemResource(string);
        if (uRL == null) {
            uRL = this.findResource(string);
        }
        return uRL;
    }

    public URL findResource(String string) {
        try {
            File file = new File(this.loadDir, string);
            if (file.exists()) {
                return new URL("file:" + file.getAbsolutePath());
            }
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized Class locateClass(String string) throws ClassNotFoundException {
        Class<?> clazz = (Class<?>)this.classes.get(string);
        if (clazz != null) {
            return clazz;
        }
        String string2 = string.replace('.', '/') + ".class";
        File file = new File(this.loadDir, string2);
        try {
            byte[] byArray;
            block9: {
                FileInputStream fileInputStream = new FileInputStream(file);
                try {
                    int n = ((InputStream)fileInputStream).available();
                    byArray = new byte[n];
                    int n2 = 0;
                    while (true) {
                        if (n2 >= byArray.length) {
                            Object var10_11 = null;
                            if (fileInputStream == null) break block9;
                            break;
                        }
                        n2 += ((InputStream)fileInputStream).read(byArray, n2, byArray.length - n2);
                    }
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    if (fileInputStream != null) {
                        ((InputStream)fileInputStream).close();
                    }
                    throw throwable;
                }
                ((InputStream)fileInputStream).close();
            }
            clazz = this.defineClass(string, byArray, 0, byArray.length);
            this.classes.put(string, clazz);
            return clazz;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ClassNotFoundException(string);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(string);
        }
    }
}

