/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class Debug {
    private static final String SEPARATOR = ".";
    private static final String DEBUG_PREFIX = "debug.";
    private static final String WILD_SUFFIX = "*";
    private static final String TRUE_STRING = "true";
    private static final String MASTER_KEY = "debug.disable";
    private static Properties givenProps;
    private static Properties dProps;
    private static WildcardProperties wildProps;
    private static PrintWriter out;
    private static boolean defaultBool;
    private static int defaultInt;
    private static boolean masterSwitch;

    private Debug() {
    }

    public static void print(String string) {
        out.print(string);
        out.flush();
    }

    public static void println(String string) {
        out.println(string);
        out.flush();
    }

    public static boolean isEnabled() {
        return masterSwitch;
    }

    public static String getSetting(String string) {
        if (!masterSwitch) {
            return null;
        }
        String string2 = dProps.getProperty(string);
        if (string2 != null) {
            return string2;
        }
        string2 = wildProps.search(string);
        return string2;
    }

    public static boolean getBoolean(Class clazz) {
        Debug.init(false);
        if (!masterSwitch) {
            return false;
        }
        String string = Debug.getName(clazz);
        String string2 = Debug.getSetting(string);
        boolean bl = Debug.convertToBool(string2);
        return bl;
    }

    public static boolean getBoolean(Class clazz, String string) {
        Debug.init(false);
        if (!masterSwitch) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer(Debug.getName(clazz));
        if (string != null && string.length() != 0) {
            stringBuffer.append(SEPARATOR);
            stringBuffer.append(string);
        }
        String string2 = stringBuffer.toString();
        String string3 = Debug.getSetting(string2);
        boolean bl = Debug.convertToBool(string3);
        return bl;
    }

    public static boolean getBoolean(String string) {
        Debug.init(false);
        if (!masterSwitch || string == null) {
            return false;
        }
        String string2 = Debug.getSetting(string);
        boolean bl = Debug.convertToBool(string2);
        return bl;
    }

    public static int getInt(Class clazz) {
        Debug.init(false);
        if (!masterSwitch || clazz == null) {
            return 0;
        }
        String string = Debug.getName(clazz);
        String string2 = Debug.getSetting(string);
        int n = Debug.convertToInt(string2);
        return n;
    }

    public static int getInt(Class clazz, String string) {
        Debug.init(false);
        if (!masterSwitch || clazz == null) {
            return 0;
        }
        StringBuffer stringBuffer = new StringBuffer(Debug.getName(clazz));
        if (string != null && string.length() != 0) {
            stringBuffer.append(SEPARATOR);
            stringBuffer.append(string);
        }
        String string2 = stringBuffer.toString();
        String string3 = Debug.getSetting(string2);
        int n = Debug.convertToInt(string3);
        return n;
    }

    public static int getInt(String string) {
        Debug.init(false);
        if (!masterSwitch) {
            return 0;
        }
        String string2 = Debug.getSetting(string);
        return Debug.convertToInt(string2);
    }

    public static PrintWriter getWriter() {
        return out;
    }

    public static void setProperties(Properties properties) {
        givenProps = properties;
    }

    public static void init(boolean bl) {
        Properties properties;
        if (dProps != null && !bl) {
            return;
        }
        try {
            properties = System.getProperties();
        }
        catch (SecurityException securityException) {
            properties = givenProps;
        }
        if (properties == null) {
            masterSwitch = false;
            return;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        dProps = new Properties();
        wildProps = new WildcardProperties();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith(DEBUG_PREFIX)) continue;
            if (string.equalsIgnoreCase(MASTER_KEY)) {
                String string2 = properties.getProperty(string);
                if (!string2.equalsIgnoreCase(TRUE_STRING)) continue;
                masterSwitch = false;
                continue;
            }
            if (string.endsWith(WILD_SUFFIX)) {
                ((Hashtable)wildProps).put(string.substring(DEBUG_PREFIX.length()), properties.getProperty(string));
                continue;
            }
            ((Hashtable)dProps).put(string.substring(DEBUG_PREFIX.length()), properties.getProperty(string));
        }
    }

    private static String getName(Class clazz) {
        String string = clazz.getName();
        string = string.replace('$', '.');
        return string;
    }

    private static boolean convertToBool(String string) {
        if (string == null) {
            return false;
        }
        if (string.equalsIgnoreCase(TRUE_STRING)) {
            return true;
        }
        try {
            int n = Integer.parseInt(string);
            return n > 0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static int convertToInt(String string) {
        if (string == null) {
            return 0;
        }
        if (string.equalsIgnoreCase(TRUE_STRING)) {
            return 1;
        }
        try {
            int n = Integer.parseInt(string);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private static void setEnabled(String string, boolean bl) {
    }

    private static void setEnabled(String string, int n) {
    }

    private static void setOutput(PrintWriter printWriter) {
        out = printWriter;
    }

    static {
        defaultBool = false;
        defaultInt = 0;
        masterSwitch = true;
        out = new PrintWriter(System.err);
    }

    private static class WildcardProperties
    extends Properties {
        static final String wildTail = ".*";

        private WildcardProperties() {
        }

        public String search(String string) {
            String string2 = string.toLowerCase();
            String string3 = this.trimTarget(string2);
            Enumeration<?> enumeration = this.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                String string5 = string4.toLowerCase();
                if (!string5.startsWith(string3)) continue;
                String string6 = string5.substring(string3.length());
                String string7 = string5.substring(0, string3.length());
                if (!string6.equals(wildTail) && !string7.equals(string2)) continue;
                return this.getProperty(string4);
            }
            return null;
        }

        String trimTarget(String string) {
            int n = string.lastIndexOf(Debug.SEPARATOR);
            if (n != -1) {
                return string.substring(0, n);
            }
            return string;
        }
    }
}

