/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.tool.IconFactory;
import com.sun.javatest.tool.TestSuiteChooser;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.FileInfoCache;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;

public class WorkDirChooser
extends JFileChooser {
    public static final int NEW = 0;
    public static final int OPEN_FOR_ANY_TESTSUITE = 1;
    public static final int OPEN_FOR_GIVEN_TESTSUITE = 2;
    private FileInfoCache cache = new FileInfoCache(60000);
    private int mode;
    private TestSuite testSuite;
    private TestSuiteChooser testSuiteChooser;
    private WorkDirectory workDir;
    private UIFactory uif;
    private Icon icon;

    public WorkDirChooser() {
        this(new File(System.getProperty("user.dir")));
    }

    public WorkDirChooser(File file) {
        super(WorkDirChooser.normalize(file));
        this.setName("wdc");
        this.uif = new UIFactory(this);
        this.icon = IconFactory.getSelectableFolderIcon();
        this.setAcceptAllFileFilterUsed(false);
        this.setFileFilter(new WDC_FileFilter());
        this.setFileView(new WDC_FileView());
        this.setFileSelectionMode(2);
    }

    public void setMode(int n) {
        this.mode = n;
        switch (n) {
            case 0: {
                this.setApproveButtonText(this.uif.getI18NString("wdc.new.btn"));
                this.setApproveButtonToolTipText(this.uif.getI18NString("wdc.new.tip"));
                this.setDialogTitle(this.uif.getI18NString("wdc.new.title"));
                break;
            }
            case 1: 
            case 2: {
                this.setApproveButtonText(this.uif.getI18NString("wdc.open.btn"));
                this.setApproveButtonToolTipText(this.uif.getI18NString("wdc.open.tip"));
                this.setDialogTitle(this.uif.getI18NString("wdc.open.title"));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setTestSuite(TestSuite testSuite) {
        this.testSuite = testSuite;
    }

    public void setTestSuiteChooser(TestSuiteChooser testSuiteChooser) {
        this.testSuiteChooser = testSuiteChooser;
    }

    public WorkDirectory getSelectedWorkDirectory() {
        return this.workDir;
    }

    public void setSelectedWorkDirectory(WorkDirectory workDirectory) {
        if (workDirectory != null) {
            this.setSelectedFile(workDirectory.getRoot());
        }
        this.workDir = workDirectory;
    }

    public int showDialog(Component component) {
        return this.showDialog(component, this.getApproveButtonText());
    }

    public void approveSelection() {
        File file = this.getSelectedFile();
        if (this.mode == 0) {
            this.approveNewSelection(file);
        } else {
            this.approveOpenSelection(file);
        }
    }

    private void approveNewSelection(File file) {
        if (this.testSuite == null) {
            throw new IllegalStateException();
        }
        if (file.exists()) {
            if (this.isWorkDirectory(file)) {
                this.approveNewSelection_workDirExists(file);
            } else if (this.isDirectory(file)) {
                this.approveNewSelection_dirExists(file);
            } else {
                this.uif.showError("wdc.notADir", file);
            }
        } else {
            this.approveNewSelection_dirNotFound(file);
        }
    }

    private void approveNewSelection_workDirExists(File file) {
        int n = this.uif.showYesNoDialog("wdc.exists_openIt");
        if (n != 0) {
            return;
        }
        try {
            this.workDir = WorkDirectory.open(file, this.testSuite);
            if (this.testSuite != null && this.workDir.getTestSuite() != this.testSuite) {
                this.uif.showError("wdc.wrongTS");
                return;
            }
            super.approveSelection();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.uif.showError("wdc.cantFindDir", file.getPath());
        }
        catch (WorkDirectory.MismatchFault mismatchFault) {
            this.uif.showError("wdc.wrongTS");
        }
        catch (WorkDirectory.Fault fault) {
            this.uif.showError("wdc.cantOpen", fault.getMessage());
        }
    }

    private void approveNewSelection_dirExists(File file) {
        int n = this.uif.showYesNoDialog("wdc.existsNotWorkDir_convert");
        if (n != 0) {
            return;
        }
        try {
            this.workDir = WorkDirectory.convert(file, this.testSuite);
            super.approveSelection();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.uif.showError("wdc.cantFindDir", file.getPath());
        }
        catch (WorkDirectory.Fault fault) {
            this.uif.showError("wdc.cantConvert", fault.getMessage());
        }
    }

    private void approveNewSelection_dirNotFound(File file) {
        try {
            this.workDir = WorkDirectory.create(file, this.testSuite);
            super.approveSelection();
        }
        catch (WorkDirectory.Fault fault) {
            this.uif.showError("wdc.cantCreate", fault.getMessage());
        }
    }

    private void approveOpenSelection(File file) {
        if (file.exists()) {
            if (this.isWorkDirectory(file)) {
                this.approveOpenSelection_workDirExists(file);
            } else if (this.isDirectory(file)) {
                this.approveOpenSelection_dirExists(file);
            } else {
                this.uif.showError("wdc.notADir", file);
            }
        } else {
            this.approveOpenSelection_dirNotFound(file);
        }
    }

    private void approveOpenSelection_workDirExists(File file) {
        try {
            switch (this.mode) {
                case 2: {
                    if (this.testSuite == null) {
                        throw new IllegalStateException();
                    }
                    this.workDir = WorkDirectory.open(file, this.testSuite);
                    if (this.workDir.getTestSuite() == this.testSuite) break;
                    this.uif.showError("wdc.wrongTS");
                    return;
                }
                case 1: {
                    try {
                        this.workDir = WorkDirectory.open(file);
                    }
                    catch (WorkDirectory.TestSuiteFault testSuiteFault) {
                        int n = this.uif.showYesNoDialog("wdc.tsError_specifyNew", testSuiteFault.getMessage());
                        if (n != 0) {
                            return;
                        }
                        if (this.testSuite != null) {
                            this.testSuiteChooser.setSelectedTestSuite(this.testSuite);
                        }
                        this.testSuiteChooser.showDialog(this.getParent());
                        TestSuite testSuite = this.testSuiteChooser.getSelectedTestSuite();
                        if (testSuite == null) {
                            return;
                        }
                        this.workDir = WorkDirectory.open(file, testSuite);
                    }
                    break;
                }
            }
            super.approveSelection();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.uif.showError("wdc.cantFindDir", file.getPath());
        }
        catch (WorkDirectory.MismatchFault mismatchFault) {
            this.uif.showError("wdc.wrongTS");
        }
        catch (WorkDirectory.Fault fault) {
            this.uif.showError("wdc.cantOpen", fault.getMessage());
        }
    }

    private void approveOpenSelection_dirExists(File file) {
        this.setCurrentDirectory(file);
        this.setSelectedFile(null);
        this.setSelectedFiles(null);
    }

    private void approveOpenSelection_dirNotFound(File file) {
        if (this.testSuite == null) {
            this.uif.showError("wdc.notFound_noTestSuite");
            return;
        }
        int n = this.uif.showYesNoDialog("wdc.notFound_createIt", this.testSuite.getPath());
        if (n != 0) {
            return;
        }
        try {
            this.workDir = WorkDirectory.create(file, this.testSuite);
            super.approveSelection();
        }
        catch (WorkDirectory.Fault fault) {
            this.uif.showError("wdc.cantCreate", fault.getMessage());
        }
    }

    private boolean isDirectory(File file) {
        return file.isDirectory();
    }

    private boolean isWorkDirectory(File file) {
        if (WorkDirChooser.isIgnoreable(file)) {
            return false;
        }
        Boolean bl = (Boolean)this.cache.get(file);
        if (bl == null) {
            boolean bl2 = WorkDirectory.isWorkDirectory(file);
            this.cache.put(file, bl2 ? Boolean.TRUE : Boolean.FALSE);
            return bl2;
        }
        return bl;
    }

    private static boolean isIgnoreable(File file) {
        return file.getName().equals("");
    }

    private static File normalize(File file) {
        File file2 = file;
        while (file2 != null && !WorkDirChooser.isIgnoreable(file2)) {
            if (WorkDirectory.isWorkDirectory(file2)) {
                File file3 = file2.getParentFile();
                return file3 != null ? file3 : file;
            }
            file2 = file2.getParentFile();
        }
        return file;
    }

    private class WDC_FileFilter
    extends FileFilter {
        private WDC_FileFilter() {
        }

        public boolean accept(File file) {
            return WorkDirChooser.this.isDirectory(file);
        }

        public String getDescription() {
            return WorkDirChooser.this.uif.getI18NString("wdc.ft");
        }
    }

    private class WDC_FileView
    extends FileView {
        private WDC_FileView() {
        }

        public String getDescription(File file) {
            return null;
        }

        public Icon getIcon(File file) {
            return WorkDirChooser.this.isWorkDirectory(file) ? WorkDirChooser.this.icon : null;
        }

        public String getName(File file) {
            String string = file.getName();
            return string.length() == 0 ? file.getPath() : string;
        }

        public String getTypeDescription(File file) {
            return null;
        }

        public Boolean isTraversable(File file) {
            return WorkDirChooser.this.isDirectory(file) && !WorkDirChooser.this.isWorkDirectory(file) ? Boolean.TRUE : Boolean.FALSE;
        }
    }
}

