/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.UIFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public abstract class ToolDialog {
    protected final Component parent;
    protected final UIFactory uif;
    private String uiKey;
    private Container dialog;
    private String title;
    private JMenuBar menuBar;
    private Container main;
    private Container body;
    private JButton[] buttons;
    private JButton cancelButton;
    private JButton defaultButton;
    private String helpID;
    private ComponentListener componentListener;
    static /* synthetic */ Class class$com$sun$javatest$tool$Tool;

    protected ToolDialog(Component component, UIFactory uIFactory, String string) {
        if (component == null || uIFactory == null || string == null) {
            throw new NullPointerException();
        }
        this.parent = component;
        this.uif = uIFactory;
        this.uiKey = string;
    }

    public boolean isShowing() {
        return this.dialog != null && this.dialog.isShowing();
    }

    public boolean isVisible() {
        return this.dialog != null && this.dialog.isVisible();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.ensureDialogInitialized();
            this.dialog.setVisible(true);
            if (this.dialog instanceof JDialog) {
                ((JDialog)this.dialog).toFront();
            } else {
                ((JInternalFrame)this.dialog).toFront();
            }
        } else if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
    }

    public void dispose() {
        if (this.dialog != null) {
            if (this.dialog instanceof JDialog) {
                ((JDialog)this.dialog).dispose();
            } else {
                ((JInternalFrame)this.dialog).dispose();
            }
            RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)this.dialog);
            rootPaneContainer.setContentPane(new Container());
            JMenuBar jMenuBar = rootPaneContainer.getRootPane().getJMenuBar();
            if (jMenuBar != null) {
                jMenuBar.removeAll();
            }
            this.dialog = null;
        }
    }

    protected abstract void initGUI();

    protected String getTitle() {
        return this.title;
    }

    protected void setI18NTitle(String string) {
        this.setLocalizedTitle(this.uif.getI18NString(string));
    }

    protected void setI18NTitle(String string, Object object) {
        this.setLocalizedTitle(this.uif.getI18NString(string, object));
    }

    protected void setI18NTitle(String string, Object[] objectArray) {
        this.setLocalizedTitle(this.uif.getI18NString(string, objectArray));
    }

    private void setLocalizedTitle(String string) {
        if (this.dialog != null) {
            if (this.dialog instanceof JDialog) {
                ((JDialog)this.dialog).setTitle(string);
            } else {
                ((JInternalFrame)this.dialog).setTitle(string);
            }
        }
        this.title = string;
    }

    protected void setHelp(String string) {
        if (this.dialog != null) {
            this.uif.setHelp(this.dialog, string);
        }
        this.helpID = string;
    }

    protected JMenuBar getJMenuBar() {
        return this.menuBar;
    }

    protected void setJMenuBar(JMenuBar jMenuBar) {
        if (this.dialog != null) {
            if (this.dialog instanceof JDialog) {
                ((JDialog)this.dialog).setJMenuBar(jMenuBar);
            } else {
                ((JInternalFrame)this.dialog).setJMenuBar(jMenuBar);
            }
        }
        this.menuBar = jMenuBar;
    }

    protected Container getBody() {
        return this.body;
    }

    protected void setBody(Container container) {
        this.body = container;
        if (this.dialog != null) {
            this.initMain();
            if (this.dialog instanceof JDialog) {
                ((JDialog)this.dialog).setContentPane(this.main);
            } else {
                ((JInternalFrame)this.dialog).setContentPane(this.main);
            }
        }
    }

    protected JButton[] getButtons() {
        return this.buttons;
    }

    protected JButton getDefaultButton() {
        return this.defaultButton;
    }

    protected void setButtons(JButton[] jButtonArray, JButton jButton) {
        this.buttons = jButtonArray;
        this.defaultButton = jButton;
        this.cancelButton = null;
        if (jButtonArray != null) {
            int n = 0;
            while (n < jButtonArray.length && this.cancelButton == null) {
                if (jButtonArray[n].getActionCommand().equals("cancel")) {
                    this.cancelButton = jButtonArray[n];
                }
                ++n;
            }
        }
        if (this.dialog != null) {
            this.initMain();
            if (this.dialog instanceof JDialog) {
                ((JDialog)this.dialog).setContentPane(this.main);
            } else {
                ((JInternalFrame)this.dialog).setContentPane(this.main);
            }
        }
    }

    protected void setComponentListener(ComponentListener componentListener) {
        this.componentListener = componentListener;
    }

    protected Dimension getSize() {
        if (this.dialog == null) {
            throw new IllegalStateException();
        }
        return this.dialog.getSize();
    }

    protected void setSize(Dimension dimension) {
        if (this.dialog == null) {
            throw new IllegalStateException();
        }
        this.dialog.setSize(dimension);
    }

    protected void setSize(int n, int n2) {
        if (this.dialog == null) {
            throw new IllegalStateException();
        }
        this.dialog.setSize(n, n2);
    }

    private void ensureDialogInitialized() {
        Tool tool = (Tool)(this.parent instanceof Tool ? this.parent : SwingUtilities.getAncestorOfClass(class$com$sun$javatest$tool$Tool == null ? (class$com$sun$javatest$tool$Tool = ToolDialog.class$("com.sun.javatest.tool.Tool")) : class$com$sun$javatest$tool$Tool, this.parent));
        if (tool == null) {
            throw new IllegalStateException();
        }
        Desktop desktop = Desktop.access();
        if (this.dialog == null || !desktop.isToolOwnerForDialog(tool, this.dialog)) {
            Container container;
            if (this.main == null) {
                this.initMain();
            }
            this.dialog = desktop.createDialog(tool, this.uiKey, this.title, this.menuBar, this.main, this.dialog == null ? null : this.dialog.getBounds());
            this.uif.setHelp(this.dialog, this.helpID);
            if (this.dialog instanceof JDialog) {
                container = (JDialog)this.dialog;
                if (this.defaultButton != null) {
                    ((JDialog)container).getRootPane().setDefaultButton(this.defaultButton);
                    ((Window)container).addWindowListener(new WindowAdapter((JDialog)container){
                        private final /* synthetic */ JDialog val$d;
                        {
                            this.val$d = jDialog;
                        }

                        public void windowActivated(WindowEvent windowEvent) {
                            ToolDialog.this.defaultButton.requestFocus();
                            this.val$d.removeWindowListener(this);
                        }
                    });
                }
                ((JDialog)container).setDefaultCloseOperation(1);
            } else {
                container = (JInternalFrame)this.dialog;
                if (this.defaultButton != null) {
                    ((JInternalFrame)container).getRootPane().setDefaultButton(this.defaultButton);
                }
                ((JInternalFrame)container).setDefaultCloseOperation(1);
            }
            if (this.componentListener != null) {
                this.dialog.addComponentListener(this.componentListener);
            }
            if (this.cancelButton != null) {
                container = (JPanel)this.main;
                InputMap inputMap = ((JComponent)container).getInputMap(2);
                ActionMap actionMap = ((JComponent)container).getActionMap();
                inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
                actionMap.put("cancel", new AbstractAction(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ToolDialog.this.cancelButton.doClick(250);
                    }
                });
            }
        }
    }

    private void initMain() {
        if (this.body == null) {
            this.initGUI();
        }
        if (this.body == null) {
            throw new IllegalStateException();
        }
        if (this.buttons == null || this.buttons.length == 0) {
            this.main = this.body;
        } else {
            JPanel jPanel = this.uif.createPanel(this.uiKey + ".main", false);
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)this.body, "Center");
            Dimension dimension = new Dimension();
            int n = 0;
            while (n < this.buttons.length) {
                Dimension dimension2 = this.buttons[n].getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                dimension.height = Math.max(dimension.height, dimension2.height);
                ++n;
            }
            int n2 = 0;
            while (n2 < this.buttons.length) {
                this.buttons[n2].setPreferredSize(dimension);
                ++n2;
            }
            JPanel jPanel2 = this.uif.createPanel(this.uiKey + ".btns", false);
            jPanel2.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets.top = 5;
            gridBagConstraints.insets.bottom = 11;
            gridBagConstraints.insets.right = 11;
            gridBagConstraints.weightx = 1.0;
            int n3 = 0;
            while (n3 < this.buttons.length) {
                jPanel2.add((Component)this.buttons[n3], gridBagConstraints);
                gridBagConstraints.weightx = 0.0;
                ++n3;
            }
            jPanel.add((Component)jPanel2, "South");
            this.main = jPanel;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

