/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.DynamicArray;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import javax.help.HelpBroker;
import javax.swing.JDialog;
import javax.swing.JMenuBar;
import javax.swing.JPanel;

public abstract class Tool
extends JPanel {
    protected final UIFactory uif;
    private String title;
    private String shortTitle;
    private String helpID;
    private long creationTime;
    private Observer[] observers = new Observer[0];

    public synchronized void addObserver(Observer observer) {
        this.observers = (Observer[])DynamicArray.append(this.observers, observer);
    }

    public synchronized void removeObserver(Observer observer) {
        this.observers = (Observer[])DynamicArray.remove((Object[])this.observers, observer);
    }

    public abstract JMenuBar getMenuBar();

    protected void setI18NTitle(String string) {
        this.setLocalizedTitle(this.uif.getI18NString(string));
    }

    protected void setI18NTitle(String string, Object object) {
        this.setLocalizedTitle(this.uif.getI18NString(string, object));
    }

    protected void setI18NTitle(String string, Object[] objectArray) {
        this.setLocalizedTitle(this.uif.getI18NString(string, objectArray));
    }

    private synchronized void setLocalizedTitle(String string) {
        this.title = string;
        int n = 0;
        while (n < this.observers.length) {
            this.observers[n].titleChanged(this, string);
            ++n;
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setShortTitle(String string) {
        this.shortTitle = string;
    }

    public String getShortTitle() {
        if (this.shortTitle != null) {
            return this.shortTitle;
        }
        if (this.title != null) {
            return this.title;
        }
        return this.getName();
    }

    public TestSuite[] getLoadedTestSuites() {
        return null;
    }

    public WorkDirectory[] getLoadedWorkDirectories() {
        return null;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void dispose() {
        this.removeAll();
        this.uif.dispose();
    }

    protected Tool(String string) {
        super(new BorderLayout());
        this.setName(string);
        this.setFocusable(false);
        this.uif = new UIFactory(this);
        this.uif.setAccessibleName(this, string);
        this.uif.setToolTip(this, string);
        this.creationTime = System.currentTimeMillis();
    }

    protected Tool(String string, String string2) {
        this(string);
        HelpBroker helpBroker = this.getHelpBroker();
        if (helpBroker != null) {
            helpBroker.enableHelp(this, string2, null);
        }
    }

    protected abstract void save(Map var1);

    protected String[] getCloseAlerts() {
        return null;
    }

    protected void setHelp(String string) {
        this.setHelp(this, string);
    }

    protected void setHelp(Component component, String string) {
        HelpBroker helpBroker = this.getHelpBroker();
        if (helpBroker != null) {
            if (component instanceof JDialog) {
                JDialog jDialog = (JDialog)component;
                Desktop.addHelpDebugListener(jDialog);
                helpBroker.enableHelpKey(jDialog.getRootPane(), string, null);
            } else {
                helpBroker.enableHelp(component, string, null);
            }
        }
    }

    protected void setHelpOnButton(Component component, String string) {
        HelpBroker helpBroker = this.getHelpBroker();
        if (helpBroker != null) {
            helpBroker.enableHelpOnButton(component, string, null);
        }
    }

    protected HelpBroker getHelpBroker() {
        return Desktop.access().getHelpBroker();
    }

    public static interface Observer {
        public void titleChanged(Tool var1, String var2);
    }
}

