/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.tool.TreeSelectionPane;

public class TestTreeSelectionPane
extends TreeSelectionPane {
    public TestTreeSelectionPane(TestResultTable testResultTable) {
        super(new TRTModel(testResultTable));
    }

    private static class TRTModel
    implements TreeSelectionPane.Model {
        private TestResultTable trt;

        TRTModel(TestResultTable testResultTable) {
            this.trt = testResultTable;
        }

        public Object getRoot() {
            return this.trt.getRoot();
        }

        public int getChildCount(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (object instanceof TestResultTable.TreeNode) {
                return ((TestResultTable.TreeNode)object).getChildCount();
            }
            if (object instanceof TestResult) {
                return 0;
            }
            throw new IllegalArgumentException();
        }

        public Object getChild(Object object, int n) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (object instanceof TestResultTable.TreeNode) {
                return ((TestResultTable.TreeNode)object).getChild(n);
            }
            if (object instanceof TestResult) {
                return null;
            }
            throw new IllegalArgumentException();
        }

        public String getName(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (object instanceof TestResultTable.TreeNode) {
                return ((TestResultTable.TreeNode)object).getName();
            }
            if (object instanceof TestResult) {
                TestResult testResult = (TestResult)object;
                String string = testResult.getTestName();
                int n = string.lastIndexOf("/");
                return n == -1 ? string : string.substring(n + 1);
            }
            throw new IllegalArgumentException();
        }

        public String getPath(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (object instanceof TestResult) {
                return ((TestResult)object).getTestName();
            }
            if (object instanceof TestResultTable.TreeNode) {
                TestResultTable.TreeNode treeNode = (TestResultTable.TreeNode)object;
                if (treeNode.isRoot()) {
                    return treeNode.getName();
                }
                return this.getPath(treeNode.getParent() + "/" + treeNode.getName());
            }
            throw new IllegalArgumentException();
        }

        public boolean isLeaf(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (object instanceof TestResult) {
                return true;
            }
            if (object instanceof TestResultTable.TreeNode) {
                return false;
            }
            throw new IllegalArgumentException();
        }
    }
}

