/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.PrefixMap;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import javax.help.CSH;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

class TabDesktop
extends Desktop {
    private JFrame mainFrame;
    private JTabbedPane contents;
    private Tool selectedTool;
    private Listener listener = new Listener();
    private Action closeAction = new CloseAction();

    TabDesktop() {
        this.initMainFrame(Desktop.getDefaultBounds());
        JDialog.setDefaultLookAndFeelDecorated(false);
    }

    TabDesktop(Desktop desktop) {
        super(desktop);
        this.initMainFrame(desktop.getBounds());
        JDialog.setDefaultLookAndFeelDecorated(true);
        Tool[] toolArray = desktop.getTools();
        Arrays.sort(toolArray, new Comparator(){

            public int compare(Object object, Object object2) {
                Long l = new Long(((Tool)object).getCreationTime());
                Long l2 = new Long(((Tool)object2).getCreationTime());
                return l.compareTo(l2);
            }
        });
        int n = 0;
        while (n < toolArray.length) {
            desktop.removeTool(toolArray[n]);
            this.addTool(toolArray[n]);
            ++n;
        }
        this.setVisible(desktop.isVisible());
    }

    public void dispose() {
        this.mainFrame.dispose();
        super.dispose();
    }

    public boolean isVisible() {
        return this.mainFrame.isVisible();
    }

    public void setVisible(boolean bl) {
        if (bl != this.mainFrame.isVisible()) {
            this.mainFrame.setVisible(bl);
        }
    }

    public void addTool(Tool tool) {
        this.contents.addTab(tool.getShortTitle(), null, tool, tool.getTitle());
        tool.addObserver(this.listener);
        this.closeAction.setEnabled(true);
    }

    public Tool[] getTools() {
        Tool[] toolArray = new Tool[this.contents.getComponentCount()];
        int n = 0;
        while (n < toolArray.length) {
            toolArray[n] = (Tool)this.contents.getComponentAt(n);
            ++n;
        }
        return toolArray;
    }

    public void removeTool(Tool tool) {
        tool.removeObserver(this.listener);
        this.contents.removeChangeListener(this.listener);
        this.contents.remove(tool);
        if (tool == this.selectedTool) {
            this.setSelectedTool((Tool)this.contents.getSelectedComponent());
        } else {
            this.contents.setSelectedComponent(this.selectedTool);
        }
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component component = keyboardFocusManager.getPermanentFocusOwner();
        if (component == null || !component.isShowing()) {
            Container container = this.contents.getTabCount() > 0 ? this.contents : this.mainFrame;
            Container container2 = container.isFocusCycleRoot() ? container : container.getFocusCycleRootAncestor();
            FocusTraversalPolicy focusTraversalPolicy = container2.getFocusTraversalPolicy();
            Container container3 = container.isFocusable() ? container : focusTraversalPolicy.getComponentAfter(container2, container);
            container3.requestFocusInWindow();
        }
        this.contents.addChangeListener(this.listener);
        this.closeAction.setEnabled(this.contents.getTabCount() > 0);
    }

    public Tool getSelectedTool() {
        return this.selectedTool;
    }

    public void setSelectedTool(Tool tool) {
        if (tool == this.selectedTool) {
            return;
        }
        if (this.selectedTool != null) {
            this.removeToolMenuItemsFromFrameMenuBar(this.mainFrame, this.selectedTool);
            this.selectedTool.removeObserver(this.listener);
        }
        this.selectedTool = tool;
        if (this.selectedTool == null) {
            this.mainFrame.setTitle(Desktop.uif.getI18NString("dt.title.txt"));
            CSH.setHelpIDString(this.contents, null);
        } else {
            this.addToolMenuItemsToFrameMenuBar(this.mainFrame, this.selectedTool);
            this.selectedTool.addObserver(this.listener);
            this.mainFrame.setTitle(Desktop.uif.getI18NString("dt.title.tool.txt", this.selectedTool.getTitle()));
            CSH.setHelpIDString(this.contents, CSH.getHelpIDString(this.selectedTool));
            this.contents.setSelectedComponent(this.selectedTool);
        }
    }

    public int getStyle() {
        return 0;
    }

    public JFrame[] getFrames() {
        return new JFrame[]{this.mainFrame};
    }

    public Rectangle getBounds() {
        return this.mainFrame.getBounds();
    }

    public boolean isToolOwnerForDialog(Tool tool, Container container) {
        return container.getParent() == this.mainFrame;
    }

    public Container createDialog(Tool tool, String string, String string2, JMenuBar jMenuBar, Container container, Rectangle rectangle) {
        UIFactory uIFactory = tool.uif;
        JDialog jDialog = uIFactory.createDialog(string, this.mainFrame, string2, container);
        if (jMenuBar != null) {
            jDialog.setJMenuBar(jMenuBar);
        }
        if (rectangle == null) {
            jDialog.pack();
            jDialog.setLocationRelativeTo(this.mainFrame);
        } else {
            jDialog.setBounds(rectangle);
        }
        return jDialog;
    }

    protected void saveDesktop(Map map) {
        super.saveDesktop(map);
        Desktop.saveBounds(this.mainFrame, new PrefixMap(map, "dt"));
        int n = this.contents.getSelectedIndex();
        if (n >= 0) {
            map.put("dt.selected", String.valueOf(n));
        }
    }

    protected void restoreDesktop(Map map) {
        super.restoreDesktop(map);
        Desktop.restoreBounds(this.mainFrame, new PrefixMap(map, "dt"));
        try {
            int n;
            String string = (String)map.get("dt.selected");
            if (string != null && 0 <= (n = Integer.parseInt(string)) && n < this.contents.getTabCount()) {
                this.contents.setSelectedIndex(n);
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private void initMainFrame(Rectangle rectangle) {
        this.mainFrame = this.createFrame(this.listener, this.closeAction, "tdi.main");
        this.contents = Desktop.uif.createTabbedPane("tdi.desk");
        this.contents.setOpaque(true);
        this.contents.setPreferredSize(new Dimension(rectangle.width, rectangle.height));
        this.contents.setTabPlacement(3);
        this.contents.addChangeListener(this.listener);
        this.contents.addAncestorListener(this.listener);
        this.mainFrame.setContentPane(this.contents);
        if (rectangle == null) {
            this.mainFrame.pack();
            this.mainFrame.setLocationRelativeTo(null);
        } else {
            this.mainFrame.setBounds(rectangle);
        }
        this.mainFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TabDesktop.this.checkToolsAndExitIfOK(TabDesktop.this.mainFrame);
            }
        });
    }

    private class Listener
    implements ActionListener,
    AncestorListener,
    ChangeListener,
    MenuListener,
    Tool.Observer {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            Object object = jMenuItem.getClientProperty(this);
            if (object instanceof Window) {
                ((Window)object).toFront();
            } else if (object instanceof Tool) {
                TabDesktop.this.setSelectedTool((Tool)object);
            }
        }

        public void ancestorAdded(AncestorEvent ancestorEvent) {
            Tool tool = (Tool)TabDesktop.this.contents.getSelectedComponent();
            if (tool != null) {
                TabDesktop.this.addToolMenuItemsToFrameMenuBar(TabDesktop.this.mainFrame, tool);
                tool.addObserver(this);
                TabDesktop.this.mainFrame.setTitle(Desktop.uif.getI18NString("dt.title.tool.txt", tool.getTitle()));
            }
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            Tool tool = (Tool)TabDesktop.this.contents.getSelectedComponent();
            if (tool != null) {
                tool.removeObserver(this);
            }
            TabDesktop.this.mainFrame.setTitle(Desktop.uif.getI18NString("dt.title.txt"));
        }

        public void stateChanged(ChangeEvent changeEvent) {
            TabDesktop.this.setSelectedTool((Tool)TabDesktop.this.contents.getSelectedComponent());
        }

        public void menuSelected(MenuEvent menuEvent) {
            Tool[] toolArray = TabDesktop.this.getTools();
            JMenu jMenu = (JMenu)menuEvent.getSource();
            jMenu.removeAll();
            if (toolArray.length == 0) {
                JMenuItem jMenuItem = new JMenuItem(Desktop.uif.getI18NString("dt.windows.noWindows.mit"));
                jMenuItem.setEnabled(false);
                jMenu.add(jMenuItem);
            } else {
                Window[] windowArray;
                int n = 0;
                int n2 = 0;
                while (n2 < toolArray.length) {
                    windowArray = toolArray[n2];
                    this.addMenuItem(jMenu, n++, windowArray.getTitle(), windowArray);
                    ++n2;
                }
                windowArray = TabDesktop.this.mainFrame.getOwnedWindows();
                int n3 = 0;
                while (n3 < windowArray.length) {
                    Window window = windowArray[n3];
                    if (window instanceof JDialog && window.isVisible()) {
                        this.addMenuItem(jMenu, n++, ((JDialog)window).getTitle(), window);
                    }
                    ++n3;
                }
            }
        }

        private void addMenuItem(JMenu jMenu, int n, String string, Object object) {
            JMenuItem jMenuItem = new JMenuItem(Desktop.uif.getI18NString("dt.windows.toolX.mit", new Object[]{new Integer(n), string}));
            if (n < 10) {
                jMenuItem.setMnemonic(Character.forDigit(n, 10));
            }
            jMenuItem.addActionListener(this);
            jMenuItem.putClientProperty(this, object);
            jMenu.add(jMenuItem);
        }

        public void menuDeselected(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)menuEvent.getSource();
            jMenu.removeAll();
        }

        public void menuCanceled(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)menuEvent.getSource();
            jMenu.removeAll();
        }

        public void titleChanged(Tool tool, String string) {
            if (tool == TabDesktop.this.contents.getSelectedComponent()) {
                TabDesktop.this.mainFrame.setTitle(Desktop.uif.getI18NString("dt.title.tool.txt", string));
            }
            int n = 0;
            while (n < TabDesktop.this.contents.getTabCount()) {
                if (tool == TabDesktop.this.contents.getComponentAt(n)) {
                    TabDesktop.this.contents.setToolTipTextAt(n, string);
                    break;
                }
                ++n;
            }
        }
    }

    private class CloseAction
    extends ToolAction {
        CloseAction() {
            super(Desktop.uif, "tdi.file.close");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Tool tool = (Tool)TabDesktop.this.contents.getSelectedComponent();
            if (tool != null && TabDesktop.this.isOKToClose(tool, TabDesktop.this.mainFrame)) {
                TabDesktop.this.removeTool(tool);
                tool.dispose();
            }
        }
    }
}

