/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.PrefixMap;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

class SDIDesktop
extends Desktop {
    private static final int MENU_INSERT_POINT = 3;
    private JFrame console;
    private JFrame[] frames;
    private boolean visible;
    private Tool selectedTool;
    private Listener listener = new Listener();
    private static final String TILE = "tile";
    private static final String CASCADE = "cascade";
    static /* synthetic */ Class class$javax$swing$JFrame;

    SDIDesktop() {
        this.initFrames();
        JDialog.setDefaultLookAndFeelDecorated(false);
    }

    SDIDesktop(Desktop desktop) {
        super(desktop);
        this.initFrames();
        JDialog.setDefaultLookAndFeelDecorated(false);
        Tool[] toolArray = desktop.getTools();
        int n = 0;
        while (n < toolArray.length) {
            desktop.removeTool(toolArray[n]);
            this.addTool(toolArray[n]);
            ++n;
        }
        this.doCascade();
        this.setVisible(desktop.isVisible());
    }

    public void dispose() {
        int n = 0;
        while (n < this.frames.length) {
            this.frames[n].dispose();
            ++n;
        }
        super.dispose();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        if (bl != this.visible) {
            int n = 0;
            while (n < this.frames.length) {
                this.frames[n].setVisible(bl);
                ++n;
            }
            this.visible = bl;
        }
    }

    public Tool[] getTools() {
        Tool[] toolArray = new Tool[this.frames.length - 1];
        int n = 0;
        while (n < toolArray.length) {
            toolArray[n] = (Tool)this.frames[n + 1].getContentPane();
            ++n;
        }
        return toolArray;
    }

    public void addTool(final Tool tool) {
        ToolAction toolAction = new ToolAction(Desktop.uif, "sdi.file.close"){

            public void actionPerformed(ActionEvent actionEvent) {
                SDIDesktop.this.removeTool(tool);
                tool.dispose();
            }
        };
        JFrame jFrame = this.createFrame(this.listener, toolAction, "sdi.tool");
        jFrame.setDefaultCloseOperation(0);
        this.addToolMenuItemsToFrameMenuBar(jFrame, tool);
        jFrame.setTitle(Desktop.uif.getI18NString("dt.title.tool.txt", tool.getTitle()));
        jFrame.setContentPane(tool);
        jFrame.pack();
        tool.addObserver(this.listener);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                JFrame jFrame = (JFrame)windowEvent.getSource();
                Tool tool = (Tool)jFrame.getContentPane();
                SDIDesktop.this.selectedTool = tool;
            }

            public void windowDeactivated(WindowEvent windowEvent) {
                SDIDesktop.this.selectedTool = null;
            }

            public void windowClosing(WindowEvent windowEvent) {
                JFrame jFrame = (JFrame)windowEvent.getSource();
                Tool tool = (Tool)jFrame.getContentPane();
                if (SDIDesktop.this.isOKToClose(tool, jFrame)) {
                    jFrame.dispose();
                }
            }

            public void windowClosed(WindowEvent windowEvent) {
                JFrame jFrame = (JFrame)windowEvent.getSource();
                SDIDesktop.access$102(SDIDesktop.this, (JFrame[])DynamicArray.remove((Object[])SDIDesktop.this.frames, jFrame));
                if (jFrame.getContentPane() instanceof Tool) {
                    Tool tool = (Tool)jFrame.getContentPane();
                    tool.removeObserver(SDIDesktop.this.listener);
                    tool.dispose();
                    jFrame.getRootPane().removeAll();
                    if (tool == SDIDesktop.this.selectedTool) {
                        SDIDesktop.this.selectedTool = null;
                    }
                }
            }
        });
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = jFrame.getSize();
        jFrame.setLocation(dimension.width / 2 - dimension2.width / 2, dimension.height / 2 - dimension2.height / 2);
        jFrame.setVisible(this.visible);
        this.frames = (JFrame[])DynamicArray.append(this.frames, jFrame);
    }

    public void removeTool(Tool tool) {
        JFrame jFrame = SDIDesktop.getFrameForTool(tool);
        this.frames = (JFrame[])DynamicArray.remove((Object[])this.frames, jFrame);
        jFrame.setVisible(false);
        this.removeToolMenuItemsFromFrameMenuBar(jFrame, tool);
        jFrame.setContentPane(new Container());
        jFrame.dispose();
    }

    public Tool getSelectedTool() {
        return this.selectedTool;
    }

    public void setSelectedTool(Tool tool) {
        JFrame jFrame = SDIDesktop.getFrameForTool(tool);
        if (jFrame.getState() == 1) {
            jFrame.setState(0);
        }
        jFrame.setVisible(this.visible);
    }

    public int getStyle() {
        return 2;
    }

    public JFrame[] getFrames() {
        return this.frames;
    }

    public Rectangle getBounds() {
        Rectangle rectangle = null;
        int n = 1;
        while (n < this.frames.length) {
            Rectangle rectangle2 = this.frames[n].getBounds();
            rectangle = rectangle == null ? rectangle2 : rectangle.union(rectangle2);
            ++n;
        }
        return rectangle == null ? Desktop.getDefaultBounds() : rectangle;
    }

    public boolean isToolOwnerForDialog(Tool tool, Container container) {
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = SDIDesktop.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, tool);
        return container.getParent() == jFrame;
    }

    public Container createDialog(Tool tool, String string, String string2, JMenuBar jMenuBar, Container container, Rectangle rectangle) {
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = SDIDesktop.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, tool);
        UIFactory uIFactory = tool.uif;
        JDialog jDialog = uIFactory.createDialog(string, jFrame, string2, container);
        if (jMenuBar != null) {
            jDialog.setJMenuBar(jMenuBar);
        }
        if (rectangle == null) {
            jDialog.pack();
            jDialog.setLocationRelativeTo(jFrame);
        } else {
            jDialog.setBounds(rectangle);
        }
        return jDialog;
    }

    protected void saveDesktop(Map map) {
        super.saveDesktop(map);
        Desktop.saveBounds(this.console, new PrefixMap(map, "dt.console"));
    }

    protected void restoreDesktop(Map map) {
        super.restoreDesktop(map);
        Desktop.restoreBounds(this.console, new PrefixMap(map, "dt.console"));
    }

    protected void saveTool(Map map, Tool tool) {
        super.saveTool(map, tool);
        Desktop.saveBounds(SDIDesktop.getFrameForTool(tool), new PrefixMap(map, "dt"));
    }

    protected Tool restoreTool(Map map) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Tool tool = super.restoreTool(map);
        Desktop.restoreBounds(SDIDesktop.getFrameForTool(tool), new PrefixMap(map, "dt"));
        return tool;
    }

    private void initFrames() {
        this.console = this.createFrame(this.listener, "sdi.console");
        this.console.setTitle(Desktop.uif.getI18NString("dt.title.console"));
        this.console.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SDIDesktop.this.checkToolsAndExitIfOK(SDIDesktop.this.console);
            }
        });
        JLabel jLabel = new JLabel(this.getLogo());
        jLabel.setName("sdi.console");
        jLabel.setFocusable(false);
        this.console.setContentPane(jLabel);
        this.console.pack();
        this.frames = new JFrame[]{this.console};
    }

    private void doCascade() {
        Serializable serializable;
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        while (n3 < this.frames.length) {
            serializable = this.frames[n3];
            Dimension dimension = ((Component)serializable).getSize();
            n = Math.max(n, n3 * 30 + dimension.width);
            n2 = Math.max(n2, n3 * 30 + dimension.height);
            ++n3;
        }
        serializable = Toolkit.getDefaultToolkit().getScreenSize();
        int n4 = (((Dimension)serializable).width - n) / 2;
        int n5 = (((Dimension)serializable).height - n2) / 2;
        int n6 = 1;
        while (n6 < this.frames.length) {
            JFrame jFrame = this.frames[n6];
            jFrame.setLocation(n4 + n6 * 30, n5 + n6 * 30);
            jFrame.toFront();
            ++n6;
        }
    }

    private void doTile() {
        int n = this.frames.length - 1;
        int n2 = (int)Math.sqrt(n);
        int n3 = (n + n2 - 1) / n2;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = new Dimension(dimension.width / n2, dimension.height / n3);
        int n4 = 0;
        while (n4 < n) {
            JFrame jFrame = this.frames[n4 + 1];
            int n5 = n4 % n2;
            int n6 = n4 / n2;
            jFrame.setBounds(n5 * dimension2.width, n6 * dimension2.height, dimension2.width, dimension2.height);
            ++n4;
        }
    }

    private static JFrame getFrameForTool(Tool tool) {
        return (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = SDIDesktop.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, tool);
    }

    static /* synthetic */ JFrame[] access$102(SDIDesktop sDIDesktop, JFrame[] jFrameArray) {
        sDIDesktop.frames = jFrameArray;
        return jFrameArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Listener
    implements ActionListener,
    MenuListener,
    Tool.Observer {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(SDIDesktop.CASCADE)) {
                SDIDesktop.this.doCascade();
            } else if (string.equals(SDIDesktop.TILE)) {
                SDIDesktop.this.doTile();
            } else {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                Object object = jMenuItem.getClientProperty(this);
                if (object instanceof Window) {
                    ((Window)object).toFront();
                } else if (object instanceof Tool) {
                    SDIDesktop.this.setSelectedTool((Tool)object);
                }
            }
        }

        public void menuSelected(MenuEvent menuEvent) {
            Tool[] toolArray = SDIDesktop.this.getTools();
            JMenu jMenu = (JMenu)menuEvent.getSource();
            jMenu.removeAll();
            JMenuItem jMenuItem = Desktop.uif.createMenuItem("dt.windows", SDIDesktop.TILE, this);
            jMenuItem.setEnabled(toolArray.length > 0);
            jMenu.add(jMenuItem);
            JMenuItem jMenuItem2 = Desktop.uif.createMenuItem("dt.windows", SDIDesktop.CASCADE, this);
            jMenuItem2.setEnabled(toolArray.length > 0);
            jMenu.add(jMenuItem2);
            jMenu.addSeparator();
            int n = 0;
            int n2 = 0;
            while (n2 < toolArray.length) {
                Tool tool = toolArray[n2];
                this.addMenuItem(jMenu, n++, tool.getTitle(), tool);
                ++n2;
            }
            int n3 = 0;
            while (n3 < SDIDesktop.this.frames.length) {
                Window[] windowArray = SDIDesktop.this.frames[n3].getOwnedWindows();
                int n4 = 0;
                while (n4 < windowArray.length) {
                    Window window = windowArray[n4];
                    if (window instanceof JDialog && window.isVisible()) {
                        this.addMenuItem(jMenu, n++, ((JDialog)window).getTitle(), window);
                    }
                    ++n4;
                }
                ++n3;
            }
            this.addMenuItem(jMenu, n++, SDIDesktop.this.console.getTitle(), SDIDesktop.this.console);
        }

        private void addMenuItem(JMenu jMenu, int n, String string, Object object) {
            JMenuItem jMenuItem = new JMenuItem(Desktop.uif.getI18NString("dt.windows.toolX.mit", new Object[]{new Integer(n), string}));
            if (n < 10) {
                jMenuItem.setMnemonic(Character.forDigit(n, 10));
            }
            jMenuItem.addActionListener(this);
            jMenuItem.putClientProperty(this, object);
            jMenu.add(jMenuItem);
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }

        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void titleChanged(Tool tool, String string) {
            JFrame jFrame = SDIDesktop.getFrameForTool(tool);
            jFrame.setTitle(Desktop.uif.getI18NString("dt.title.tool.txt", string));
        }
    }
}

