/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.report.Report;
import com.sun.javatest.tool.IconFactory;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.FileInfoCache;
import java.awt.Component;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;

public class ReportDirChooser
extends JFileChooser {
    public static final int NEW = 0;
    public static final int OPEN = 1;
    private FileInfoCache cache = new FileInfoCache(60000);
    private int mode;
    private File reportDir;
    private UIFactory uif = new UIFactory(this);
    private Icon icon = IconFactory.getSelectableFolderIcon();
    static /* synthetic */ Class class$com$sun$javatest$report$Report;

    public ReportDirChooser() {
        this(new File(System.getProperty("user.dir")));
    }

    public ReportDirChooser(File file) {
        super(file);
        this.setAcceptAllFileFilterUsed(false);
        this.setFileFilter(new RDC_FileFilter());
        this.setFileView(new RDC_FileView());
        this.setFileSelectionMode(2);
    }

    public void setMode(int n) {
        this.mode = n;
        switch (n) {
            case 0: {
                this.setApproveButtonText(this.uif.getI18NString("rdc.new.btn"));
                this.setApproveButtonToolTipText(this.uif.getI18NString("rdc.new.tip"));
                this.setDialogTitle(this.uif.getI18NString("rdc.new.title"));
                break;
            }
            case 1: {
                this.setApproveButtonText(this.uif.getI18NString("rdc.open.btn"));
                this.setApproveButtonToolTipText(this.uif.getI18NString("rdc.open.tip"));
                this.setDialogTitle(this.uif.getI18NString("rdc.open.title"));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public File getSelectedReportDirectory() {
        return this.reportDir;
    }

    public int showDialog(Component component) {
        return this.showDialog(component, this.getApproveButtonText());
    }

    public void approveSelection() {
        File file = this.getSelectedFile();
        if (this.mode == 0) {
            this.approveNewSelection(file);
        } else {
            this.approveOpenSelection(file);
        }
    }

    private void approveNewSelection(File file) {
        if (file.exists()) {
            if (this.isReportDirectory(file) || this.isEmptyDirectory(file)) {
                this.reportDir = file;
                super.approveSelection();
            } else if (file.isDirectory()) {
                this.setCurrentDirectory(file);
                this.setSelectedFile(null);
                this.setSelectedFiles(null);
            } else {
                this.uif.showError("rdc.notADir", file);
            }
        } else {
            this.reportDir = file;
            super.approveSelection();
        }
    }

    private void approveOpenSelection(File file) {
        if (file.exists()) {
            if (this.isReportDirectory(file)) {
                this.reportDir = file;
                super.approveSelection();
            } else if (this.isDirectory(file)) {
                this.setCurrentDirectory(file);
                this.setSelectedFile(null);
                this.setSelectedFiles(null);
            } else {
                this.uif.showError("rdc.notADir", file);
            }
        } else {
            this.uif.showError("rdc.cantOpen", file);
        }
    }

    private boolean isDirectory(File file) {
        return file.isDirectory();
    }

    private boolean isReportDirectory(File file) {
        if (this.isIgnoreable(file)) {
            return false;
        }
        Boolean bl = (Boolean)this.cache.get(file);
        if (bl == null) {
            boolean bl2 = Report.isReportDirectory(file);
            this.cache.put(file, bl2 ? Boolean.TRUE : Boolean.FALSE);
            return bl2;
        }
        return bl;
    }

    private boolean isEmptyDirectory(File file) {
        return file.isDirectory() && file.list().length == 0;
    }

    private boolean isIgnoreable(File file) {
        return file.getName().equals("");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$sun$javatest$report$Report == null ? (class$com$sun$javatest$report$Report = ReportDirChooser.class$("com.sun.javatest.report.Report")) : class$com$sun$javatest$report$Report;
    }

    private class RDC_FileFilter
    extends FileFilter {
        private RDC_FileFilter() {
        }

        public boolean accept(File file) {
            return ReportDirChooser.this.isDirectory(file);
        }

        public String getDescription() {
            return ReportDirChooser.this.uif.getI18NString("rdc.ft");
        }
    }

    private class RDC_FileView
    extends FileView {
        private RDC_FileView() {
        }

        public String getDescription(File file) {
            return null;
        }

        public Icon getIcon(File file) {
            return ReportDirChooser.this.isReportDirectory(file) ? ReportDirChooser.this.icon : null;
        }

        public String getName(File file) {
            String string = file.getName();
            return string.length() == 0 ? file.getPath() : string;
        }

        public String getTypeDescription(File file) {
            return null;
        }

        public Boolean isTraversable(File file) {
            return ReportDirChooser.this.isDirectory(file) && !ReportDirChooser.this.isReportDirectory(file) ? Boolean.TRUE : Boolean.FALSE;
        }
    }
}

