/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class Preferences {
    private static Preferences theOne;
    private File prefsFile;
    private Properties props;
    private Hashtable observers = new Hashtable();
    private static I18NResourceBundle i18n;
    static /* synthetic */ Class class$com$sun$javatest$tool$Preferences;

    public static Preferences access() {
        if (theOne == null) {
            theOne = new Preferences(Preferences.getDefaultPrefsFile());
        }
        return theOne;
    }

    private static File getDefaultPrefsFile() {
        String string = System.getProperty("javatest.preferences.file");
        if (string == null) {
            File file = new File(System.getProperty("user.home"));
            File file2 = new File(file, ".javatest");
            return new File(file2, "preferences");
        }
        if (!string.equals("NONE")) {
            return new File(string);
        }
        return null;
    }

    private Preferences(File file) {
        this.prefsFile = file;
        Properties properties = new Properties();
        try {
            if (this.prefsFile != null) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.prefsFile));
                properties.load(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.props = properties;
    }

    public synchronized void save() {
        block3: {
            if (this.prefsFile == null) break block3;
            try {
                File file = new File(this.prefsFile.getParent());
                if (!file.exists()) {
                    file.mkdirs();
                }
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.prefsFile));
                this.props.store(bufferedOutputStream, "JavaTest Preferences");
                ((OutputStream)bufferedOutputStream).close();
            }
            catch (IOException iOException) {
                System.err.println(i18n.getString("prefs.cannotSave", iOException));
            }
        }
    }

    public String getPreference(String string) {
        return this.getPreference(string, null);
    }

    public String getPreference(String string, String string2) {
        String string3 = (String)this.props.get(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public void setPreference(String string, String string2) {
        this.props.put(string, string2);
        Enumeration enumeration = this.observers.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string.startsWith(string3)) continue;
            Observer[] observerArray = (Observer[])this.observers.get(string3);
            int n = 0;
            while (n < observerArray.length) {
                observerArray[n].updated(string, string2);
                ++n;
            }
        }
    }

    public void addObserver(String string, Observer observer) {
        Object[] objectArray = (Observer[])this.observers.get(string);
        objectArray = objectArray == null ? new Observer[]{observer} : (Observer[])DynamicArray.append(objectArray, observer);
        this.observers.put(string, objectArray);
    }

    public void addObserver(String[] stringArray, Observer observer) {
        int n = 0;
        while (n < stringArray.length) {
            this.addObserver(stringArray[n], observer);
            ++n;
        }
    }

    public void removeObserver(String string, Observer observer) {
        Object[] objectArray = (Observer[])this.observers.get(string);
        if (objectArray != null) {
            objectArray = (Observer[])DynamicArray.remove(objectArray, observer);
            this.observers.put(string, objectArray);
        }
    }

    public void removeObserver(String[] stringArray, Observer observer) {
        int n = 0;
        while (n < stringArray.length) {
            this.removeObserver(stringArray[n], observer);
            ++n;
        }
    }

    public void showDialog(JFrame jFrame, Pane[] paneArray, HelpBroker helpBroker) {
        PrefsDialog prefsDialog = new PrefsDialog(jFrame, paneArray, helpBroker);
        prefsDialog.setVisible(true);
    }

    private void setPreferences(Pane[] paneArray) {
        Map map = new Map(){

            public void clear() {
                throw new UnsupportedOperationException();
            }

            public boolean containsKey(Object object) {
                return Preferences.this.props.containsKey(object);
            }

            public boolean containsValue(Object object) {
                return Preferences.this.props.containsValue(object);
            }

            public Set entrySet() {
                return Preferences.this.props.entrySet();
            }

            public boolean equals(Object object) {
                return Preferences.this.props.equals(object);
            }

            public Object get(Object object) {
                return Preferences.this.props.get(object);
            }

            public int hashCode() {
                return Preferences.this.props.hashCode();
            }

            public boolean isEmpty() {
                return Preferences.this.props.isEmpty();
            }

            public Set keySet() {
                return Preferences.this.props.keySet();
            }

            public Object put(Object object, Object object2) {
                Object object3 = Preferences.this.props.get(object);
                if (object3 == null || !object3.equals(object2)) {
                    Preferences.this.setPreference((String)object, (String)object2);
                }
                return object3;
            }

            public void putAll(Map map) {
                throw new UnsupportedOperationException();
            }

            public Object remove(Object object) {
                throw new UnsupportedOperationException();
            }

            public int size() {
                return Preferences.this.props.size();
            }

            public Collection values() {
                return Preferences.this.props.values();
            }
        };
        int n = 0;
        while (n < paneArray.length) {
            paneArray[n].save(map);
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$tool$Preferences == null ? (class$com$sun$javatest$tool$Preferences = Preferences.class$("com.sun.javatest.tool.Preferences")) : class$com$sun$javatest$tool$Preferences);
    }

    private class PrefsDialog
    extends JDialog
    implements ActionListener,
    TreeModel,
    TreeSelectionListener {
        private int cardNum;
        private JFrame parent;
        private HelpBroker helpBroker;
        private Pane[] panes;
        private UIFactory uif;
        private JPanel main;
        private JPanel deck;
        private JButton okBtn;
        private JButton applyBtn;
        private JButton resetBtn;
        private JButton helpBtn;

        PrefsDialog(JFrame jFrame, Pane[] paneArray, HelpBroker helpBroker) {
            super((Frame)null, true);
            this.parent = jFrame;
            this.panes = paneArray;
            this.helpBroker = helpBroker;
            this.uif = new UIFactory(this.getClass());
            this.initGUI();
        }

        public void setVisible(boolean bl) {
            if (bl) {
                int n = 0;
                while (n < this.panes.length) {
                    this.panes[n].load(Preferences.this.props);
                    ++n;
                }
            }
            super.setVisible(bl);
        }

        private void initGUI() {
            this.setName("prefs");
            this.setTitle(this.uif.getI18NString("prefs.title"));
            this.helpBroker.enableHelpKey(this.getRootPane(), "ui.prefs.dialog.csh", null);
            Desktop.addHelpDebugListener(this);
            this.uif.setAccessibleDescription(this, "prefs");
            this.main = this.uif.createPanel("prefs.main", new BorderLayout(), false);
            this.initTree();
            this.initPanes();
            this.initButtons();
            this.setContentPane(this.main);
            this.pack();
            this.setLocationRelativeTo(this.parent);
            this.getRootPane().setDefaultButton(this.okBtn);
        }

        private void initTree() {
            JTree jTree = new JTree(this);
            jTree.setName("prefs.tree");
            jTree.addTreeSelectionListener(this);
            jTree.setEditable(false);
            jTree.setShowsRootHandles(true);
            jTree.setRootVisible(false);
            this.uif.setAccessibleInfo(jTree, "prefs.tree");
            int n = this.uif.getDotsPerInch();
            jTree.setPreferredSize(new Dimension(2 * n, n));
            jTree.setVisibleRowCount(10);
            jTree.setCellRenderer(new DefaultTreeCellRenderer(this){
                private final /* synthetic */ PrefsDialog this$1;
                {
                    this.this$1 = prefsDialog;
                }

                public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                    if (object instanceof Pane) {
                        return super.getTreeCellRendererComponent(jTree, ((Pane)object).getText(), bl, bl2, bl3, n, bl4);
                    }
                    return super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                }
            });
            jTree.getSelectionModel().setSelectionMode(1);
            JScrollPane jScrollPane = this.uif.createScrollPane(jTree);
            jScrollPane.setBorder(BorderFactory.createEtchedBorder());
            this.main.add((Component)jScrollPane, "West");
        }

        private void initButtons() {
            this.okBtn = this.uif.createButton("prefs.ok", this);
            this.applyBtn = this.uif.createButton("prefs.apply", this);
            this.resetBtn = this.uif.createButton("prefs.reset", this);
            this.helpBtn = this.uif.createHelpButton("prefs.help", "ui.prefs.dialog.csh");
            JButton[] jButtonArray = new JButton[]{this.okBtn, this.applyBtn, this.resetBtn, this.helpBtn};
            Dimension dimension = new Dimension();
            int n = 0;
            while (n < jButtonArray.length) {
                Dimension dimension2 = jButtonArray[n].getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                dimension.height = Math.max(dimension.height, dimension2.height);
                ++n;
            }
            int n2 = 0;
            while (n2 < jButtonArray.length) {
                jButtonArray[n2].setPreferredSize(dimension);
                ++n2;
            }
            JPanel jPanel = this.uif.createPanel("prefs.btns", false);
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets.top = 5;
            gridBagConstraints.insets.bottom = 11;
            gridBagConstraints.insets.right = 11;
            gridBagConstraints.weightx = 1.0;
            int n3 = 0;
            while (n3 < jButtonArray.length) {
                jPanel.add((Component)jButtonArray[n3], gridBagConstraints);
                gridBagConstraints.weightx = 0.0;
                ++n3;
            }
            this.main.add((Component)jPanel, "South");
        }

        private void initPanes() {
            this.deck = this.uif.createPanel("prefs.deck", new CardLayout(), false);
            this.addAllPanes(this.deck, this.panes);
            int n = this.uif.getDotsPerInch();
            Dimension dimension = new Dimension(3 * n, 2 * n);
            int n2 = 0;
            while (n2 < this.deck.getComponentCount()) {
                Dimension dimension2 = this.deck.getComponent(n2).getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                dimension.height = Math.max(dimension.height, dimension2.height);
                ++n2;
            }
            this.deck.setPreferredSize(dimension);
            this.main.add((Component)this.deck, "Center");
        }

        private void addAllPanes(JPanel jPanel, Pane[] paneArray) {
            int n = 0;
            while (n < paneArray.length) {
                Pane pane = paneArray[n];
                JPanel jPanel2 = this.uif.createPanel("prefs.card" + this.cardNum++, false);
                jPanel2.setLayout(new BorderLayout());
                JLabel jLabel = new JLabel(pane.getText());
                jLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                jPanel2.add((Component)jLabel, "North");
                pane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                jPanel2.add((Component)this.uif.createScrollPane(pane), "Center");
                jPanel.add((Component)jPanel2, pane.getText());
                if (pane.getChildPanes() != null) {
                    this.addAllPanes(jPanel, pane.getChildPanes());
                }
                ++n;
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.okBtn) {
                Preferences.this.setPreferences(this.panes);
                Preferences.this.save();
                this.setVisible(false);
            } else if (object == this.applyBtn) {
                Preferences.this.setPreferences(this.panes);
                Preferences.this.save();
                this.setVisible(true);
            } else if (object == this.resetBtn) {
                int n = 0;
                while (n < this.panes.length) {
                    this.panes[n].load(Preferences.this.props);
                    ++n;
                }
            }
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
            if (treePath != null) {
                Pane pane = (Pane)treePath.getLastPathComponent();
                ((CardLayout)this.deck.getLayout()).show(this.deck, pane.getText());
            }
        }

        public Object getChild(Object object, int n) {
            return this.getChildren(object)[n];
        }

        public int getChildCount(Object object) {
            return this.getChildren(object).length;
        }

        public int getIndexOfChild(Object object, Object object2) {
            Pane[] paneArray = this.getChildren(object);
            int n = 0;
            while (n < paneArray.length) {
                if (paneArray[n] == object2) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        public Object getRoot() {
            return this;
        }

        public boolean isLeaf(Object object) {
            Pane[] paneArray = this.getChildren(object);
            return paneArray == null || paneArray.length == 0;
        }

        public void addTreeModelListener(TreeModelListener treeModelListener) {
        }

        public void removeTreeModelListener(TreeModelListener treeModelListener) {
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
        }

        private Pane[] getChildren(Object object) {
            return object == this ? this.panes : ((Pane)object).getChildPanes();
        }
    }

    public static abstract class Pane
    extends JPanel {
        protected void setHelp(String string) {
            CSH.setHelpIDString(this, string);
        }

        public abstract String getText();

        public void load(Map map) {
            Pane[] paneArray = this.getChildPanes();
            if (paneArray != null) {
                int n = 0;
                while (n < paneArray.length) {
                    paneArray[n].load(map);
                    ++n;
                }
            }
        }

        public void save(Map map) {
            Pane[] paneArray = this.getChildPanes();
            if (paneArray != null) {
                int n = 0;
                while (n < paneArray.length) {
                    paneArray[n].save(map);
                    ++n;
                }
            }
        }

        public Pane[] getChildPanes() {
            return null;
        }
    }

    public static interface Observer {
        public void updated(String var1, String var2);
    }
}

