/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.PrefixMap;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.basic.BasicInternalFrameUI;

class MDIDesktop
extends Desktop {
    private JFrame mainFrame;
    private HashMap internalFrames = new HashMap(17);
    private JDesktopPane desktopPane;
    private Listener listener = new Listener();
    private static final String TILE = "tile";
    private static final String CASCADE = "cascade";
    private static final boolean useInternalDialogs = true;

    MDIDesktop() {
        this.initMainFrame(Desktop.getDefaultBounds());
        JDialog.setDefaultLookAndFeelDecorated(true);
    }

    MDIDesktop(Desktop desktop) {
        super(desktop);
        JDialog.setDefaultLookAndFeelDecorated(true);
        this.initMainFrame(desktop.getBounds());
        Tool[] toolArray = desktop.getTools();
        int n = 0;
        while (n < toolArray.length) {
            desktop.removeTool(toolArray[n]);
            this.addTool(toolArray[n]);
            ++n;
        }
        this.setVisible(desktop.isVisible());
    }

    public void dispose() {
        this.mainFrame.dispose();
        super.dispose();
    }

    public boolean isVisible() {
        return this.mainFrame.isVisible();
    }

    public void setVisible(boolean bl) {
        if (bl != this.mainFrame.isVisible()) {
            this.mainFrame.setVisible(bl);
        }
    }

    public Tool[] getTools() {
        Tool[] toolArray = new Tool[this.internalFrames.size()];
        return this.internalFrames.keySet().toArray(toolArray);
    }

    public void addTool(Tool tool) {
        JInternalFrame jInternalFrame = new JInternalFrame(tool.getTitle(), true, true, true, true);
        jInternalFrame.setName(tool.getShortTitle());
        jInternalFrame.putClientProperty(this, tool);
        jInternalFrame.setJMenuBar(tool.getMenuBar());
        jInternalFrame.setContentPane(tool);
        jInternalFrame.setDefaultCloseOperation(2);
        jInternalFrame.pack();
        jInternalFrame.addInternalFrameListener(this.listener);
        jInternalFrame.getAccessibleContext().setAccessibleDescription(tool.getToolTipText());
        JRootPane jRootPane = jInternalFrame.getRootPane();
        jRootPane.setName("root");
        AccessibleContext accessibleContext = jInternalFrame.getAccessibleContext();
        AccessibleContext accessibleContext2 = jRootPane.getAccessibleContext();
        accessibleContext2.setAccessibleName(accessibleContext.getAccessibleName());
        accessibleContext2.setAccessibleDescription(accessibleContext.getAccessibleDescription());
        Dimension dimension = this.desktopPane.getSize();
        if (dimension.width == 0 || dimension.height == 0) {
            dimension = this.desktopPane.getPreferredSize();
        }
        Dimension dimension2 = jInternalFrame.getSize();
        jInternalFrame.setLocation(Math.max(0, dimension.width / 2 - dimension2.width / 2), Math.max(0, dimension.height / 2 - dimension2.height / 2));
        jInternalFrame.setVisible(true);
        this.internalFrames.put(tool, jInternalFrame);
        this.desktopPane.add(jInternalFrame);
        jInternalFrame.toFront();
        tool.addObserver(this.listener);
    }

    public void removeTool(Tool tool) {
        JInternalFrame jInternalFrame = (JInternalFrame)this.internalFrames.get(tool);
        if (jInternalFrame != null) {
            this.desktopPane.remove(jInternalFrame);
            this.internalFrames.remove(tool);
        }
        tool.removeObserver(this.listener);
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component component = keyboardFocusManager.getPermanentFocusOwner();
        if (component == null || !component.isShowing()) {
            this.desktopPane.requestFocusInWindow();
        }
    }

    public Tool getSelectedTool() {
        JInternalFrame jInternalFrame = this.desktopPane.getSelectedFrame();
        if (jInternalFrame == null) {
            return null;
        }
        Tool tool = (Tool)jInternalFrame.getClientProperty(this);
        return tool;
    }

    public void setSelectedTool(Tool tool) {
        block2: {
            JInternalFrame jInternalFrame = (JInternalFrame)this.internalFrames.get(tool);
            if (jInternalFrame == null) break block2;
            try {
                jInternalFrame.setIcon(false);
                jInternalFrame.setSelected(true);
                this.desktopPane.moveToFront(jInternalFrame);
            }
            catch (Exception exception) {}
        }
    }

    public int getStyle() {
        return 1;
    }

    public JFrame[] getFrames() {
        return new JFrame[]{this.mainFrame};
    }

    public Rectangle getBounds() {
        return this.mainFrame.getBounds();
    }

    public boolean isToolOwnerForDialog(Tool tool, Container container) {
        return container.getParent() == this.desktopPane;
    }

    public Container createDialog(Tool tool, String string, String string2, JMenuBar jMenuBar, Container container, Rectangle rectangle) {
        UIFactory uIFactory = tool.uif;
        JInternalFrame jInternalFrame = new JInternalFrame(string2, true, true, false, false);
        jInternalFrame.putClientProperty(this, tool);
        jInternalFrame.setName(string);
        uIFactory.setAccessibleInfo(jInternalFrame, string);
        JRootPane jRootPane = jInternalFrame.getRootPane();
        jRootPane.setName(string + ".root");
        AccessibleContext accessibleContext = jInternalFrame.getAccessibleContext();
        AccessibleContext accessibleContext2 = jRootPane.getAccessibleContext();
        accessibleContext2.setAccessibleName(accessibleContext.getAccessibleName());
        accessibleContext2.setAccessibleDescription(accessibleContext.getAccessibleDescription());
        if (jMenuBar != null) {
            jInternalFrame.setJMenuBar(jMenuBar);
        }
        jInternalFrame.setContentPane(container);
        if (rectangle == null) {
            jInternalFrame.pack();
            Dimension dimension = jInternalFrame.getSize();
            JInternalFrame jInternalFrame2 = (JInternalFrame)this.internalFrames.get(tool);
            Rectangle rectangle2 = jInternalFrame2.getBounds();
            jInternalFrame.setLocation(Math.max(0, rectangle2.x + (rectangle2.width - dimension.width) / 2), Math.max(0, rectangle2.y + (rectangle2.height - dimension.height) / 2));
        } else {
            jInternalFrame.setBounds(rectangle);
        }
        JLayeredPane.putLayer(jInternalFrame, JLayeredPane.DEFAULT_LAYER + 1);
        this.desktopPane.add(jInternalFrame);
        return jInternalFrame;
    }

    protected void saveDesktop(Map map) {
        super.saveDesktop(map);
        Desktop.saveBounds(this.mainFrame, new PrefixMap(map, "dt"));
    }

    protected void restoreDesktop(Map map) {
        super.restoreDesktop(map);
        Desktop.restoreBounds(this.mainFrame, new PrefixMap(map, "dt"));
    }

    protected void saveTool(Map map, Tool tool) {
        super.saveTool(map, tool);
        JInternalFrame jInternalFrame = (JInternalFrame)this.internalFrames.get(tool);
        Desktop.saveBounds(jInternalFrame, new PrefixMap(map, "dt"));
    }

    protected Tool restoreTool(Map map) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Tool tool = super.restoreTool(map);
        JInternalFrame jInternalFrame = (JInternalFrame)this.internalFrames.get(tool);
        Desktop.restoreBounds(jInternalFrame, new PrefixMap(map, "dt"));
        jInternalFrame.setVisible(true);
        return tool;
    }

    private void initMainFrame(Rectangle rectangle) {
        this.mainFrame = this.createFrame(this.listener, "mdi.main");
        this.desktopPane = new JDesktopPane();
        this.desktopPane.setName("mdi.desk");
        Desktop.uif.setAccessibleInfo(this.desktopPane, "mdi.desk");
        this.desktopPane.setPreferredSize(new Dimension(rectangle.width, rectangle.height));
        this.mainFrame.setContentPane(this.desktopPane);
        if (rectangle == null) {
            this.mainFrame.pack();
            this.mainFrame.setLocationRelativeTo(null);
        } else {
            this.mainFrame.setBounds(rectangle);
        }
        this.mainFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MDIDesktop.this.checkToolsAndExitIfOK(MDIDesktop.this.mainFrame);
            }
        });
    }

    private void doCascade() {
        Point point = new Point(0, 0);
        JInternalFrame[] jInternalFrameArray = this.getVisibleInternalFrames();
        int n = 0;
        while (n < jInternalFrameArray.length) {
            JInternalFrame jInternalFrame = jInternalFrameArray[n];
            jInternalFrame.setLocation(point);
            this.desktopPane.moveToFront(jInternalFrame);
            if (n == jInternalFrameArray.length - 1) {
                try {
                    jInternalFrame.setSelected(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            BasicInternalFrameUI basicInternalFrameUI = (BasicInternalFrameUI)jInternalFrame.getUI();
            int n2 = basicInternalFrameUI.getNorthPane().getHeight();
            point.x += n2;
            point.y += n2;
            ++n;
        }
    }

    private void doTile() {
        JInternalFrame[] jInternalFrameArray = this.getVisibleInternalFrames();
        int n = jInternalFrameArray.length;
        int n2 = (int)Math.sqrt(n);
        int n3 = (n + n2 - 1) / n2;
        Dimension dimension = this.desktopPane.getSize();
        Dimension dimension2 = new Dimension(dimension.width / n2, dimension.height / n3);
        int n4 = 0;
        while (n4 < jInternalFrameArray.length) {
            JInternalFrame jInternalFrame = jInternalFrameArray[n4];
            int n5 = n4 % n2;
            int n6 = n4 / n2;
            jInternalFrame.setBounds(n5 * dimension2.width, n6 * dimension2.height, dimension2.width, dimension2.height);
            ++n4;
        }
    }

    private JInternalFrame[] getVisibleInternalFrames() {
        Object object;
        Vector<Object[]> vector = new Vector<Object[]>();
        int n = 0;
        while (n < this.desktopPane.getComponentCount()) {
            object = this.desktopPane.getComponent(n);
            if (object instanceof JInternalFrame && object.isVisible()) {
                vector.add((Object[])object);
            }
            ++n;
        }
        object = new JInternalFrame[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    private class Listener
    implements ActionListener,
    AncestorListener,
    InternalFrameListener,
    MenuListener,
    Tool.Observer {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(MDIDesktop.CASCADE)) {
                MDIDesktop.this.doCascade();
            } else if (string.equals(MDIDesktop.TILE)) {
                MDIDesktop.this.doTile();
            } else {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                Object object = jMenuItem.getClientProperty(this);
                if (object instanceof Window) {
                    ((Window)object).toFront();
                }
                if (object instanceof JInternalFrame) {
                    ((JInternalFrame)object).toFront();
                } else if (object instanceof Tool) {
                    MDIDesktop.this.setSelectedTool((Tool)object);
                }
            }
        }

        public void ancestorAdded(AncestorEvent ancestorEvent) {
            Tool[] toolArray = MDIDesktop.this.getTools();
            int n = 0;
            while (n < toolArray.length) {
                Tool tool = toolArray[n];
                tool.addObserver(MDIDesktop.this.listener);
                ++n;
            }
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            Tool[] toolArray = MDIDesktop.this.getTools();
            int n = 0;
            while (n < toolArray.length) {
                Tool tool = toolArray[n];
                tool.removeObserver(MDIDesktop.this.listener);
                ++n;
            }
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            JInternalFrame jInternalFrame = (JInternalFrame)internalFrameEvent.getSource();
            if (jInternalFrame.getContentPane() instanceof Tool) {
                Tool tool = (Tool)jInternalFrame.getContentPane();
                MDIDesktop.this.removeTool(tool);
                tool.removeObserver(MDIDesktop.this.listener);
                tool.dispose();
                jInternalFrame.getJMenuBar().removeAll();
                jInternalFrame.setContentPane(new Container());
            }
        }

        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
            JInternalFrame jInternalFrame = (JInternalFrame)internalFrameEvent.getSource();
            Tool tool = (Tool)jInternalFrame.getContentPane();
            if (MDIDesktop.this.isOKToClose(tool, MDIDesktop.this.mainFrame)) {
                jInternalFrame.dispose();
            }
        }

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
        }

        public void menuSelected(MenuEvent menuEvent) {
            Window[] windowArray;
            JInternalFrame[] jInternalFrameArray;
            Tool[] toolArray = MDIDesktop.this.getTools();
            JMenu jMenu = (JMenu)menuEvent.getSource();
            jMenu.removeAll();
            JMenuItem jMenuItem = Desktop.uif.createMenuItem("dt.windows", MDIDesktop.TILE, this);
            jMenuItem.setEnabled(toolArray.length > 0);
            jMenu.add(jMenuItem);
            JMenuItem jMenuItem2 = Desktop.uif.createMenuItem("dt.windows", MDIDesktop.CASCADE, this);
            jMenuItem2.setEnabled(toolArray.length > 0);
            jMenu.add(jMenuItem2);
            if (toolArray.length > 0) {
                jMenu.addSeparator();
            }
            int n = 0;
            int n2 = 0;
            while (n2 < toolArray.length) {
                jInternalFrameArray = toolArray[n2];
                this.addMenuItem(jMenu, n++, jInternalFrameArray.getTitle(), jInternalFrameArray);
                ++n2;
            }
            jInternalFrameArray = MDIDesktop.this.desktopPane.getAllFrames();
            int n3 = 0;
            while (n3 < jInternalFrameArray.length) {
                windowArray = jInternalFrameArray[n3];
                if (windowArray.isVisible() && !(windowArray.getContentPane() instanceof Tool)) {
                    this.addMenuItem(jMenu, n++, windowArray.getTitle(), windowArray);
                }
                ++n3;
            }
            windowArray = MDIDesktop.this.mainFrame.getOwnedWindows();
            int n4 = 0;
            while (n4 < windowArray.length) {
                Window window = windowArray[n4];
                if (window instanceof JDialog && window.isVisible()) {
                    this.addMenuItem(jMenu, n++, ((JDialog)window).getTitle(), window);
                }
                ++n4;
            }
        }

        private void addMenuItem(JMenu jMenu, int n, String string, Object object) {
            JMenuItem jMenuItem = new JMenuItem(Desktop.uif.getI18NString("dt.windows.toolX.mit", new Object[]{new Integer(n), string}));
            if (n < 10) {
                jMenuItem.setMnemonic(Character.forDigit(n, 10));
            }
            jMenuItem.addActionListener(this);
            jMenuItem.putClientProperty(this, object);
            jMenu.add(jMenuItem);
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }

        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void titleChanged(Tool tool, String string) {
            JInternalFrame jInternalFrame = (JInternalFrame)MDIDesktop.this.internalFrames.get(tool);
            jInternalFrame.setTitle(string);
        }
    }
}

