/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.I18NUtils;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class IconFactory {
    private static Icon file;
    private static Icon openableFolder;
    private static Icon selectableFolder;
    private static Icon upFolder;
    private static final int NOT_FILLED = 0;
    private static final int PARTIALLY_FILLED = 1;
    private static final int ALL_FILLED = 2;
    private static I18NResourceBundle i18n;
    private static final Dimension folderIcon16Size;
    private static final Dimension fileIcon16Size;
    public static final int PASSED = 0;
    public static final int FAILED = 1;
    public static final int ERROR = 2;
    public static final int NOT_RUN = 3;
    public static final int FILTERED_OUT = 4;
    public static final int NUM_STATES = 5;
    private static Icon[] testIcons;
    private static Icon[] testFolderIcons;
    private static Icon[] testSectionIcons;
    static int testIconWidth;
    static int testIconHeight;
    static int lightX;
    static int lightY;
    static int arrowWidth;
    static int arrowHeight;
    static int testImageWidth;
    static int testImageHeight;
    static int testCornerSize;
    static int testFolderImageWidth;
    static int testFolderImageHeight;
    static int testFolderTabWidth;
    static int testFolderTabHeight;
    static int sectIconWidth;
    static int sectIconHeight;
    static int sectImageSize;
    static int sectHighlightSize;
    private static final Color semiWhite;
    private static Color arrowColor;
    private static Color arrowShadowColor;
    static /* synthetic */ Class class$com$sun$javatest$tool$IconFactory;

    public static Icon getFileIcon() {
        if (file == null) {
            file = new FileIcon16();
        }
        return file;
    }

    public static Icon getFolderIcon() {
        return IconFactory.getOpenableFolderIcon();
    }

    public static Icon getUpFolderIcon() {
        if (upFolder == null) {
            upFolder = new UpFolderIcon16();
        }
        return upFolder;
    }

    public static Icon getOpenableFolderIcon() {
        if (openableFolder == null) {
            openableFolder = new FolderIcon16(2);
        }
        return openableFolder;
    }

    public static Icon getSelectableFolderIcon() {
        if (selectableFolder == null) {
            selectableFolder = new FolderIcon16(0);
        }
        return selectableFolder;
    }

    public static Icon getTestIcon(int n, boolean bl, boolean bl2) {
        if (n < 0 || n >= 5) {
            throw new IllegalArgumentException(Integer.toString(n));
        }
        int n2 = 4 * n + 2 * (bl ? 1 : 0) + (bl2 ? 1 : 0);
        Icon icon = testIcons[n2];
        if (icon == null) {
            IconFactory.testIcons[n2] = icon = new TestIcon(n, bl, bl2);
        }
        return icon;
    }

    public static Icon getTestFolderIcon(int n, boolean bl, boolean bl2) {
        if (n < 0 || n >= 5) {
            throw new IllegalArgumentException(Integer.toString(n));
        }
        int n2 = 4 * n + 2 * (bl ? 1 : 0) + (bl2 ? 1 : 0);
        Icon icon = testFolderIcons[n2];
        if (icon == null) {
            IconFactory.testFolderIcons[n2] = icon = new TestFolderIcon(n, bl, bl2);
        }
        return icon;
    }

    public static Icon getTestSectionIcon(int n) {
        if (n < 0 || n >= 5) {
            throw new IllegalArgumentException(Integer.toString(n));
        }
        int n2 = n;
        Icon icon = testSectionIcons[n2];
        if (icon == null) {
            IconFactory.testSectionIcons[n2] = icon = new TestSectionIcon(n);
        }
        return icon;
    }

    private static void drawArrow(int n, int n2, int n3, int n4, Graphics graphics) {
        IconFactory.drawArrow(n + 1, n2 + 1, n3, n4, graphics, arrowColor);
        IconFactory.drawArrow(n, n2, n3, n4, graphics, arrowShadowColor);
    }

    private static void drawArrow(int n, int n2, int n3, int n4, Graphics graphics, Color color) {
        graphics.setColor(color);
        int[] nArray = new int[]{n, n + n3, n};
        int[] nArray2 = new int[]{n2, n2 + n4 / 2, n2 + n4};
        graphics.fillPolygon(nArray, nArray2, 3);
    }

    private static void drawGlyph(int n, int n2, int n3, Graphics graphics) {
        IconFactory.drawGlyph(n, n2 + 1, n3 + 1, graphics, semiWhite);
        IconFactory.drawGlyph(n, n2, n3, graphics, Color.black);
    }

    private static void drawGlyph(int n, int n2, int n3, Graphics graphics, Color color) {
        graphics.setColor(color);
        switch (n) {
            case 0: {
                graphics.drawLine(n2 + 0, n3 + 3, n2 + 2, n3 + 5);
                graphics.drawLine(n2 + 1, n3 + 3, n2 + 2, n3 + 4);
                graphics.drawLine(n2 + 2, n3 + 4, n2 + 5, n3 + 1);
                graphics.drawLine(n2 + 2, n3 + 5, n2 + 5, n3 + 2);
                break;
            }
            case 1: {
                graphics.drawLine(n2 + 0, n3 + 0, n2 + 4, n3 + 4);
                graphics.drawLine(n2 + 0, n3 + 1, n2 + 4, n3 + 5);
                graphics.drawLine(n2 + 0, n3 + 4, n2 + 4, n3 + 0);
                graphics.drawLine(n2 + 0, n3 + 5, n2 + 4, n3 + 1);
                break;
            }
            case 2: {
                graphics.drawLine(n2 + 2, n3 + 0, n2 + 2, n3 + 3);
                graphics.drawLine(n2 + 2, n3 + 5, n2 + 2, n3 + 5);
                graphics.drawLine(n2 + 3, n3 + 0, n2 + 3, n3 + 3);
                graphics.drawLine(n2 + 3, n3 + 5, n2 + 3, n3 + 5);
                break;
            }
            case 3: {
                graphics.drawLine(n2 + 1, n3 + 3, n2 + 4, n3 + 3);
            }
        }
    }

    private static void fill(BufferedImage bufferedImage, int n, int n2, int n3, int n4, Color color) {
        int n5 = testIconWidth;
        int n6 = testIconHeight;
        int n7 = n5 - lightX;
        int n8 = n6 - lightY;
        float f = (float)Math.sqrt(n7 * n7 + n8 * n8);
        int n9 = color.getRed();
        int n10 = color.getGreen();
        int n11 = color.getBlue();
        float[] fArray = Color.RGBtoHSB(n9, n10, n11, null);
        float f2 = fArray[1];
        float f3 = fArray[2];
        float f4 = 1.0f;
        float f5 = (f3 - f4) / f;
        float f6 = 0.0f;
        float f7 = (f2 - f6) / f;
        int n12 = n;
        while (n12 < n3) {
            int n13 = n2;
            while (n13 < n4) {
                int n14 = n12 - lightX;
                int n15 = n13 - lightY;
                float f8 = (float)Math.sqrt(n14 * n14 + n15 * n15);
                float f9 = f7 * f8 + f6;
                float f10 = f5 * f8 + f4;
                int n16 = Color.HSBtoRGB(fArray[0], f9, f10);
                bufferedImage.setRGB(n12, n13, n16);
                ++n13;
            }
            ++n12;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$tool$IconFactory == null ? (class$com$sun$javatest$tool$IconFactory = IconFactory.class$("com.sun.javatest.tool.IconFactory")) : class$com$sun$javatest$tool$IconFactory);
        folderIcon16Size = new Dimension(16, 16);
        fileIcon16Size = new Dimension(16, 16);
        testIcons = new Icon[20];
        testFolderIcons = new Icon[20];
        testSectionIcons = new Icon[5];
        testIconWidth = 20;
        testIconHeight = 16;
        lightX = 5;
        lightY = 1;
        arrowWidth = 7;
        arrowHeight = 8;
        testImageWidth = 11;
        testImageHeight = 15;
        testCornerSize = 4;
        testFolderImageWidth = 16;
        testFolderImageHeight = 13;
        testFolderTabWidth = 8;
        testFolderTabHeight = 2;
        sectIconWidth = 16;
        sectIconHeight = 16;
        sectImageSize = 11;
        sectHighlightSize = 4;
        semiWhite = new Color(255, 255, 255, 128);
        arrowColor = MetalLookAndFeel.getPrimaryControl();
        arrowShadowColor = MetalLookAndFeel.getPrimaryControlShadow();
    }

    private static class TestSectionIcon
    implements Icon {
        private int state;
        private BufferedImage image;

        TestSectionIcon(int n) {
            this.state = n;
        }

        public int getIconWidth() {
            return sectIconWidth;
        }

        public int getIconHeight() {
            return sectIconHeight;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.image == null) {
                this.image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                this.paintMe(this.image);
            }
            graphics.drawImage(this.image, n, n2, null);
        }

        private void paintMe(BufferedImage bufferedImage) {
            Graphics graphics = bufferedImage.getGraphics();
            Color color = I18NUtils.getColorForState(this.state);
            Color color2 = color.darker().darker();
            int n = (sectIconWidth - sectImageSize) / 2;
            int n2 = n + sectImageSize;
            int n3 = (sectIconHeight - sectImageSize) / 2;
            int n4 = n3 + sectImageSize;
            graphics.setColor(color2);
            graphics.fillOval(n, n3, n2 - n, n4 - n3);
            graphics.setColor(color);
            graphics.fillOval(n + 1, n3 + 1, n2 - n - 2, n4 - n3 - 2);
            int n5 = n + sectImageSize / 3;
            int n6 = n3 + sectImageSize / 3;
            int n7 = n5 - sectHighlightSize;
            while (n7 <= n5 + sectHighlightSize) {
                int n8 = n6 - sectHighlightSize;
                while (n8 <= n6 + sectHighlightSize) {
                    int n9 = n7 - n5;
                    int n10 = n8 - n6;
                    float f = (float)Math.sqrt(n9 * n9 + n10 * n10);
                    int n11 = Math.min((int)(f * 255.0f / (float)sectHighlightSize), 255);
                    graphics.setColor(new Color(255, 255, 255, 255 - n11));
                    graphics.drawLine(n7, n8, n7, n8);
                    ++n8;
                }
                ++n7;
            }
            graphics.dispose();
        }
    }

    private static class TestFolderIcon
    implements Icon {
        private int state;
        private boolean active;
        private boolean glyph;
        private BufferedImage image;

        TestFolderIcon(int n, boolean bl, boolean bl2) {
            this.state = n;
            this.active = bl;
            this.glyph = bl2;
        }

        public int getIconWidth() {
            return testIconWidth;
        }

        public int getIconHeight() {
            return testIconHeight;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.image == null) {
                this.image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                this.paintMe(this.image);
            }
            graphics.drawImage(this.image, n, n2, null);
        }

        private void paintMe(BufferedImage bufferedImage) {
            Graphics graphics = bufferedImage.getGraphics();
            Color color = I18NUtils.getColorForState(this.state);
            int n = 2 + (testIconWidth - testFolderImageWidth) / 2;
            int n2 = n + testFolderImageWidth - 1;
            int n3 = (testIconHeight - testFolderImageHeight) / 2;
            int n4 = n3 + testFolderImageHeight - 1;
            Color color2 = color.darker().darker();
            graphics.setColor(color2);
            graphics.drawRect(n, n3 + testFolderTabHeight, n2 - n, n4 - n3 - testFolderTabHeight);
            IconFactory.fill(bufferedImage, n + 1, n3 + testFolderTabHeight + 1, n2, n4, color);
            graphics.setColor(color2);
            int n5 = 0;
            while (n5 < testFolderTabHeight) {
                int n6 = testFolderTabHeight - n5;
                graphics.drawLine(n2 - testFolderTabWidth + n6, n3 + n5, n2 - n6, n3 + n5);
                graphics.drawLine(n2 - testFolderTabWidth + n5, n3 + testFolderTabHeight + n5, n2, n3 + testFolderTabHeight + n5);
                ++n5;
            }
            if (this.glyph) {
                IconFactory.drawGlyph(this.state, (n + n2) / 2 - 3, testFolderTabHeight + 1 + (n3 - testFolderTabHeight + n4) / 2 - 3, graphics);
            }
            if (this.active) {
                IconFactory.drawArrow(0, (testIconHeight - arrowHeight) / 2, arrowWidth, arrowHeight, graphics);
            }
            graphics.dispose();
        }
    }

    private static class TestIcon
    implements Icon {
        private int state;
        private boolean active;
        private boolean glyph;
        private BufferedImage image;

        TestIcon(int n, boolean bl, boolean bl2) {
            this.state = n;
            this.active = bl;
            this.glyph = bl2;
        }

        public int getIconWidth() {
            return testIconWidth;
        }

        public int getIconHeight() {
            return testIconHeight;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.image == null) {
                this.image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                this.paintMe(this.image);
            }
            graphics.drawImage(this.image, n, n2, null);
        }

        private void paintMe(BufferedImage bufferedImage) {
            Graphics graphics = bufferedImage.getGraphics();
            Color color = I18NUtils.getColorForState(this.state);
            int n = 2 + (testIconWidth - testImageWidth) / 2;
            int n2 = n + testImageWidth - 1;
            int n3 = (testIconHeight - testImageHeight) / 2;
            int n4 = n3 + testImageHeight - 1;
            int n5 = n2 - testCornerSize;
            Color color2 = color.darker().darker();
            graphics.setColor(color2);
            graphics.drawLine(n, n3, n5, n3);
            graphics.drawLine(n, n3, n, n4 - 1);
            graphics.drawLine(n, n4 - 1, n2 - 1, n4 - 1);
            graphics.drawLine(n2 - 1, n3 + testCornerSize, n2 - 1, n4 - 1);
            int n6 = 0;
            while (n6 < testCornerSize) {
                graphics.drawLine(n5, n3 + n6, n5 + n6, n3 + n6);
                ++n6;
            }
            IconFactory.fill(bufferedImage, n + 1, n3 + 1, n5, n3 + testCornerSize, color);
            IconFactory.fill(bufferedImage, n + 1, n3 + testCornerSize, n2 - 1, n4 - 1, color);
            if (this.glyph) {
                IconFactory.drawGlyph(this.state, (n + n2) / 2 - 3, (n3 + n4) / 2 - 3, graphics);
            }
            if (this.active) {
                IconFactory.drawArrow(0, (testIconHeight - arrowHeight) / 2, arrowWidth, arrowHeight, graphics);
            }
            graphics.dispose();
        }
    }

    private static class TreeLeafIcon
    extends FileIcon16 {
        private TreeLeafIcon() {
        }

        public int getShift() {
            return 2;
        }

        public int getAdditionalHeight() {
            return 4;
        }
    }

    private static class FileIcon16
    implements Icon {
        private Image image;

        private FileIcon16() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.image == null) {
                this.image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                Graphics graphics2 = this.image.getGraphics();
                this.paintMe(component, graphics2);
                graphics2.dispose();
            }
            graphics.drawImage(this.image, n, n2 + this.getShift(), null);
        }

        private void paintMe(Component component, Graphics graphics) {
            int n = fileIcon16Size.width - 1;
            int n2 = fileIcon16Size.height - 1;
            graphics.setColor(MetalLookAndFeel.getWindowBackground());
            graphics.fillRect(4, 2, 9, 12);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(2, 0, 2, n2);
            graphics.drawLine(2, 0, n - 4, 0);
            graphics.drawLine(2, n2, n - 1, n2);
            graphics.drawLine(n - 1, 6, n - 1, n2);
            graphics.drawLine(n - 6, 2, n - 2, 6);
            graphics.drawLine(n - 5, 1, n - 4, 1);
            graphics.drawLine(n - 3, 2, n - 3, 3);
            graphics.drawLine(n - 2, 4, n - 2, 5);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.drawLine(3, 1, 3, n2 - 1);
            graphics.drawLine(3, 1, n - 6, 1);
            graphics.drawLine(n - 2, 7, n - 2, n2 - 1);
            graphics.drawLine(n - 5, 2, n - 3, 4);
            graphics.drawLine(3, n2 - 1, n - 2, n2 - 1);
        }

        public int getShift() {
            return 0;
        }

        public int getAdditionalHeight() {
            return 0;
        }

        public int getIconWidth() {
            return fileIcon16Size.width;
        }

        public int getIconHeight() {
            return fileIcon16Size.height + this.getAdditionalHeight();
        }
    }

    private static class UpFolderIcon16
    implements Icon {
        private UpFolderIcon16() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.fillRect(3, 5, 12, 9);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(1, 6, 1, 14);
            graphics.drawLine(2, 14, 15, 14);
            graphics.drawLine(15, 13, 15, 5);
            graphics.drawLine(2, 5, 9, 5);
            graphics.drawLine(10, 6, 14, 6);
            graphics.drawLine(8, 13, 8, 16);
            graphics.drawLine(8, 9, 8, 9);
            graphics.drawLine(7, 10, 9, 10);
            graphics.drawLine(6, 11, 10, 11);
            graphics.drawLine(5, 12, 11, 12);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            graphics.drawLine(2, 6, 2, 13);
            graphics.drawLine(3, 6, 9, 6);
            graphics.drawLine(10, 7, 14, 7);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics.drawLine(11, 3, 15, 3);
            graphics.drawLine(10, 4, 15, 4);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }
    }

    private static class TreeFolderIcon
    extends FolderIcon16 {
        TreeFolderIcon(int n) {
            super(n);
        }

        public int getShift() {
            return -1;
        }

        public int getAdditionalHeight() {
            return 2;
        }
    }

    private static class FolderIcon16
    implements Icon {
        private int style;
        private Image image;

        FolderIcon16(int n) {
            this.style = n;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.image == null) {
                this.image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                Graphics graphics2 = this.image.getGraphics();
                this.paintMe(component, graphics2);
                graphics2.dispose();
            }
            graphics.drawImage(this.image, n, n2 + this.getShift(), null);
        }

        private void paintMe(Component component, Graphics graphics) {
            int n = folderIcon16Size.width - 1;
            int n2 = folderIcon16Size.height - 1;
            graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics.drawLine(n - 5, 3, n, 3);
            graphics.drawLine(n - 6, 4, n, 4);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.fillRect(2, 7, 13, 8);
            switch (this.style) {
                case 0: {
                    graphics.setColor(Color.white);
                    graphics.fillRect(2, 7, 13, 8);
                    break;
                }
                case 1: {
                    graphics.setColor(Color.white);
                    int n3 = 0;
                    while (n3 < 8) {
                        graphics.drawLine(4 + n3, 7 + n3, 18, 7 + n3);
                        ++n3;
                    }
                    break;
                }
            }
            graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            graphics.drawLine(n - 6, 5, n - 1, 5);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(0, 6, 0, n2);
            graphics.drawLine(1, 5, n - 7, 5);
            graphics.drawLine(n - 6, 6, n - 1, 6);
            graphics.drawLine(n, 5, n, n2);
            graphics.drawLine(0, n2, n, n2);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            graphics.drawLine(1, 6, 1, n2 - 1);
            graphics.drawLine(1, 6, n - 7, 6);
            graphics.drawLine(n - 6, 7, n - 1, 7);
        }

        public int getShift() {
            return 0;
        }

        public int getAdditionalHeight() {
            return 0;
        }

        public int getIconWidth() {
            return folderIcon16Size.width;
        }

        public int getIconHeight() {
            return folderIcon16Size.height + this.getAdditionalHeight();
        }
    }
}

