/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.Status;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.Color;

public class I18NUtils {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$tool$I18NUtils == null ? (class$com$sun$javatest$tool$I18NUtils = I18NUtils.class$("com.sun.javatest.tool.I18NUtils")) : class$com$sun$javatest$tool$I18NUtils);
    private static Color passedColor = I18NUtils.getPreferredColor("color.passed", "i18n.passed", 65280, true);
    private static Color failedColor = I18NUtils.getPreferredColor("color.failed", "i18n.failed", 0xFF0000, true);
    private static Color errorColor = I18NUtils.getPreferredColor("color.error", "i18n.error", 0x3F3FFF, true);
    private static Color notRunColor = I18NUtils.getPreferredColor("color.notrun", "i18n.notRun", 0xFFFFFF, true);
    private static Color filteredOutColor = I18NUtils.getPreferredColor("color.filter", "i18n.filtered", 0x3F3F3F, true);
    private static final String PASS_COLOR_PREF = "color.passed";
    private static final String FAIL_COLOR_PREF = "color.failed";
    private static final String ERR_COLOR_PREF = "color.error";
    private static final String NOTRUN_COLOR_PREF = "color.notrun";
    private static final String FILTERED_COLOR_PREF = "color.filter";
    public static final int PASSED = 0;
    public static final int FAILED = 1;
    public static final int ERROR = 2;
    public static final int NOT_RUN = 3;
    public static final int FILTERED_OUT = 4;
    public static final int NUM_STATES = 5;
    private static String[] STATUS_STRINGS;
    static /* synthetic */ Class class$com$sun$javatest$tool$I18NUtils;

    public static Color getStatusColor(int n) {
        return I18NUtils.getColorForState(n);
    }

    public static Color getStatusBarColor(int n) {
        return I18NUtils.lighter(I18NUtils.getColorForState(n));
    }

    public static String getStatusString(int n) {
        if (STATUS_STRINGS == null) {
            I18NUtils.loadStatusStrings();
        }
        if (n < STATUS_STRINGS.length) {
            return STATUS_STRINGS[n];
        }
        return i18n.getString("i18n.unknown");
    }

    public static String getStatusMessage(Status status) {
        if (STATUS_STRINGS == null) {
            I18NUtils.loadStatusStrings();
        }
        return STATUS_STRINGS[status.getType()] + " " + status.getReason();
    }

    static Color getColorForState(int n) {
        switch (n) {
            case 0: {
                return passedColor;
            }
            case 1: {
                return failedColor;
            }
            case 2: {
                return errorColor;
            }
            case 3: {
                return notRunColor;
            }
            case 4: {
                return filteredOutColor;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadStatusStrings() {
        Class clazz = class$com$sun$javatest$tool$I18NUtils == null ? (class$com$sun$javatest$tool$I18NUtils = I18NUtils.class$("com.sun.javatest.tool.I18NUtils")) : class$com$sun$javatest$tool$I18NUtils;
        synchronized (clazz) {
            if (STATUS_STRINGS == null) {
                STATUS_STRINGS = new String[5];
                int n = 0;
                while (n < 5) {
                    I18NUtils.STATUS_STRINGS[n] = i18n.getString("i18n.status" + n);
                    ++n;
                }
            }
        }
    }

    private static Color lighter(Color color) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        fArray[1] = fArray[1] * 0.75f;
        fArray[2] = Math.min(fArray[2] * 1.1f, 1.0f);
        return new Color(Color.HSBtoRGB(fArray[0], fArray[1], fArray[2]));
    }

    private static Color getI18NColor(String string, int n) {
        String string2 = i18n.getString(string + ".clr");
        try {
            if (string2 != null) {
                return Color.decode(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Color(n);
    }

    private static Color getPreferredColor(String string, String string2, int n, boolean bl) {
        Color color = null;
        color = Color.getColor("javatest." + string);
        if (color != null) {
            if (bl) {
                Preferences preferences = Preferences.access();
                preferences.setPreference(string, Integer.toString(color.getRGB()));
            }
            return color;
        }
        Preferences preferences = Preferences.access();
        String string3 = preferences.getPreference(string);
        if (string3 != null) {
            try {
                color = Color.decode(string3);
            }
            catch (NumberFormatException numberFormatException) {
                color = null;
            }
            if (color != null) {
                return color;
            }
        }
        color = I18NUtils.getI18NColor(string2, n);
        return color;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

