/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.Harness;
import com.sun.javatest.ProductInfo;
import com.sun.javatest.TestSuite;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.UIFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

class HelpMenu
extends JMenu {
    private Component parent;
    private HelpBroker helpBroker;
    private UIFactory uif;
    private Listener listener;
    private static WeakHashMap docTable = new WeakHashMap();
    private static WeakHashMap helpBrokerTable = new WeakHashMap();
    private static final String HELP = "help";
    private static final String ABOUT_JAVA = "aboutJava";
    private static final String ABOUT_JAVATEST = "aboutJavaTest";

    HelpMenu(Component component, HelpBroker helpBroker, UIFactory uIFactory) {
        this.parent = component;
        this.helpBroker = helpBroker;
        this.uif = uIFactory;
        this.listener = new Listener();
        String[] stringArray = new String[]{HELP, null, ABOUT_JAVATEST, ABOUT_JAVA};
        uIFactory.initMenu(this, HELP, stringArray, this.listener);
        this.addMenuListener(this.listener);
    }

    private void addTestSuiteItems() {
        Desktop desktop = Desktop.access();
        Tool[] toolArray = desktop.getTools();
        if (toolArray == null || toolArray.length == 0) {
            return;
        }
        TreeSet<TestSuite> treeSet = new TreeSet<TestSuite>(new Comparator(){

            public int compare(Object object, Object object2) {
                TestSuite testSuite = (TestSuite)object;
                TestSuite testSuite2 = (TestSuite)object2;
                return testSuite.getName().compareTo(testSuite2.getName());
            }
        });
        Tool tool = desktop.getSelectedTool();
        if (tool != null) {
            TestSuite[] testSuiteArray = tool.getLoadedTestSuites();
            if (testSuiteArray != null) {
                treeSet.addAll(Arrays.asList(testSuiteArray));
            }
        } else {
            int n = 0;
            while (n < toolArray.length) {
                TestSuite[] testSuiteArray = toolArray[n].getLoadedTestSuites();
                if (testSuiteArray != null) {
                    treeSet.addAll(Arrays.asList(testSuiteArray));
                }
                ++n;
            }
        }
        int n = this.getItemCount() - 1;
        while (n > 0 && this.getItem(n - 1) != null) {
            --n;
        }
        int n2 = 0;
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            TestSuite testSuite = (TestSuite)iterator.next();
            JMenuItem[] jMenuItemArray = this.getMenuItems(testSuite, n2);
            if (jMenuItemArray == null || jMenuItemArray.length <= 0) continue;
            int n3 = 0;
            while (n3 < jMenuItemArray.length) {
                JMenuItem jMenuItem = jMenuItemArray[n3];
                jMenuItem.putClientProperty(this.getClass(), this);
                this.insert(jMenuItem, n++);
                ++n3;
            }
            this.insertSeparator(n++);
            n2 += jMenuItemArray.length;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void removeTestSuiteItems() {
        var1_1 = 0;
        while (var1_1 < this.getItemCount()) {
            var2_2 = this.getItem(var1_1);
            if (var2_2 == null || var2_2.getClientProperty(this.getClass()) != this) {
                ++var1_1;
                continue;
            }
            ** GOTO lbl11
        }
        return;
        while ((var2_2 = this.getItem(var1_1)) == null || var2_2.getClientProperty(this.getClass()) == this) {
            this.remove(var1_1);
lbl11:
            // 2 sources

            if (var1_1 < this.getItemCount()) continue;
        }
    }

    private void showAbout(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = 0;
        while ((n2 = string2.indexOf(10, n)) != -1) {
            vector.addElement(string2.substring(n, n2));
            n = n2 + 1;
        }
        vector.addElement(string2.substring(n));
        JTextField[] jTextFieldArray = new JTextField[vector.size()];
        int n3 = 0;
        while (n3 < vector.size()) {
            JTextField jTextField = new JTextField((String)vector.elementAt(n3));
            jTextField.setBorder(null);
            jTextField.setHorizontalAlignment(0);
            jTextField.setOpaque(false);
            jTextField.setEditable(false);
            jTextFieldArray[n3] = jTextField;
            ++n3;
        }
        JOptionPane.showMessageDialog(this.parent, jTextFieldArray, string, 1, Desktop.access().getLogo());
    }

    private void showHelpSet(HelpSet helpSet) {
        HelpBroker helpBroker = this.getHelpBroker(helpSet);
        helpBroker.setDisplayed(true);
    }

    private HelpBroker getHelpBroker(HelpSet helpSet) {
        HelpBroker helpBroker = (HelpBroker)helpBrokerTable.get(helpSet);
        if (helpBroker == null) {
            int n = this.uif.getDotsPerInch();
            helpBroker = helpSet.createHelpBroker();
            helpBroker.setSize(new Dimension(7 * n, 9 * n));
            helpBrokerTable.put(helpSet, helpBroker);
        }
        return helpBroker;
    }

    private JMenuItem[] getMenuItems(TestSuite testSuite, int n) {
        Object[] objectArray;
        HelpSet[] helpSetArray = (HelpSet[])docTable.get(testSuite);
        if (helpSetArray == null) {
            try {
                helpSetArray = testSuite.getAdditionalDocs();
            }
            catch (TestSuite.Fault fault) {
                String string = this.uif.getI18NString("help.menu.cantLoadDocs", new Object[]{testSuite.getName(), fault.getMessage()});
                System.err.println(string);
            }
            if (helpSetArray == null) {
                helpSetArray = new HelpSet[]{};
            }
            docTable.put(testSuite, helpSetArray);
        }
        if (helpSetArray.length == 0) {
            return null;
        }
        Vector<JMenuItem> vector = new Vector<JMenuItem>();
        int n2 = 0;
        while (n2 < helpSetArray.length) {
            JMenuItem jMenuItem;
            objectArray = helpSetArray[n2];
            if (n + n2 < 10) {
                jMenuItem = new JMenuItem(n + n2 + " " + objectArray.getTitle());
                jMenuItem.setMnemonic(48 + n + n2);
            } else {
                jMenuItem = new JMenuItem("  " + objectArray.getTitle());
            }
            jMenuItem.addActionListener(new ActionListener((HelpSet)objectArray){
                private final /* synthetic */ HelpSet val$doc;
                {
                    this.val$doc = helpSet;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    HelpMenu.this.showHelpSet(this.val$doc);
                }
            });
            vector.add(jMenuItem);
            ++n2;
        }
        objectArray = new JMenuItem[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private class Listener
    implements MenuListener,
    ActionListener {
        private Listener() {
        }

        public void menuSelected(MenuEvent menuEvent) {
            HelpMenu.this.removeTestSuiteItems();
            HelpMenu.this.addTestSuiteItems();
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }

        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(HelpMenu.ABOUT_JAVATEST)) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                DateFormat dateFormat = DateFormat.getDateInstance(1);
                String string2 = null;
                Date date = ProductInfo.getBuildDate();
                string2 = date != null ? dateFormat.format(date) : HelpMenu.this.uif.getI18NString("dt.aboutBadDate");
                String string3 = HelpMenu.this.uif.getI18NString("dt.aboutJavaTest", new Object[]{ProductInfo.getName(), ProductInfo.getVersion(), ProductInfo.getMilestone(), ProductInfo.getBuildNumber(), Harness.getClassDir().getPath(), ProductInfo.getBuildJavaVersion(), string2});
                HelpMenu.this.showAbout(jMenuItem.getText(), string3);
            } else if (string.equals(HelpMenu.ABOUT_JAVA)) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                String string4 = HelpMenu.this.uif.getI18NString("dt.aboutJava", new Object[]{System.getProperty("java.version"), System.getProperty("java.vendor"), System.getProperty("java.home"), System.getProperty("java.vendor.url")});
                HelpMenu.this.showAbout(jMenuItem.getText(), string4);
            } else if (string.equals(HelpMenu.HELP)) {
                HelpMenu.this.helpBroker.setCurrentID("jthelp.csh");
                HelpMenu.this.helpBroker.setDisplayed(true);
            }
        }
    }
}

