/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.UIFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EditableList
extends JComponent
implements Accessible {
    protected UIFactory uif = new UIFactory(class$com$sun$javatest$tool$EditableList == null ? (class$com$sun$javatest$tool$EditableList = EditableList.class$("com.sun.javatest.tool.EditableList")) : class$com$sun$javatest$tool$EditableList);
    protected DefaultListModel listModel;
    private JList list;
    private JButton addBtn;
    private JButton removeBtn;
    private JButton upBtn;
    private JButton downBtn;
    private Listener listener = new Listener();
    static /* synthetic */ Class class$javax$swing$event$ListDataListener;
    static /* synthetic */ Class class$com$sun$javatest$tool$EditableList;

    public EditableList() {
        this.setLayout(new BorderLayout());
        this.listModel = new DefaultListModel();
        this.listModel.addListDataListener(this.listener);
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(this.listener);
        this.add((Component)new JScrollPane(this.list), "Center");
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        this.addBtn = this.createButton("list.add");
        jToolBar.add(this.addBtn);
        this.removeBtn = this.createButton("list.remove");
        jToolBar.add(this.removeBtn);
        this.upBtn = this.createButton("list.up");
        jToolBar.add(this.upBtn);
        this.downBtn = this.createButton("list.down");
        jToolBar.add(this.downBtn);
        this.add((Component)jToolBar, "East");
        this.updateButtons();
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){};
        }
        return this.accessibleContext;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.list.setEnabled(bl);
        this.updateButtons();
    }

    public void setItems(Object[] objectArray) {
        this.listModel.clear();
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                this.listModel.addElement(objectArray[n]);
                ++n;
            }
        }
    }

    public void clear() {
        this.listModel.clear();
    }

    public Object[] getItems() {
        return this.listModel.toArray();
    }

    public Object[] getItems(Class clazz) {
        Object[] objectArray = (Object[])Array.newInstance(clazz, this.listModel.size());
        this.listModel.copyInto(objectArray);
        return objectArray;
    }

    public String getToolTipText() {
        return this.list.getToolTipText();
    }

    public void setToolTipText(String string) {
        this.list.setToolTipText(string);
    }

    public void addListDataListener(ListDataListener listDataListener) {
        this.listenerList.add(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = EditableList.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener, listDataListener);
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this.listenerList.remove(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = EditableList.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener, listDataListener);
    }

    protected Object getNewItem() {
        return JOptionPane.showInputDialog(this, (Object)this.uif.getI18NString("list.add.txt"));
    }

    private JButton createButton(String string) {
        JButton jButton = this.uif.createButton(string);
        jButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        jButton.addActionListener(this.listener);
        jButton.setMnemonic(this.uif.getI18NString(string + ".mne").charAt(0));
        return jButton;
    }

    private void updateButtons() {
        boolean bl = this.isEnabled();
        this.addBtn.setEnabled(bl);
        if (this.list.isSelectionEmpty() || !bl) {
            this.removeBtn.setEnabled(false);
            this.upBtn.setEnabled(false);
            this.downBtn.setEnabled(false);
        } else {
            this.removeBtn.setEnabled(true);
            int n = this.list.getSelectedIndex();
            this.upBtn.setEnabled(n > 0);
            this.downBtn.setEnabled(n + 1 < this.listModel.size());
        }
    }

    private void swap(int n, int n2) {
        Object e = this.listModel.elementAt(n);
        Object e2 = this.listModel.elementAt(n2);
        this.listModel.set(n, e2);
        this.listModel.set(n2, e);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Listener
    implements ActionListener,
    ListDataListener,
    ListSelectionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Object object = actionEvent.getSource();
            if (object == EditableList.this.addBtn) {
                Object object2 = EditableList.this.getNewItem();
                if (object2 != null) {
                    if (EditableList.this.list.isSelectionEmpty()) {
                        EditableList.this.listModel.addElement(object2);
                    } else {
                        EditableList.this.listModel.add(1 + EditableList.this.list.getSelectedIndex(), object2);
                    }
                }
            } else if (object == EditableList.this.removeBtn) {
                if (!EditableList.this.list.isSelectionEmpty()) {
                    EditableList.this.listModel.remove(EditableList.this.list.getSelectedIndex());
                }
            } else if (object == EditableList.this.upBtn) {
                int n2;
                if (!EditableList.this.list.isSelectionEmpty() && (n2 = EditableList.this.list.getSelectedIndex()) > 0) {
                    EditableList.this.swap(n2, n2 - 1);
                    EditableList.this.list.setSelectedIndex(n2 - 1);
                }
            } else if (object == EditableList.this.downBtn && !EditableList.this.list.isSelectionEmpty() && (n = EditableList.this.list.getSelectedIndex()) + 1 < EditableList.this.listModel.size()) {
                EditableList.this.swap(n, n + 1);
                EditableList.this.list.setSelectedIndex(n + 1);
            }
            EditableList.this.updateButtons();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            EditableList.this.updateButtons();
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            ListDataEvent listDataEvent2 = null;
            Object[] objectArray = EditableList.this.listenerList.getListenerList();
            int n = objectArray.length - 2;
            while (n >= 0) {
                if (objectArray[n] == (class$javax$swing$event$ListDataListener == null ? EditableList.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) {
                    if (listDataEvent2 == null) {
                        listDataEvent2 = new ListDataEvent(EditableList.this, listDataEvent.getType(), listDataEvent.getIndex0(), listDataEvent.getIndex1());
                    }
                    ((ListDataListener)objectArray[n + 1]).contentsChanged(listDataEvent2);
                }
                n -= 2;
            }
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            ListDataEvent listDataEvent2 = null;
            Object[] objectArray = EditableList.this.listenerList.getListenerList();
            int n = objectArray.length - 2;
            while (n >= 0) {
                if (objectArray[n] == (class$javax$swing$event$ListDataListener == null ? EditableList.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) {
                    if (listDataEvent2 == null) {
                        listDataEvent2 = new ListDataEvent(EditableList.this, listDataEvent.getType(), listDataEvent.getIndex0(), listDataEvent.getIndex1());
                    }
                    ((ListDataListener)objectArray[n + 1]).intervalAdded(listDataEvent2);
                }
                n -= 2;
            }
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            ListDataEvent listDataEvent2 = null;
            Object[] objectArray = EditableList.this.listenerList.getListenerList();
            int n = objectArray.length - 2;
            while (n >= 0) {
                if (objectArray[n] == (class$javax$swing$event$ListDataListener == null ? EditableList.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) {
                    if (listDataEvent2 == null) {
                        listDataEvent2 = new ListDataEvent(EditableList.this, listDataEvent.getType(), listDataEvent.getIndex0(), listDataEvent.getIndex1());
                    }
                    ((ListDataListener)objectArray[n + 1]).intervalRemoved(listDataEvent2);
                }
                n -= 2;
            }
        }
    }
}

