/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.EditableList;
import java.io.File;
import javax.swing.JFileChooser;

public class EditableFileList
extends EditableList {
    private JFileChooser chooser;
    private File baseDir;

    public EditableFileList() {
    }

    public EditableFileList(JFileChooser jFileChooser) {
        this.setChooser(jFileChooser);
    }

    public void setBaseDirectory(File file) {
        this.baseDir = file;
        if (this.chooser != null) {
            if (file == null) {
                file = new File(System.getProperty("user.dir"));
            }
            this.chooser.setCurrentDirectory(file);
        }
    }

    public void setChooser(JFileChooser jFileChooser) {
        if (jFileChooser == null) {
            throw new NullPointerException();
        }
        this.chooser = jFileChooser;
    }

    public void setItems(Object[] objectArray) {
        this.listModel.clear();
        if (objectArray == null) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object instanceof File) {
                this.listModel.addElement(object);
            } else if (object instanceof String) {
                this.listModel.addElement(new File((String)object));
            } else {
                throw new IllegalArgumentException(object.toString());
            }
            ++n;
        }
    }

    public File[] getFiles() {
        Object[] objectArray = new File[this.listModel.size()];
        this.listModel.copyInto(objectArray);
        return objectArray;
    }

    public void setFiles(File[] fileArray) {
        this.setItems(fileArray);
    }

    protected Object getNewItem() {
        int n;
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
        }
        if ((n = this.chooser.showDialog(this, this.uif.getI18NString("list.add.select.txt"))) != 0) {
            return null;
        }
        File file = this.chooser.getSelectedFile();
        if (this.baseDir != null) {
            String string = this.baseDir.getPath();
            if (file.getPath().startsWith(string + File.separatorChar)) {
                file = new File(file.getPath().substring(string.length() + 1));
            }
        }
        return file;
    }
}

