/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.UIFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

class DesktopPrefsPane
extends Preferences.Pane {
    private UIFactory uif;
    private ButtonGroup styleGrp;
    private JCheckBox ttipsCheck;
    private JComboBox ttDelay;
    private JComboBox ttDuration;
    private JCheckBox saveCheck;
    private Integer[] tooltipDurations;
    private Integer[] tooltipDelays;
    private static String TIP_SHOW_FOREVER;

    DesktopPrefsPane(UIFactory uIFactory) {
        this.uif = uIFactory;
        this.setHelp("ui.prefs.appearance.csh");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.bottom = 10;
        this.add(this.createDesktopStylePanel(), gridBagConstraints);
        this.add(this.createToolTipsPanel(), gridBagConstraints);
        this.add(this.createShutdownPanel(), gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add(Box.createVerticalGlue(), gridBagConstraints);
    }

    public String getText() {
        return this.uif.getI18NString("dt.prefs.name");
    }

    public void load(Map map) {
        int n;
        Object object;
        String string = (String)map.get("tool.appearance.style");
        if (string == null) {
            string = Desktop.styleNames[Desktop.access().getStyle()];
        }
        Enumeration<AbstractButton> enumeration = this.styleGrp.getElements();
        while (enumeration.hasMoreElements()) {
            object = (JRadioButton)enumeration.nextElement();
            if (!((AbstractButton)object).getActionCommand().equals(string)) continue;
            ((AbstractButton)object).setSelected(true);
            break;
        }
        object = (String)map.get("tool.appearance.ttipToggle");
        this.ttipsCheck.setSelected(object == null || ((String)object).equalsIgnoreCase("true"));
        boolean bl = false;
        String string2 = (String)map.get("tool.appearance.ttipDelay");
        try {
            int n2 = Integer.parseInt(string2);
            if (n2 == 0) {
                this.ttDelay.setSelectedItem(this.tooltipDelays[0]);
                bl = true;
            } else {
                n = 1;
                while (n < this.ttDelay.getItemCount()) {
                    if ((Integer)this.ttDelay.getItemAt(n) == n2) {
                        this.ttDelay.setSelectedIndex(n);
                        n = this.ttDelay.getItemCount();
                        bl = true;
                    }
                    ++n;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        if (!bl) {
            this.ttDelay.setSelectedIndex(1);
        }
        bl = false;
        String string3 = (String)map.get("tool.appearance.ttipDuration");
        try {
            n = Integer.parseInt(string3);
            if (n == -1) {
                this.ttDuration.setSelectedItem(this.tooltipDurations[0]);
                bl = true;
            } else {
                int n3 = 1;
                while (n3 < this.tooltipDurations.length) {
                    if (n == this.tooltipDurations[n3]) {
                        this.ttDuration.setSelectedItem(this.tooltipDurations[n3]);
                        bl = true;
                        n3 = this.tooltipDurations.length;
                    }
                    ++n3;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        if (!bl) {
            this.ttDuration.setSelectedItem(this.tooltipDurations[1]);
        }
        this.syncTooltipPrefs();
        String string4 = (String)map.get("tool.appearance.saveOnExit");
        this.saveCheck.setSelected(string4 == null || string4.equalsIgnoreCase("true"));
    }

    public void save(Map map) {
        int n;
        ButtonModel buttonModel = this.styleGrp.getSelection();
        if (buttonModel != null) {
            String string = buttonModel.getActionCommand();
            n = 0;
            while (n < Desktop.styleNames.length) {
                if (string.equals(Desktop.styleNames[n])) {
                    Desktop.access().setStyle(n);
                    map.put("tool.appearance.style", string);
                    break;
                }
                ++n;
            }
        }
        boolean bl = this.ttipsCheck.isSelected();
        map.put("tool.appearance.ttipToggle", String.valueOf(bl));
        Desktop.access().setTooltipsEnabled(bl);
        n = this.getTooltipDelay();
        map.put("tool.appearance.ttipDelay", Integer.toString(n));
        Desktop.access().setTooltipDelay(n);
        int n2 = this.getTooltipDuration();
        map.put("tool.appearance.ttipDuration", Integer.toString(n2));
        Desktop.access().setTooltipDuration(n2);
        map.put("tool.appearance.saveOnExit", String.valueOf(this.saveCheck.isSelected()));
        Desktop.access().setSaveOnExit(this.saveCheck.isSelected());
        this.syncTooltipPrefs();
    }

    private void syncTooltipPrefs() {
        boolean bl = this.ttipsCheck.isSelected();
        Desktop.access().setTooltipsEnabled(bl);
        int n = this.getTooltipDelay();
        Desktop.access().setTooltipDelay(n);
        int n2 = this.getTooltipDuration();
        Desktop.access().setTooltipDuration(n2);
    }

    private Component createDesktopStylePanel() {
        Box box = Box.createHorizontalBox();
        box.setBorder(this.uif.createTitledBorder("dt.prefs.style"));
        this.styleGrp = new ButtonGroup();
        int n = 0;
        while (n < Desktop.styleNames.length) {
            String string = Desktop.styleNames[n];
            String string2 = "dt.prefs." + string;
            JRadioButton jRadioButton = this.uif.createRadioButton(string2, this.styleGrp);
            jRadioButton.setActionCommand(string);
            box.add(jRadioButton);
            ++n;
        }
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private Component createShutdownPanel() {
        Box box = Box.createHorizontalBox();
        box.setBorder(this.uif.createTitledBorder("dt.prefs.shutdown"));
        this.saveCheck = this.uif.createCheckBox("dt.prefs.saveOnExit");
        box.add(this.saveCheck);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private Component createToolTipsPanel() {
        JPanel jPanel = this.uif.createPanel("dt.prefs.tt", false);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets.left = 3;
        gridBagConstraints.insets.right = 3;
        gridBagConstraints.insets.top = 2;
        gridBagConstraints.insets.bottom = 2;
        jPanel.setBorder(this.uif.createTitledBorder("dt.prefs.ttips"));
        this.ttipsCheck = this.uif.createCheckBox("dt.prefs.ttips");
        this.uif.setAccessibleName(this.ttipsCheck, "dt.prefs.ttips");
        this.ttipsCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = DesktopPrefsPane.this.ttipsCheck.isSelected();
                DesktopPrefsPane.this.ttDelay.setEnabled(bl);
                DesktopPrefsPane.this.ttDuration.setEnabled(bl);
            }
        });
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.ttipsCheck, gridBagConstraints);
        this.loadTooltipResources();
        JLabel jLabel = this.uif.createLabel("dt.prefs.ttDelay", true);
        this.ttDelay = this.uif.createChoice("dt.prefs.ttDelay", jLabel);
        int n = 0;
        while (n < this.tooltipDelays.length) {
            this.ttDelay.addItem(this.tooltipDelays[n]);
            ++n;
        }
        this.ttDelay.setSelectedItem(this.tooltipDelays[0]);
        this.ttDelay.setRenderer(new TipDelayRenderer());
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.ttDelay, gridBagConstraints);
        jLabel = this.uif.createLabel("dt.prefs.ttDuration", true);
        this.ttDuration = this.uif.createChoice("dt.prefs.ttDuration", jLabel);
        int n2 = 0;
        while (n2 < this.tooltipDurations.length) {
            this.ttDuration.addItem(this.tooltipDurations[n2]);
            ++n2;
        }
        this.ttDuration.setRenderer(new TipDurationRenderer());
        this.ttDuration.setSelectedItem(this.tooltipDurations[Math.max(this.tooltipDurations.length - 2, 0)]);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.ttDuration, gridBagConstraints);
        return jPanel;
    }

    private void loadTooltipResources() {
        this.tooltipDurations = new Integer[]{new Integer(1000), new Integer(2000), new Integer(3000), new Integer(5000), new Integer(10000), new Integer(15000), new Integer(-1)};
        this.tooltipDelays = new Integer[]{new Integer(0), new Integer(1000), new Integer(2000), new Integer(3000), new Integer(5000), new Integer(10000)};
    }

    private int getTooltipDelay() {
        Integer n = (Integer)this.ttDelay.getSelectedItem();
        return n;
    }

    private int getTooltipDuration() {
        int n = (Integer)this.ttDuration.getSelectedItem();
        return n < 0 ? -1 : n;
    }

    private class TipDurationRenderer
    extends BasicComboBoxRenderer {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TipDurationRenderer() {
            DesktopPrefsPane desktopPrefsPane2 = DesktopPrefsPane.this;
            synchronized (desktopPrefsPane2) {
                if (TIP_SHOW_FOREVER == null) {
                    TIP_SHOW_FOREVER = DesktopPrefsPane.this.uif.getI18NString("dt.prefs.ttDuration.forev");
                }
            }
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            int n2;
            Object object2 = object instanceof Integer ? ((n2 = ((Integer)object).intValue()) > 0 ? DesktopPrefsPane.this.uif.getI18NString("dt.prefs.ttDuration.sec", new Integer(n2 / 1000)) : TIP_SHOW_FOREVER) : object;
            return super.getListCellRendererComponent((JList<?>)jList, object2, n, bl, bl2);
        }
    }

    private class TipDelayRenderer
    extends BasicComboBoxRenderer {
        private TipDelayRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2;
            if (object instanceof Integer) {
                int n2 = (Integer)object;
                object2 = DesktopPrefsPane.this.uif.getI18NString("dt.prefs.ttDelay", new Integer(n2 / 1000));
            } else {
                object2 = object;
            }
            return super.getListCellRendererComponent((JList<?>)jList, object2, n, bl, bl2);
        }
    }
}

