/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.DesktopPrefsPane;
import com.sun.javatest.tool.FileOpener;
import com.sun.javatest.tool.FocusMonitor;
import com.sun.javatest.tool.HelpMenu;
import com.sun.javatest.tool.MDIDesktop;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.SDIDesktop;
import com.sun.javatest.tool.TabDesktop;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.ToolManager;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.ExitCount;
import com.sun.javatest.util.PrefixMap;
import com.sun.javatest.util.StringArray;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public abstract class Desktop {
    private static Desktop theOne;
    public static final int TAB_STYLE = 0;
    public static final int MDI_STYLE = 1;
    public static final int SDI_STYLE = 2;
    static final int NUM_STYLES = 3;
    static final String[] styleNames;
    private static final int MENU_INSERT_POINT = 3;
    private static Collection allFrames;
    private static boolean firstTime;
    protected static final UIFactory uif;
    private Preferences preferences;
    private Dimension preferredSize;
    private Preferences.Pane prefsPane;
    private HelpBroker helpBroker;
    private boolean saveOnExit;
    private Window splash;
    private JDialog confirmDialog;
    private static int frameIndex;
    private static LinkedList fileHistory;
    private static final int FILE_HISTORY_MAX_SIZE = 10;
    static final String STYLE_PREF = "tool.appearance.style";
    static final String TTIP_PREF = "tool.appearance.ttipToggle";
    static final String TTIP_DELAY = "tool.appearance.ttipDelay";
    static final String TTIP_DURATION = "tool.appearance.ttipDuration";
    static final int TTIP_DURATION_FOREVER = -1;
    static final int TTIP_DELAY_NONE = 0;
    static final int TTIP_DELAY_DEFAULT = 0;
    static final int TTIP_DURATION_DEFAULT = 5000;
    static final String SAVE_ON_EXIT_PREF = "tool.appearance.saveOnExit";
    static final String CLOSE = "close";
    private static final String EXIT = "exit";
    private static final String PREFS = "prefs";
    private static final String HISTORY = "history";
    private static final String SEPARATOR;
    private static final String defaultToolManager;
    private static FocusMonitor focusMonitor;
    static /* synthetic */ Class class$javax$swing$event$MenuListener;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$com$sun$javatest$tool$Desktop;
    static /* synthetic */ Class class$javax$swing$JFrame;

    public static synchronized Desktop access() {
        return Desktop.access(true);
    }

    public static synchronized Desktop access(boolean bl) {
        if (theOne == null && bl) {
            int n = 0;
            Preferences preferences = Preferences.access();
            String string = preferences.getPreference(STYLE_PREF);
            int n2 = 0;
            while (n2 < styleNames.length) {
                if (styleNames[n2].equals(string)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            theOne = Desktop.create(n);
        }
        return theOne;
    }

    private static Desktop create(int n) {
        switch (n) {
            case 1: {
                return new MDIDesktop();
            }
            case 2: {
                return new SDIDesktop();
            }
        }
        return new TabDesktop();
    }

    protected Desktop() {
        block2: {
            this.preferences = Preferences.access();
            String string = this.preferences.getPreference(TTIP_PREF);
            boolean bl = string == null || string.equalsIgnoreCase("true");
            this.setTooltipsEnabled(bl);
            int n = Desktop.getTooltipDelay(this.preferences);
            this.setTooltipDelay(n);
            int n2 = Desktop.getTooltipDuration(this.preferences);
            this.setTooltipDuration(n2);
            String string2 = this.preferences.getPreference(SAVE_ON_EXIT_PREF);
            this.setSaveOnExit(string2 == null || string2.equalsIgnoreCase("true"));
            URL uRL = HelpSet.findHelpSet(null, "com/sun/javatest/help/jthelp.hs");
            if (uRL == null) break block2;
            try {
                HelpSet helpSet = new HelpSet(null, uRL);
                this.helpBroker = helpSet.createHelpBroker();
            }
            catch (HelpSetException helpSetException) {}
        }
    }

    protected Desktop(Desktop desktop) {
        this.preferences = desktop.preferences;
        this.prefsPane = desktop.prefsPane;
        this.helpBroker = desktop.helpBroker;
        this.saveOnExit = desktop.saveOnExit;
    }

    public static void start() {
        Desktop.start(new ToolManager[0], null);
    }

    public static void start(ToolManager[] toolManagerArray) {
        Desktop.start(toolManagerArray, null);
    }

    public static void start(final ToolManager[] toolManagerArray, final Window window) {
        if (!EventQueue.isDispatchThread()) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        Desktop.start(toolManagerArray, window);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw (Error)throwable;
            }
            return;
        }
        int n = 0;
        while (n < toolManagerArray.length) {
            try {
                toolManagerArray[n].setup(2);
            }
            catch (ToolManager.Fault fault) {
                uif.showError("dt.startTool", fault.getMessage());
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < toolManagerArray.length) {
            try {
                toolManagerArray[n2].cleanup();
            }
            catch (ToolManager.Fault fault) {
                uif.showError("dt.startTool", fault.getMessage());
            }
            ++n2;
        }
        Desktop desktop = Desktop.access();
        if (desktop.getTools().length == 0) {
            try {
                desktop.addDefaultTool();
            }
            catch (ToolManager.Fault fault) {
                uif.showError("dt.startDefaultTool", fault.getMessage());
            }
        }
        desktop.setVisible(true);
    }

    public static void restore() {
        Desktop.restore(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restore(final Window window) {
        Object object;
        if (!EventQueue.isDispatchThread()) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        Desktop.restore(window);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw (Error)throwable;
            }
            return;
        }
        Properties properties = new Properties();
        File file = Desktop.getDesktopFile();
        if (file != null && file.exists()) {
            try {
                object = new BufferedInputStream(new FileInputStream(file));
                properties.load((InputStream)object);
                ((InputStream)object).close();
            }
            catch (IOException iOException) {
                System.err.println("Error reading desktop file: " + iOException);
            }
        }
        if ((object = properties.getProperty("dt.class")) != null) {
            try {
                if (theOne != null) {
                    theOne.dispose();
                }
                theOne = (Desktop)Class.forName((String)object).newInstance();
            }
            catch (Throwable throwable) {
                System.err.println("Error loading saved desktop class: " + throwable);
            }
        }
        Desktop desktop = Desktop.access();
        try {
            Tool[] toolArray;
            desktop.splash = window;
            desktop.restoreDesktop(properties);
            if (desktop.getTools().length == 0) {
                try {
                    desktop.addDefaultTool();
                }
                catch (ToolManager.Fault fault) {
                    uif.showError("dt.startDefaultTool", fault.getMessage());
                }
            }
            desktop.setVisible(true);
            Tool tool = desktop.getSelectedTool();
            if (tool == null && (toolArray = desktop.getTools()).length > 0) {
                tool = toolArray[0];
            }
            if (tool != null) {
                desktop.setSelectedTool(tool);
            }
            Object var8_13 = null;
            desktop.splash = null;
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            desktop.splash = null;
            throw throwable;
        }
    }

    public void save() {
        block3: {
            File file = Desktop.getDesktopFile();
            if (file == null) break block3;
            Properties properties = new Properties();
            this.saveDesktop(properties);
            try {
                File file2 = new File(file.getParent());
                if (!file2.exists()) {
                    file2.mkdirs();
                }
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                properties.store(bufferedOutputStream, "JavaTest Desktop");
                ((OutputStream)bufferedOutputStream).close();
            }
            catch (IOException iOException) {
                System.err.println("Error writing desktop file: " + iOException);
            }
        }
    }

    public boolean getSaveOnExit() {
        return this.saveOnExit;
    }

    public void setSaveOnExit(boolean bl) {
        this.saveOnExit = bl;
    }

    public void dispose() {
        Tool[] toolArray = this.getTools();
        int n = 0;
        while (n < toolArray.length) {
            toolArray[n].dispose();
            ++n;
        }
        if (this == theOne) {
            theOne = null;
            if (this.helpBroker != null && this.helpBroker.isDisplayed()) {
                this.helpBroker.setDisplayed(false);
            }
        }
    }

    public abstract boolean isVisible();

    public abstract void setVisible(boolean var1);

    public abstract Tool[] getTools();

    public abstract void addTool(Tool var1);

    public void addDefaultTool() throws ToolManager.Fault {
        ToolManager[] toolManagerArray = ToolManager.getAllManagers();
        int n = 0;
        while (n < toolManagerArray.length) {
            if (toolManagerArray[n].getClass().getName().equals(defaultToolManager)) {
                toolManagerArray[n].setup(2);
                return;
            }
            ++n;
        }
    }

    public boolean containsTool(Tool tool) {
        Tool[] toolArray = this.getTools();
        int n = 0;
        while (n < toolArray.length) {
            if (tool == toolArray[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public abstract void removeTool(Tool var1);

    public abstract Tool getSelectedTool();

    public abstract void setSelectedTool(Tool var1);

    public abstract int getStyle();

    public Desktop setStyle(int n) {
        if (this.getStyle() == n) {
            return this;
        }
        Desktop desktop = theOne;
        switch (n) {
            case 1: {
                theOne = new MDIDesktop(theOne);
                break;
            }
            case 2: {
                theOne = new SDIDesktop(theOne);
                break;
            }
            case 0: {
                theOne = new TabDesktop(theOne);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        desktop.dispose();
        return theOne;
    }

    public abstract JFrame[] getFrames();

    public Component getDialogParent() {
        JFrame[] jFrameArray = this.getFrames();
        if (jFrameArray == null || jFrameArray.length == 0) {
            return null;
        }
        return jFrameArray[0].getContentPane();
    }

    public abstract Rectangle getBounds();

    public static Rectangle getDefaultBounds() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = Math.min(dimension.width, Math.max(640, dimension.width * 3 / 4));
        int n2 = Math.min(dimension.height, Math.max(480, dimension.height * 3 / 4));
        int n3 = dimension.width / 2 - n / 2;
        int n4 = dimension.height / 2 - n2 / 2;
        return new Rectangle(n3, n4, n, n2);
    }

    public static void addToFileHistory(File file, FileOpener fileOpener) {
        Iterator iterator = fileHistory.iterator();
        while (iterator.hasNext()) {
            FileHistoryEntry fileHistoryEntry = (FileHistoryEntry)iterator.next();
            if (fileHistoryEntry.fileOpener != fileOpener || !fileHistoryEntry.file.equals(file)) continue;
            iterator.remove();
            break;
        }
        fileHistory.addFirst(new FileHistoryEntry(fileOpener, file));
        while (fileHistory.size() > 10) {
            fileHistory.removeLast();
        }
    }

    public HelpBroker getHelpBroker() {
        return this.helpBroker;
    }

    public Icon getLogo() {
        return uif.createIcon("dt.logo");
    }

    public static boolean isFirstTime() {
        return firstTime;
    }

    static void setFirstTime(boolean bl) {
        firstTime = bl;
    }

    protected JFrame createFrame(MenuListener menuListener, String string) {
        return this.createFrame(menuListener, null, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JFrame createFrame(MenuListener menuListener, Action action, String string) {
        Object object;
        JFrame jFrame = new JFrame();
        jFrame.setName(string + frameIndex++);
        jFrame.setTitle(uif.getI18NString("dt.title.txt"));
        jFrame.setIconImage(uif.createImage("images/jticon.gif"));
        uif.setAccessibleInfo(jFrame, string);
        JRootPane jRootPane = jFrame.getRootPane();
        jRootPane.setName("root");
        uif.setAccessibleInfo(jRootPane, string);
        JMenuBar jMenuBar = uif.createMenuBar("dt.menuBar");
        JMenu jMenu = uif.createMenu("dt.file");
        jMenu.addMenuListener(new FileMenuListener(action));
        jMenuBar.add(jMenu);
        JMenu jMenu2 = uif.createMenu("dt.tasks");
        ToolManager[] toolManagerArray = ToolManager.getAllManagers();
        int n = 0;
        while (n < toolManagerArray.length) {
            object = toolManagerArray[n].getTaskMenuActions();
            if (object != null) {
                int n2 = 0;
                while (n2 < ((Object)object).length) {
                    jMenu2.add((Action)object[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        jMenuBar.add(jMenu2);
        object = uif.createMenu("dt.windows");
        ((JMenu)object).addMenuListener(menuListener);
        jMenuBar.add((JMenu)object);
        jMenuBar.add(uif.createHorizontalGlue("dt.pad"));
        HelpMenu helpMenu = new HelpMenu(jFrame, this.helpBroker, uif);
        jMenuBar.add(helpMenu);
        jFrame.setJMenuBar(jMenuBar);
        if (this.helpBroker != null) {
            this.helpBroker.enableHelpKey(jFrame.getRootPane(), "jthelp.csh", null);
            Desktop.addHelpDebugListener(jFrame);
        }
        Desktop.addPreferredSizeDebugListener(jFrame);
        if (focusMonitor != null) {
            focusMonitor.monitor(jFrame);
        }
        jFrame.setDefaultCloseOperation(0);
        jFrame.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void windowClosed(WindowEvent windowEvent) {
                JFrame jFrame = (JFrame)windowEvent.getSource();
                Collection collection = allFrames;
                synchronized (collection) {
                    if (allFrames.remove(jFrame) && allFrames.isEmpty()) {
                        EventQueue.invokeLater(new Runnable(this){
                            private final /* synthetic */ 3 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                ExitCount.dec();
                            }
                        });
                    }
                }
            }
        });
        Collection collection = allFrames;
        synchronized (collection) {
            allFrames.add(jFrame);
            if (allFrames.size() == 1) {
                ExitCount.inc();
            }
        }
        return jFrame;
    }

    protected void addToolMenuItemsToFrameMenuBar(JFrame jFrame, Tool tool) {
        JMenuBar jMenuBar;
        JMenuBar jMenuBar2 = jFrame.getJMenuBar();
        Tool tool2 = (Tool)jMenuBar2.getClientProperty(this.getClass());
        if (tool == tool2) {
            return;
        }
        if (tool2 != null) {
            this.removeToolMenuItemsFromFrameMenuBar(jFrame, tool2);
        }
        if ((jMenuBar = tool.getMenuBar()) == null) {
            return;
        }
        int n = 0;
        while (n < jMenuBar.getMenuCount()) {
            JMenu jMenu = jMenuBar.getMenu(n);
            if (jMenu != null) {
                int n2 = jMenu.getMenuComponentCount();
                JMenu jMenu2 = this.findMenu(jMenuBar2, jMenu.getText());
                if (jMenu2 == null) {
                    jMenu2 = new JMenu(jMenu.getText());
                    jMenu2.setName(jMenu.getName());
                    jMenu2.setMnemonic(jMenu.getMnemonic());
                    AccessibleContext accessibleContext = jMenu2.getAccessibleContext();
                    AccessibleContext accessibleContext2 = jMenu.getAccessibleContext();
                    accessibleContext.setAccessibleName(accessibleContext2.getAccessibleName());
                    accessibleContext.setAccessibleDescription(accessibleContext2.getAccessibleDescription());
                    this.copyMenuListeners(jMenu, jMenu2);
                    int n3 = 0;
                    while (n3 < n2) {
                        jMenu2.add(jMenu.getMenuComponent(0));
                        ++n3;
                    }
                    jMenuBar2.add((Component)jMenu2, jMenuBar2.getMenuCount() - 3);
                } else {
                    int n4 = 0;
                    while (n4 < n2) {
                        jMenu2.add(jMenu.getMenuComponent(0), n4);
                        ++n4;
                    }
                    jMenu2.insertSeparator(n2);
                }
                jMenu2.putClientProperty(this.getClass(), new Integer(n2));
            }
            ++n;
        }
        jMenuBar2.putClientProperty(this.getClass(), tool);
    }

    private void removeToolMenuItemsFromFrameMenuBar(JFrame jFrame) {
        JMenuBar jMenuBar = jFrame.getJMenuBar();
        Tool tool = (Tool)jMenuBar.getClientProperty(this.getClass());
        if (tool == null) {
            return;
        }
        this.removeToolMenuItemsFromFrameMenuBar(jFrame, tool);
    }

    protected void removeToolMenuItemsFromFrameMenuBar(JFrame jFrame, Tool tool) {
        JMenuBar jMenuBar = jFrame.getJMenuBar();
        JMenuBar jMenuBar2 = tool.getMenuBar();
        int n = 0;
        while (n < jMenuBar2.getMenuCount()) {
            JMenu jMenu = jMenuBar2.getMenu(n);
            if (jMenu != null) {
                JMenu jMenu2 = this.findMenu(jMenuBar, jMenu.getText());
                int n2 = (Integer)jMenu2.getClientProperty(this.getClass());
                int n3 = 0;
                while (n3 < n2) {
                    jMenu.add(jMenu2.getMenuComponent(0));
                    ++n3;
                }
                if (jMenu2.getItemCount() == 0) {
                    jMenuBar.remove(jMenu2);
                } else {
                    jMenu2.remove(0);
                    jMenu2.putClientProperty(this.getClass(), null);
                }
            }
            ++n;
        }
        jMenuBar.putClientProperty(this.getClass(), null);
    }

    private void copyMenuListeners(JMenu jMenu, JMenu jMenu2) {
        MenuListener[] menuListenerArray = (MenuListener[])jMenu.getListeners(class$javax$swing$event$MenuListener == null ? (class$javax$swing$event$MenuListener = Desktop.class$("javax.swing.event.MenuListener")) : class$javax$swing$event$MenuListener);
        int n = 0;
        while (n < menuListenerArray.length) {
            jMenu2.addMenuListener(menuListenerArray[n]);
            ++n;
        }
    }

    private JMenu findMenu(JMenuBar jMenuBar, String string) {
        int n = 0;
        while (n < jMenuBar.getMenuCount()) {
            JMenu jMenu = jMenuBar.getMenu(n);
            if (jMenu != null && jMenu.getText().equals(string)) {
                return jMenu;
            }
            ++n;
        }
        return null;
    }

    public abstract Container createDialog(Tool var1, String var2, String var3, JMenuBar var4, Container var5, Rectangle var6);

    public abstract boolean isToolOwnerForDialog(Tool var1, Container var2);

    protected void checkToolsAndExitIfOK(JFrame jFrame) {
        if (this.isOKToExit(jFrame)) {
            this.save();
            this.dispose();
        }
    }

    protected boolean isOKToClose(Tool tool, JFrame jFrame) {
        if (this.confirmDialog != null) {
            Toolkit.getDefaultToolkit().beep();
            this.confirmDialog.toFront();
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = tool.getCloseAlerts();
        this.appendStrings(stringBuffer, stringArray);
        if (stringBuffer.length() > 0) {
            JTextArea jTextArea = uif.createMessageArea("dt.close.confirm", stringBuffer.toString());
            String string = uif.getI18NString("dt.close.confirm.title");
            JOptionPane jOptionPane = new JOptionPane(jTextArea, 2, 0);
            this.confirmDialog = jOptionPane.createDialog(jFrame, string);
            this.confirmDialog.setVisible(true);
            this.confirmDialog.dispose();
            this.confirmDialog = null;
            int n = (Integer)jOptionPane.getValue();
            if (n != 0) {
                return false;
            }
        }
        return true;
    }

    protected boolean isOKToExit(JFrame jFrame) {
        Object object;
        if (this.confirmDialog != null) {
            Toolkit.getDefaultToolkit().beep();
            this.confirmDialog.toFront();
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Tool[] toolArray = this.getTools();
        int n = 0;
        while (n < toolArray.length) {
            object = toolArray[n].getCloseAlerts();
            this.appendStrings(stringBuffer, (String[])object);
            ++n;
        }
        if (stringBuffer.length() > 0) {
            object = uif.createMessageArea("dt.exit.confirm", stringBuffer.toString());
            String string = uif.getI18NString("dt.exit.confirm.title");
            JOptionPane jOptionPane = new JOptionPane(object, 2, 0);
            this.confirmDialog = jOptionPane.createDialog(jFrame, string);
            this.confirmDialog.setVisible(true);
            this.confirmDialog.dispose();
            this.confirmDialog = null;
            int n2 = (Integer)jOptionPane.getValue();
            if (n2 != 0) {
                return false;
            }
        }
        return true;
    }

    private void appendStrings(StringBuffer stringBuffer, String[] stringArray) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(stringArray[n]);
                if (!stringArray[n].endsWith("\n")) {
                    stringBuffer.append('\n');
                }
                ++n;
            }
        }
    }

    private void doPrefs(JFrame jFrame) {
        Object object;
        if (this.prefsPane == null) {
            this.prefsPane = new DesktopPrefsPane(uif);
        }
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(this.prefsPane);
        ToolManager[] toolManagerArray = ToolManager.getAllManagers();
        int n = 0;
        while (n < toolManagerArray.length) {
            object = toolManagerArray[n].getPrefsPane();
            if (object != null) {
                vector.addElement(object);
            }
            ++n;
        }
        object = new Preferences.Pane[vector.size()];
        vector.copyInto((Object[])object);
        this.preferences.showDialog(jFrame, (Preferences.Pane[])object, this.helpBroker);
    }

    protected void saveDesktop(Map map) {
        Tool[] toolArray = this.getTools();
        map.put("dt.class", this.getClass().getName());
        map.put("file.count", String.valueOf(fileHistory.size()));
        int n = 0;
        Iterator iterator = fileHistory.iterator();
        while (iterator.hasNext()) {
            FileHistoryEntry fileHistoryEntry = (FileHistoryEntry)iterator.next();
            map.put("fileHistory." + n + ".type", fileHistoryEntry.fileOpener.getFileType());
            map.put("fileHistory." + n + ".path", fileHistoryEntry.file.getPath());
        }
        map.put("tool.count", String.valueOf(toolArray.length));
        int n2 = 0;
        while (n2 < toolArray.length) {
            this.saveTool(new PrefixMap(map, "tool." + String.valueOf(n2)), toolArray[n2]);
            ++n2;
        }
    }

    protected void saveTool(Map map, Tool tool) {
        map.put("class", tool.getClass().getName());
        map.put("selected", String.valueOf(tool == this.getSelectedTool()));
        tool.save(map);
    }

    protected void restoreDesktop(Map map) {
        block15: {
            int n;
            Object object;
            block14: {
                HashMap<String, FileOpener> hashMap = new HashMap<String, FileOpener>();
                ToolManager[] toolManagerArray = ToolManager.getAllManagers();
                int n2 = 0;
                while (n2 < toolManagerArray.length) {
                    object = toolManagerArray[n2].getFileOpeners();
                    if (object != null) {
                        n = 0;
                        while (n < ((FileOpener[])object).length) {
                            FileOpener fileOpener = object[n];
                            hashMap.put(fileOpener.getFileType(), fileOpener);
                            ++n;
                        }
                    }
                    ++n2;
                }
                try {
                    fileHistory.clear();
                    object = (String)map.get("file.count");
                    if (object == null) break block14;
                    n = Integer.parseInt((String)object);
                    int n3 = 0;
                    while (n3 < n) {
                        try {
                            String string;
                            String string2 = (String)map.get("fileHistory." + n3 + ".type");
                            FileOpener fileOpener = (FileOpener)hashMap.get(string2);
                            if (fileOpener != null && (string = (String)map.get("fileHistory." + n3 + ".path")) != null && string.length() > 0) {
                                fileHistory.add(new FileHistoryEntry(fileOpener, new File(string)));
                            }
                        }
                        catch (Throwable throwable) {
                            System.err.println("Error loading saved file: " + throwable);
                            throwable.printStackTrace();
                        }
                        ++n3;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            try {
                object = (String)map.get("tool.count");
                if (object == null) break block15;
                n = Integer.parseInt((String)object);
                int n4 = 0;
                while (n4 < n) {
                    try {
                        this.restoreTool(new PrefixMap(map, "tool." + n4));
                    }
                    catch (Throwable throwable) {
                        System.err.println("Error loading saved tool: " + throwable);
                        throwable.printStackTrace();
                    }
                    ++n4;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    protected Tool restoreTool(Map map) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class[] classArray = new Class[]{class$java$util$Map == null ? (class$java$util$Map = Desktop.class$("java.util.Map")) : class$java$util$Map};
        String string = (String)map.get("class");
        Class<?> clazz = Class.forName(string);
        Method method = clazz.getDeclaredMethod("restore", classArray);
        Tool tool = (Tool)method.invoke(null, map);
        this.addTool(tool);
        boolean bl = "true".equals(map.get("selected"));
        if (bl) {
            this.setSelectedTool(tool);
        }
        return tool;
    }

    static int getTooltipDelay(Preferences preferences) {
        String string = preferences.getPreference(TTIP_DELAY);
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    static int getTooltipDuration(Preferences preferences) {
        String string = preferences.getPreference(TTIP_DURATION);
        int n = 5000;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 5000;
        }
        if (n < 0) {
            n = n == -1 ? Integer.MAX_VALUE : 5000;
        }
        return n;
    }

    void setTooltipsEnabled(boolean bl) {
        ToolTipManager.sharedInstance().setEnabled(bl);
    }

    void setTooltipDelay(int n) {
        ToolTipManager.sharedInstance().setInitialDelay(n);
    }

    void setTooltipDuration(int n) {
        if (n == -1) {
            ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        } else {
            ToolTipManager.sharedInstance().setDismissDelay(n);
        }
    }

    protected static void saveBounds(Component component, Map map) {
        Rectangle rectangle = component.getBounds();
        map.put("x", String.valueOf(rectangle.x));
        map.put("y", String.valueOf(rectangle.y));
        map.put("w", String.valueOf(rectangle.width));
        map.put("h", String.valueOf(rectangle.height));
    }

    protected static void restoreBounds(Component component, Map map) {
        try {
            String string = (String)map.get("x");
            String string2 = (String)map.get("y");
            String string3 = (String)map.get("w");
            String string4 = (String)map.get("h");
            if (string != null && string2 != null && string3 != null && string4 != null) {
                component.setBounds(Integer.parseInt(string), Integer.parseInt(string2), Integer.parseInt(string3), Integer.parseInt(string4));
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    static void addHelpDebugListener(Component component) {
        JRootPane jRootPane;
        if (component instanceof JFrame) {
            jRootPane = ((JFrame)component).getRootPane();
        } else if (component instanceof JDialog) {
            jRootPane = ((JDialog)component).getRootPane();
        } else {
            throw new IllegalArgumentException();
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Component component = (Component)actionEvent.getSource();
                Component component2 = SwingUtilities.findFocusOwner(component);
                System.err.println("ALT-F2: source=" + component);
                System.err.println("ALT-F2:  focus=" + component2);
                System.err.println("ALT-F2: helpId=" + (component2 == null ? "(none)" : CSH.getHelpIDString(component2)));
            }
        };
        jRootPane.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke("alt F2"), 2);
    }

    static void addPreferredSizeDebugListener(Component component) {
        JRootPane jRootPane;
        if (component instanceof JFrame) {
            jRootPane = ((JFrame)component).getRootPane();
        } else if (component instanceof JDialog) {
            jRootPane = ((JDialog)component).getRootPane();
        } else {
            throw new IllegalArgumentException();
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Component component = (Component)actionEvent.getSource();
                Component component2 = SwingUtilities.findFocusOwner(component);
                while (component2 != null) {
                    Dimension dimension = component2.getPreferredSize();
                    System.err.println("ALT-1: comp=" + component2.getName() + "(" + component2.getClass().getName() + ") " + "[w:" + dimension.width + ",h:" + dimension.height + "]");
                    component2 = component2.getParent();
                }
            }
        };
        jRootPane.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke("alt 1"), 2);
    }

    private static File getDesktopFile() {
        String string = System.getProperty("javatest.desktop.file");
        if (string == null) {
            File file = new File(System.getProperty("user.home"));
            File file2 = new File(file, ".javatest");
            return new File(file2, "desktop");
        }
        if (!string.equals("NONE")) {
            return new File(string);
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        styleNames = new String[]{"tab", "mdi", "sdi"};
        allFrames = new Vector();
        Object object = Desktop.getDesktopFile();
        firstTime = object == null || !((File)object).exists();
        uif = new UIFactory(class$com$sun$javatest$tool$Desktop == null ? (class$com$sun$javatest$tool$Desktop = Desktop.class$("com.sun.javatest.tool.Desktop")) : class$com$sun$javatest$tool$Desktop);
        fileHistory = new LinkedList();
        SEPARATOR = null;
        defaultToolManager = System.getProperty("javatest.desktop.defaultTool", "com.sun.javatest.exec.ExecManager");
        object = System.getProperty("javatest.focus.monitor");
        if (object != null) {
            focusMonitor = FocusMonitor.access();
            if (!((String)object).equals("true")) {
                focusMonitor.setOptions(StringArray.split((String)object));
            }
            focusMonitor.setActivateKey("alt 2");
            focusMonitor.setReportKey("shift alt 2");
            focusMonitor.setReportFile(System.getProperty("javatest.focus.monitor.log"));
        }
    }

    private class FileMenuListener
    implements MenuListener,
    ActionListener {
        private JMenu fileOpenMenu;
        private JMenuItem prefs = uif.createMenuItem("dt.file", "prefs", this);
        private JMenuItem close;
        private JMenuItem exit;

        FileMenuListener(Action action) {
            if (action != null) {
                this.close = uif.createMenuItem(action);
            }
            this.exit = uif.createMenuItem("dt.file", Desktop.EXIT, this);
        }

        public void menuSelected(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)menuEvent.getSource();
            jMenu.removeAll();
            ToolManager[] toolManagerArray = ToolManager.getAllManagers();
            int n = 0;
            while (n < toolManagerArray.length) {
                Action[] actionArray = toolManagerArray[n].getFileMenuActions();
                if (actionArray != null) {
                    int n2 = 0;
                    while (n2 < actionArray.length) {
                        jMenu.add(new JMenuItem(actionArray[n2]));
                        ++n2;
                    }
                    jMenu.addSeparator();
                }
                ++n;
            }
            jMenu.add(this.prefs);
            jMenu.addSeparator();
            if (!fileHistory.isEmpty()) {
                int n3 = 0;
                Iterator iterator = fileHistory.iterator();
                while (iterator.hasNext()) {
                    FileHistoryEntry fileHistoryEntry = (FileHistoryEntry)iterator.next();
                    if (!fileHistoryEntry.file.exists()) continue;
                    String string = uif.getI18NString("dt.file.historyX.mit", new Object[]{new Integer(n3), fileHistoryEntry.file.getPath()});
                    JMenuItem jMenuItem = new JMenuItem(string);
                    jMenuItem.setActionCommand(Desktop.HISTORY);
                    jMenuItem.addActionListener(this);
                    jMenuItem.putClientProperty(this, fileHistoryEntry);
                    if (n3 < 10) {
                        jMenuItem.setMnemonic(Character.forDigit(n3, 10));
                    }
                    ++n3;
                    jMenu.add(jMenuItem);
                }
                jMenu.addSeparator();
            }
            if (this.close != null) {
                jMenu.add(this.close);
            }
            jMenu.add(this.exit);
        }

        public void menuDeselected(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)menuEvent.getSource();
            jMenu.removeAll();
        }

        public void menuCanceled(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)menuEvent.getSource();
            jMenu.removeAll();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            Component component;
            JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = Desktop.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, component = (Component)actionEvent.getSource());
            if (jFrame == null) {
                jFrame = Desktop.this.getFrames()[0];
            }
            if ((string = actionEvent.getActionCommand()).equals(Desktop.PREFS)) {
                Desktop.this.doPrefs(jFrame);
            } else if (string.equals(Desktop.HISTORY)) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                FileHistoryEntry fileHistoryEntry = (FileHistoryEntry)jMenuItem.getClientProperty(this);
                try {
                    fileHistoryEntry.fileOpener.open(fileHistoryEntry.file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    uif.showError("dt.file.cannotFind", fileHistoryEntry.file);
                }
                catch (FileOpener.Fault fault) {
                    uif.showError("dt.file.cannotOpen", new Object[]{fileHistoryEntry.file, fault.getMessage()});
                }
            } else if (string.equals(Desktop.EXIT)) {
                Desktop.this.checkToolsAndExitIfOK(jFrame);
            }
        }
    }

    private static class FileHistoryEntry {
        FileOpener fileOpener;
        File file;

        FileHistoryEntry(FileOpener fileOpener, File file) {
            this.fileOpener = fileOpener;
            this.file = file;
        }
    }
}

