/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.JavaTestError;
import com.sun.javatest.Parameters;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.report.HTMLSection;
import com.sun.javatest.report.Report;
import com.sun.javatest.report.ReportModel;
import com.sun.javatest.report.ReportWriter;
import com.sun.javatest.report.TestResultsByStatusAndTitleComparator;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

class ResultSection
extends HTMLSection {
    private ReportModel model;
    private File workDirRoot;
    private TestResultTable resultTable;
    private File[] initFiles;
    private TestFilter[] paramFilters;
    private SortedSet[] lists;
    private int totalFound;
    private final int[] fileCodes = new int[]{4, 5, 6, 7};
    private final String[] headings = new String[]{HTMLSection.i18n.getString("result.heading.passed"), HTMLSection.i18n.getString("result.heading.failed"), HTMLSection.i18n.getString("result.heading.errors"), HTMLSection.i18n.getString("result.heading.notRun")};

    ResultSection(Parameters parameters, ReportModel reportModel) {
        super(HTMLSection.i18n.getString("result.title"), parameters);
        this.model = reportModel;
        this.workDirRoot = parameters.getWorkDirectory().getRoot();
        File file = reportModel.getReportDir();
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = this.workDirRoot.getPath();
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        if (file.getPath().startsWith(string)) {
            File file2 = file;
            StringBuffer stringBuffer = new StringBuffer();
            while (file2 != null && !file2.equals(this.workDirRoot)) {
                stringBuffer.append("../");
                file2 = file2.getParentFile();
            }
            this.workDirRoot = new File(stringBuffer.toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    ResultSection(Parameters var1_1, ReportModel var2_2, TestResultTable var3_3, File[] var4_4, TestFilter[] var5_5) {
        this(var1_1, var2_2);
        this.resultTable = var3_3;
        this.initFiles = var4_4;
        this.paramFilters = var5_5;
        this.lists = new SortedSet[4];
        var6_6 = 0;
        while (var6_6 < this.lists.length) {
            this.lists[var6_6] = new TreeSet<E>(new TestResultsByStatusAndTitleComparator());
            ++var6_6;
        }
        try {
            var7_7 = this.initFiles == null ? this.resultTable.getIterator(this.paramFilters) : this.resultTable.getIterator(this.initFiles, this.paramFilters);
            if (true) ** GOTO lbl21
        }
        catch (TestResultTable.Fault var8_8) {
            throw new JavaTestError(HTMLSection.i18n.getString("result.testResult.err"));
        }
        do {
            var10_11 = this.lists[(var9_10 = (var8_9 = (TestResult)var7_7.next()).getStatus()) == null ? 3 : var9_10.getType()];
            var10_11.add(var8_9);
            ++this.totalFound;
lbl21:
            // 2 sources

        } while (var7_7.hasNext());
    }

    void writeSummary(ReportWriter reportWriter) throws IOException {
        super.writeSummary(reportWriter);
        reportWriter.startTag("table");
        reportWriter.writeAttr("border", 1);
        int n = 0;
        while (n < this.lists.length) {
            String string = Report.files[this.fileCodes[n]];
            SortedSet sortedSet = this.lists[n];
            int n2 = sortedSet.size();
            if (n2 > 0) {
                reportWriter.startTag("tr");
                reportWriter.writeTH(this.headings[n], "row");
                reportWriter.startTag("td");
                reportWriter.writeLink(string, Integer.toString(n2));
                reportWriter.endTag("td");
                reportWriter.endTag("tr");
            }
            ++n;
        }
        reportWriter.startTag("tr");
        reportWriter.writeTH(HTMLSection.i18n.getString("result.total"), "row");
        reportWriter.writeTD(Integer.toString(this.totalFound));
        reportWriter.endTag("tr");
        reportWriter.endTag("table");
    }

    void writeExtraFiles() throws IOException {
        this.writeStatusFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStatusFiles() throws IOException {
        int n = 0;
        while (n < this.lists.length) {
            Object var14_14;
            ReportWriter reportWriter = this.openAuxFile(this.fileCodes[n], this.headings[n], HTMLSection.i18n);
            reportWriter.write(HTMLSection.i18n.getString("result.groupByStatus"));
            try {
                SortedSet sortedSet = this.lists[n];
                if (sortedSet.size() > 0) {
                    boolean bl = false;
                    String string = null;
                    Iterator iterator = sortedSet.iterator();
                    while (iterator.hasNext()) {
                        String string2;
                        Object object;
                        TestResult testResult = (TestResult)iterator.next();
                        try {
                            object = testResult.getDescription();
                            string2 = ((TestDescription)object).getTitle();
                        }
                        catch (TestResult.Fault fault) {
                            string2 = null;
                        }
                        object = testResult.getStatus();
                        if (!((Status)object).getReason().equals(string)) {
                            string = ((Status)object).getReason();
                            if (bl) {
                                bl = false;
                                reportWriter.endTag("ul");
                                reportWriter.newLine();
                            }
                            reportWriter.startTag("h4");
                            reportWriter.write(string.length() == 0 ? HTMLSection.i18n.getString("result.noReason") : string);
                            reportWriter.endTag("h4");
                            reportWriter.newLine();
                        }
                        if (!bl) {
                            bl = true;
                            reportWriter.startTag("ul");
                        }
                        reportWriter.startTag("li");
                        String string3 = testResult.getWorkRelativePath();
                        File file = new File(this.workDirRoot, string3.replace('/', File.separatorChar));
                        String string4 = testResult.getTestName();
                        if (file == null || ((Status)object).getType() == 3) {
                            reportWriter.write(string4);
                        } else {
                            reportWriter.writeLink(file, string4);
                        }
                        if (string2 != null) {
                            reportWriter.write(": " + string2);
                        }
                        reportWriter.newLine();
                    }
                    if (bl) {
                        bl = false;
                        reportWriter.endTag("ul");
                    }
                }
                var14_14 = null;
            }
            catch (Throwable throwable) {
                var14_14 = null;
                reportWriter.close();
                throw throwable;
            }
            reportWriter.close();
            ++n;
        }
    }
}

