/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.ProductInfo;
import com.sun.javatest.util.HTMLWriter;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;

class ReportWriter
extends HTMLWriter {
    private I18NResourceBundle i18n;
    private static final String BODY = "body";
    private static final String FONT_SIZE = "font-size";
    private static final String FONT_FAMILY = "font-family";
    private static final String BGCOLOR = "bgcolor";
    private static final String MARGIN_LEFT = "margin-left";
    private static final String SANSSERIF = "SansSerif";
    private static final String WHITE = "white";
    private static final String _12PT = "12pt";

    ReportWriter(Writer writer) throws IOException {
        super(writer);
    }

    ReportWriter(Writer writer, I18NResourceBundle i18NResourceBundle) throws IOException {
        super(writer, i18NResourceBundle);
        this.i18n = i18NResourceBundle;
    }

    ReportWriter(Writer writer, String string, I18NResourceBundle i18NResourceBundle) throws IOException {
        super(writer, "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">", i18NResourceBundle);
        this.i18n = i18NResourceBundle;
        this.startTag("html");
        this.startTag("head");
        this.startTag("title");
        this.writeI18N("reportWriter.product.name", new Object[]{ProductInfo.getName(), string});
        this.endTag("title");
        this.writeStyle();
        this.endTag("head");
        this.startTag(BODY);
        this.startTag("h1");
        this.writeI18N("reportWriter.product.name", new Object[]{ProductInfo.getName(), string});
        this.endTag("h1");
    }

    public void close() throws IOException {
        Date date = new Date();
        String string = ProductInfo.getName();
        String string2 = ProductInfo.getVersion();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1);
        Date date2 = ProductInfo.getBuildDate();
        String string3 = date2 != null ? dateFormat.format(date2) : (this.i18n != null ? this.i18n.getString("reportWriter.noDate") : "unknown");
        String string4 = ProductInfo.getBuildJavaVersion();
        this.startTag("p");
        this.startTag("hr");
        this.startTag("small");
        this.writeI18N("reportWriter.generatedOn", date);
        this.startTag("br");
        this.writeI18N("reportWriter.productInfo", new Object[]{string, string2, string3, string4});
        this.endTag("small");
        this.endTag(BODY);
        this.endTag("html");
        super.flush();
        super.close();
    }

    void writeStyle() throws IOException {
        this.startTag("style");
        this.writeAttr("type", "text/css");
        this.write(BODY);
        this.write("{ ");
        this.newLine();
        this.writeStyleSheetProperty(FONT_SIZE, _12PT, true);
        this.writeStyleSheetProperty(FONT_FAMILY, SANSSERIF, true);
        this.writeStyleSheetProperty(BGCOLOR, WHITE, true);
        this.writeStyleSheetProperty(MARGIN_LEFT, "3", false);
        this.write(" }");
        this.endTag("style");
    }

    void writeStyleSheetProperty(String string, String string2, boolean bl) throws IOException {
        if (bl) {
            this.writeI18N("reportWriter.keyValue.separator", new Object[]{string, string2});
        } else {
            this.writeI18N("reportWriter.keyValue", new Object[]{string, string2});
        }
        this.newLine();
    }

    void writeTD(String string) throws IOException {
        this.startTag("td");
        this.write(string);
        this.endTag("td");
    }

    void writeTH(String string) throws IOException {
        this.writeTH(string, null);
    }

    void writeTH(String string, String string2) throws IOException {
        this.startTag("th");
        if (string2 != null) {
            this.writeAttr("scope", string2);
        }
        this.write(string);
        this.endTag("th");
    }

    void writeWarning(String string) throws IOException {
        this.startTag("font");
        this.writeAttr("color", this.i18n.getString("reportWriter.warn.clr"));
        this.write(string);
        this.endTag("font");
    }
}

