/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.JavaTestError;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.report.ConfigSection;
import com.sun.javatest.report.HTMLSection;
import com.sun.javatest.report.ReportModel;
import com.sun.javatest.report.ReportWriter;
import com.sun.javatest.report.ResultSection;
import com.sun.javatest.report.StatisticsSection;
import com.sun.javatest.report.TestResultsByFileComparator;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.TextWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TreeSet;
import java.util.Vector;

public class Report
implements ReportModel {
    private Parameters params;
    private TestResultTable resultTable;
    private TestFilter[] paramFilters;
    private static BackupPolicy backupPolicy;
    private static File reportDir;
    private String[] initUrls;
    private File[] initFiles;
    private static I18NResourceBundle i18n;
    private static final String REPORT_NAME = "report.html";
    static final String[] anchors;
    static final int SELECT_ANCHOR = 0;
    static final int EXEC_ANCHOR = 1;
    static final int LOC_ANCHOR = 2;
    static final int KEYWORD_ANCHOR = 3;
    static final String[] files;
    static final int REPORT_HTML = 0;
    static final int CONFIG_HTML = 1;
    static final int ENV_HTML = 2;
    static final int EXCLUDED_HTML = 3;
    static final int PASSED_HTML = 4;
    static final int FAILED_HTML = 5;
    static final int ERROR_HTML = 6;
    static final int NOTRUN_HTML = 7;
    static final int SMRY_HTML = 8;
    static final int SMRY_TXT = 9;
    static /* synthetic */ Class class$com$sun$javatest$report$Report;

    public Report(Parameters parameters, File file) {
        this.params = parameters;
        this.resultTable = parameters.getWorkDirectory().getTestResultTable();
        backupPolicy = BackupPolicy.simpleBackups(1);
        reportDir = file.getAbsoluteFile();
    }

    public Report(Parameters parameters, File file, TestFilter testFilter) {
        this(parameters, file);
        this.paramFilters = new TestFilter[]{testFilter};
    }

    public File[] checkExistingFiles() {
        Object object;
        Vector<Object[]> vector = new Vector<Object[]>();
        int n = 0;
        while (n < files.length) {
            object = new File(reportDir, files[n]);
            if (object.exists()) {
                vector.addElement((Object[])object);
            }
            ++n;
        }
        if (vector.size() == 0) {
            return null;
        }
        object = new File[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public void writeReport() throws IOException {
        this.writeReport(0L, 0L);
    }

    public void writeReport(long l, long l2) throws IOException {
        if (this.paramFilters == null) {
            this.paramFilters = this.params.getFilters();
        }
        this.initUrls = this.params.getTests();
        if (this.initUrls == null) {
            this.initFiles = null;
        } else {
            this.initFiles = new File[this.initUrls.length];
            int n = 0;
            while (n < this.initUrls.length) {
                this.initFiles[n] = new File(this.initUrls[n]);
                ++n;
            }
        }
        this.params.getWorkDirectory().getTestResultTable().waitUntilReady();
        this.writeReportHTML(l, l2);
        this.writeSummaryTXT();
    }

    public static String getFile(int n) {
        return files[n];
    }

    public static boolean isReportDirectory(File file) {
        File file2 = new File(file, REPORT_NAME);
        return file2.exists() && file2.canRead();
    }

    public static String getReportFilename() {
        return REPORT_NAME;
    }

    public File getReportDir() {
        return reportDir;
    }

    private void writeReportHTML(long l, long l2) throws IOException {
        HTMLSection[] hTMLSectionArray = new HTMLSection[]{new ConfigSection(this.params, this), new ResultSection(this.params, this, this.resultTable, this.initFiles, this.paramFilters), new StatisticsSection(this.params, this.resultTable, this.initFiles, this.paramFilters)};
        ReportWriter reportWriter = new ReportWriter(Report.openWriter(0), i18n.getString("report.title"), i18n);
        String string = this.params.getTestSuite().getName();
        if (string != null) {
            reportWriter.startTag("h2");
            reportWriter.writeI18N("report.testSuite", string);
            reportWriter.endTag("h2");
        }
        reportWriter.startTag("ul");
        int n = 0;
        while (n < hTMLSectionArray.length) {
            reportWriter.startTag("li");
            hTMLSectionArray[n].writeContents(reportWriter);
            reportWriter.endTag("li");
            ++n;
        }
        reportWriter.endTag("ul");
        int n2 = 0;
        while (n2 < hTMLSectionArray.length) {
            reportWriter.startTag("p");
            reportWriter.startTag("hr");
            hTMLSectionArray[n2].writeSummary(reportWriter);
            reportWriter.newLine();
            ++n2;
        }
        reportWriter.startTag("p");
        reportWriter.startTag("hr");
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        long l3 = runtime.freeMemory();
        long l4 = runtime.totalMemory();
        reportWriter.startTag("p");
        reportWriter.startTag("b");
        reportWriter.write(i18n.getString("report.memory"));
        reportWriter.endTag("b");
        reportWriter.startTag("p");
        reportWriter.writeI18N("report.memoryUsed", new Object[]{new Integer((int)(l4 - l3) / 1024), new Integer((int)(l4 / 1024L))});
        reportWriter.newLine();
        DateFormat dateFormat = DateFormat.getTimeInstance(0);
        if (l != 0L && l2 != 0L) {
            long l5 = l2 - l;
            int n3 = (int)(l5 / 1000L % 60L);
            int n4 = (int)(l5 / 60000L % 60L);
            int n5 = (int)(l5 / 3600000L);
            Date date = new Date(l);
            Date date2 = new Date(l2);
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, n5);
            calendar.set(12, n4);
            calendar.set(13, n3);
            reportWriter.startTag("p");
            reportWriter.startTag("b");
            reportWriter.write(i18n.getString("report.time"));
            reportWriter.endTag("b");
            reportWriter.startTag("p");
            reportWriter.writeI18N("report.timeUsed", new Object[]{dateFormat.format(date), dateFormat.format(date2)});
            reportWriter.newLine();
        }
        reportWriter.newLine();
        reportWriter.close();
        int n6 = 0;
        while (n6 < hTMLSectionArray.length) {
            hTMLSectionArray[n6].writeExtraFiles();
            ++n6;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void writeSummaryTXT() throws IOException {
        var1_1 = new TreeSet<Object>(new TestResultsByFileComparator());
        var2_2 = 0;
        var3_3 = null;
        try {
            block5: {
                if (this.initFiles != null) break block5;
                var3_3 = this.resultTable.getIterator(this.paramFilters);
                ** GOTO lbl18
            }
            var3_3 = this.resultTable.getIterator(this.initFiles, this.paramFilters);
            if (true) ** GOTO lbl18
        }
        catch (TestResultTable.Fault var4_4) {
            throw new JavaTestError(Report.i18n.getString("report.testResult.err"));
        }
        do {
            var4_5 = (TestResult)var3_3.next();
            var2_2 = Math.max(var2_2, var4_5.getTestName().length());
            var1_1.add(var4_5);
lbl18:
            // 3 sources

        } while (var3_3.hasNext());
        var4_5 = new TextWriter(Report.openWriter(9));
        var3_3 = var1_1.iterator();
        while (var3_3.hasNext()) {
            var5_6 = (TestResult)var3_3.next();
            var6_7 = var5_6.getTestName();
            var4_5.print(var6_7);
            var7_8 = var6_7.length();
            while (var7_8 < var2_2) {
                var4_5.print(" ");
                ++var7_8;
            }
            var4_5.print("  ");
            var4_5.println(var5_6.getStatus().toString());
        }
        var4_5.close();
    }

    static Writer openWriter(int n) throws IOException {
        return backupPolicy.backupAndOpenWriter(new File(reportDir, files[n]));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$report$Report == null ? (class$com$sun$javatest$report$Report = Report.class$("com.sun.javatest.report.Report")) : class$com$sun$javatest$report$Report);
        anchors = new String[]{"selection", "execution", "locations", "keywordSummary"};
        files = new String[]{REPORT_NAME, "config.html", "env.html", "excluded.html", "passed.html", "failed.html", "error.html", "notRun.html", "summary.html", "summary.txt"};
    }
}

