/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.interview.WizPrint;
import com.sun.javatest.ExcludeList;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.report.HTMLSection;
import com.sun.javatest.report.Report;
import com.sun.javatest.report.ReportModel;
import com.sun.javatest.report.ReportWriter;
import com.sun.javatest.report.StringArrayComparator;
import com.sun.javatest.util.StringArray;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;

class ConfigSection
extends HTMLSection {
    ConfigSection(Parameters parameters, ReportModel reportModel) {
        super(HTMLSection.i18n.getString("config.title"), parameters, reportModel);
    }

    void writeContents(ReportWriter reportWriter) throws IOException {
        super.writeContents(reportWriter);
        if (this.params instanceof InterviewParameters) {
            reportWriter.startTag("ul");
            reportWriter.startTag("li");
            reportWriter.writeLink(Report.files[1], HTMLSection.i18n.getString("config.confInterview"));
            reportWriter.endTag("li");
            reportWriter.endTag("ul");
        }
        reportWriter.startTag("ul");
        reportWriter.startTag("li");
        reportWriter.writeLink("#" + Report.anchors[0], HTMLSection.i18n.getString("config.selectValue"));
        reportWriter.endTag("li");
        reportWriter.startTag("li");
        reportWriter.writeLink("#" + Report.anchors[1], HTMLSection.i18n.getString("config.execValue"));
        reportWriter.endTag("li");
        reportWriter.startTag("li");
        reportWriter.writeLink("#" + Report.anchors[2], HTMLSection.i18n.getString("config.locValue"));
        reportWriter.endTag("li");
        reportWriter.endTag("ul");
    }

    void writeSummary(ReportWriter reportWriter) throws IOException {
        super.writeSummary(reportWriter);
        if (this.params instanceof InterviewParameters) {
            reportWriter.startTag("ul");
            reportWriter.startTag("li");
            reportWriter.writeLink(Report.files[1], HTMLSection.i18n.getString("config.confInterview"));
            if (!this.params.isValid()) {
                reportWriter.writeWarning(HTMLSection.i18n.getString("config.intIncomplete"));
            }
            reportWriter.endTag("li");
            reportWriter.endTag("ul");
        }
        this.writeSelectionSummary(reportWriter);
        this.writeExecutionSummary(reportWriter);
        this.writeLocationSummary(reportWriter);
    }

    void writeExtraFiles() throws IOException {
        if (this.params instanceof InterviewParameters) {
            this.writeConfigInterview();
        }
        this.writeEnvironment();
        this.writeExcludeList();
    }

    private void writeSelectionSummary(ReportWriter reportWriter) throws IOException {
        Object object;
        boolean[] blArray;
        String[] stringArray;
        String[] stringArray2;
        reportWriter.startTag("h3");
        reportWriter.writeLinkDestination(Report.anchors[0], HTMLSection.i18n.getString("config.selectValue"));
        reportWriter.endTag("h3");
        reportWriter.startTag("table");
        reportWriter.writeAttr("border", 1);
        TestSuite testSuite = this.params.getTestSuite();
        if (testSuite != null) {
            reportWriter.startTag("tr");
            reportWriter.writeTH(HTMLSection.i18n.getString("config.testSuite"), "row");
            reportWriter.startTag("td");
            reportWriter.writeLink(testSuite.getRoot());
            reportWriter.endTag("td");
            reportWriter.endTag("tr");
        }
        if ((stringArray2 = this.params.getTests()) != null && stringArray2.length > 0) {
            reportWriter.startTag("tr");
            reportWriter.writeTH(HTMLSection.i18n.getString("config.tests"), "row");
            reportWriter.startTag("td");
            int n = 0;
            while (n < stringArray2.length) {
                if (n > 0) {
                    reportWriter.startTag("br");
                }
                stringArray = new File(testSuite.getTestsDir(), stringArray2[n]);
                reportWriter.writeLink((File)stringArray, stringArray2[n]);
                ++n;
            }
            reportWriter.endTag("td");
            reportWriter.endTag("tr");
        }
        if ((blArray = this.params.getPriorStatusValues()) != null) {
            stringArray = new String[]{HTMLSection.i18n.getString("config.status.passed"), HTMLSection.i18n.getString("config.status.failed"), HTMLSection.i18n.getString("config.status.error"), HTMLSection.i18n.getString("config.status.notRun")};
            object = new StringBuffer();
            int n = 0;
            while (n < blArray.length) {
                if (blArray[n]) {
                    if (((StringBuffer)object).length() > 0) {
                        ((StringBuffer)object).append(" or ");
                    }
                    ((StringBuffer)object).append(stringArray[n]);
                }
                ++n;
            }
            reportWriter.startTag("tr");
            reportWriter.writeTH(HTMLSection.i18n.getString("config.previous"), "row");
            reportWriter.writeTD(((StringBuffer)object).toString());
            reportWriter.endTag("tr");
        }
        if ((stringArray = this.params.getExcludeList()) != null && !stringArray.isEmpty()) {
            File[] fileArray;
            reportWriter.startTag("tr");
            reportWriter.writeTH(HTMLSection.i18n.getString("config.excludeTests"), "row");
            reportWriter.startTag("td");
            reportWriter.writeI18N("config.entries", new Object[]{new Integer(stringArray.size())});
            if (stringArray.getChecksumState() == 1) {
                reportWriter.startTag("br");
                reportWriter.writeWarning(HTMLSection.i18n.getString("config.invalidXsum"));
            }
            if ((object = this.params.getExcludeListParameters()) instanceof Parameters.MutableExcludeListParameters && (fileArray = ((Parameters.MutableExcludeListParameters)object).getExcludeFiles()) != null && fileArray.length > 0) {
                int n = 0;
                while (n < fileArray.length) {
                    reportWriter.startTag("br");
                    reportWriter.writeLink(Report.files[3], fileArray[n].getPath());
                    ++n;
                }
            }
            reportWriter.endTag("td");
            reportWriter.endTag("tr");
        }
        if (this.params.getKeywords() != null) {
            reportWriter.startTag("tr");
            reportWriter.writeTH(HTMLSection.i18n.getString("config.keywords"), "row");
            reportWriter.writeTD(this.params.getKeywords().toString());
            reportWriter.endTag("tr");
        }
        reportWriter.endTag("table");
    }

    private void writeExecutionSummary(ReportWriter reportWriter) throws IOException {
        float f;
        int n;
        TestEnvironment testEnvironment;
        String string;
        reportWriter.startTag("h3");
        reportWriter.writeLinkDestination(Report.anchors[1], HTMLSection.i18n.getString("config.execValue"));
        reportWriter.endTag("h3");
        reportWriter.startTag("table");
        reportWriter.writeAttr("border", 1);
        File[] fileArray = null;
        Parameters.EnvParameters envParameters = this.params.getEnvParameters();
        if (envParameters != null && envParameters instanceof Parameters.LegacyEnvParameters && (fileArray = ((Parameters.LegacyEnvParameters)envParameters).getEnvFiles()) != null) {
            reportWriter.startTag("tr");
            reportWriter.writeTH(HTMLSection.i18n.getString("config.envFiles"), "row");
            reportWriter.startTag("td");
            int n2 = 0;
            while (n2 < fileArray.length) {
                reportWriter.writeLink(new File(fileArray[n2].getPath()));
                reportWriter.startTag("br");
                ++n2;
            }
            reportWriter.endTag("td");
            reportWriter.endTag("tr");
        }
        String string2 = string = (testEnvironment = this.params.getEnv()) != null ? testEnvironment.getName() : null;
        if (string != null && string.length() > 0) {
            reportWriter.startTag("tr");
            reportWriter.writeTH(HTMLSection.i18n.getString("config.env"), "row");
            reportWriter.startTag("td");
            reportWriter.writeLink(Report.files[2], string);
            reportWriter.endTag("td");
            reportWriter.endTag("tr");
        }
        if ((n = this.params.getConcurrency()) > 1) {
            reportWriter.startTag("tr");
            reportWriter.writeTH(HTMLSection.i18n.getString("config.concurrency"), "row");
            reportWriter.startTag("td");
            reportWriter.write(Integer.toString(n));
            reportWriter.endTag("td");
            reportWriter.endTag("tr");
        }
        if ((f = this.params.getTimeoutFactor()) > 0.0f) {
            reportWriter.startTag("tr");
            reportWriter.writeTH(HTMLSection.i18n.getString("config.timeOut"), "row");
            reportWriter.startTag("td");
            reportWriter.write(NumberFormat.getInstance().format(f));
            reportWriter.endTag("td");
            reportWriter.endTag("tr");
        }
        reportWriter.endTag("table");
    }

    private void writeLocationSummary(ReportWriter reportWriter) throws IOException {
        WorkDirectory workDirectory = this.params.getWorkDirectory();
        File file = this.model.getReportDir();
        reportWriter.startTag("h3");
        reportWriter.writeLinkDestination(Report.anchors[2], HTMLSection.i18n.getString("config.locValue"));
        reportWriter.endTag("h3");
        reportWriter.startTag("table");
        reportWriter.writeAttr("border", 1);
        reportWriter.startTag("tr");
        reportWriter.writeTH(HTMLSection.i18n.getString("config.wd"), "row");
        reportWriter.startTag("td");
        reportWriter.writeLink(workDirectory.getRoot());
        reportWriter.endTag("td");
        reportWriter.endTag("tr");
        reportWriter.startTag("tr");
        reportWriter.writeTH(HTMLSection.i18n.getString("config.rd"), "row");
        reportWriter.startTag("td");
        reportWriter.writeLink(file);
        reportWriter.endTag("td");
        reportWriter.endTag("tr");
        reportWriter.endTag("table");
    }

    private void writeConfigInterview() throws IOException {
        WizPrint wizPrint = new WizPrint((InterviewParameters)this.params);
        wizPrint.setShowResponses(true);
        wizPrint.write(Report.openWriter(1));
    }

    private void writeEnvironment() throws IOException {
        String[] stringArray;
        Object object;
        Object object2;
        TestEnvironment testEnvironment = this.params.getEnv();
        String string = testEnvironment != null ? testEnvironment.getName() : null;
        ReportWriter reportWriter = this.openAuxFile(2, "Environment \"" + string + "\"", HTMLSection.i18n);
        if (testEnvironment == null) {
            reportWriter.write(HTMLSection.i18n.getString("config.noEnv"));
            return;
        }
        try {
            object2 = testEnvironment.lookup(HTMLSection.i18n.getString("config.desc"));
            if (object2 != null) {
                reportWriter.startTag("h2");
                reportWriter.write(StringArray.join((String[])object2));
                reportWriter.endTag("h2");
            }
        }
        catch (TestEnvironment.Fault fault) {
            reportWriter.write(HTMLSection.i18n.getString("config.testEnv.err"));
        }
        object2 = new TreeSet(new StringArrayComparator());
        Iterator iterator = testEnvironment.elements().iterator();
        while (iterator.hasNext()) {
            object = (TestEnvironment.Element)iterator.next();
            stringArray = new String[]{((TestEnvironment.Element)object).getKey(), ((TestEnvironment.Element)object).getValue()};
            object2.add(stringArray);
        }
        reportWriter.startTag("table");
        reportWriter.writeAttr("border", 1);
        object = object2.iterator();
        while (object.hasNext()) {
            stringArray = (String[])object.next();
            reportWriter.startTag("tr");
            int n = 0;
            while (n < stringArray.length) {
                reportWriter.startTag("td");
                reportWriter.write(stringArray[n]);
                reportWriter.endTag("td");
                ++n;
            }
            reportWriter.endTag("tr");
        }
        reportWriter.endTag("table");
        reportWriter.close();
    }

    private void writeExcludeList() throws IOException {
        ReportWriter reportWriter = this.openAuxFile(3, HTMLSection.i18n.getString("config.excludedTests"), HTMLSection.i18n);
        ExcludeList excludeList = this.params.getExcludeList();
        if (excludeList == null || excludeList.size() == 0) {
            reportWriter.writeI18N("config.excl.none");
        } else {
            int n = excludeList.getChecksumState();
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    reportWriter.startTag("p");
                    reportWriter.writeWarning(HTMLSection.i18n.getString("config.excl.badXsum"));
                    reportWriter.endTag("p");
                    break;
                }
            }
            TreeSet treeSet = new TreeSet(new ExcludeListEntryComparator());
            Iterator iterator = excludeList.getIterator(false);
            while (iterator.hasNext()) {
                treeSet.add(iterator.next());
            }
            reportWriter.startTag("table");
            reportWriter.writeAttr("border", 1);
            reportWriter.startTag("tr");
            reportWriter.startTag("th");
            reportWriter.writeI18N("config.excl.name");
            reportWriter.endTag("th");
            reportWriter.startTag("th");
            reportWriter.writeI18N("config.excl.testcase");
            reportWriter.endTag("th");
            reportWriter.startTag("th");
            reportWriter.writeI18N("config.excl.bugids");
            reportWriter.endTag("th");
            reportWriter.startTag("th");
            reportWriter.writeI18N("config.excl.platforms");
            reportWriter.endTag("th");
            reportWriter.startTag("th");
            reportWriter.writeI18N("config.excl.synopsis");
            reportWriter.endTag("th");
            reportWriter.endTag("tr");
            Iterator iterator2 = treeSet.iterator();
            while (iterator2.hasNext()) {
                ExcludeList.Entry entry = (ExcludeList.Entry)iterator2.next();
                reportWriter.startTag("tr");
                this.writeTD(reportWriter, entry.getRelativeURL());
                this.writeTD(reportWriter, entry.getTestCases());
                reportWriter.startTag("td");
                int[] nArray = entry.getBugIds();
                int n2 = 0;
                while (n2 < nArray.length) {
                    if (n2 > 0) {
                        reportWriter.write(" ");
                    }
                    reportWriter.write(Integer.toString(nArray[n2]));
                    ++n2;
                }
                reportWriter.endTag("td");
                this.writeTD(reportWriter, StringArray.join(entry.getPlatforms()));
                this.writeTD(reportWriter, entry.getSynopsis());
                reportWriter.endTag("tr");
            }
            reportWriter.endTag("table");
        }
        reportWriter.newLine();
        reportWriter.close();
    }

    private void writeTD(ReportWriter reportWriter, String string) throws IOException {
        reportWriter.startTag("td");
        if (string == null || string.length() == 0) {
            reportWriter.writeEntity("&nbsp;");
        } else {
            reportWriter.write(string);
        }
        reportWriter.endTag("td");
    }

    private static class ExcludeListEntryComparator
    implements Comparator {
        private ExcludeListEntryComparator() {
        }

        public int compare(Object object, Object object2) {
            ExcludeList.Entry entry = (ExcludeList.Entry)object;
            ExcludeList.Entry entry2 = (ExcludeList.Entry)object2;
            int n = ExcludeListEntryComparator.compare(entry.getRelativeURL(), entry2.getRelativeURL());
            if (n == 0) {
                n = ExcludeListEntryComparator.compare(entry.getTestCases(), entry2.getTestCases());
            }
            return n;
        }

        private static int compare(String[] stringArray, String[] stringArray2) {
            int n = stringArray == null ? 0 : stringArray.length;
            int n2 = stringArray2 == null ? 0 : stringArray2.length;
            int n3 = 0;
            while (n3 < Math.min(n, n2)) {
                int n4 = ExcludeListEntryComparator.compare(stringArray[n3], stringArray2[n3]);
                if (n4 != 0) {
                    return n4;
                }
                ++n3;
            }
            return n < n2 ? -1 : (n == n2 ? 0 : 1);
        }

        private static int compare(String string, String string2) {
            return string == null && string2 == null ? 0 : (string == null ? -1 : (string2 == null ? 1 : string.compareTo(string2)));
        }
    }
}

