/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.moreInfo;

import com.sun.java.help.impl.ViewAwareComponent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;

public class ShowFile
extends JComponent
implements ViewAwareComponent {
    private String title;
    private String path;
    private String startLine;
    private String text = "link";
    private Font font;
    private Color color = Color.blue;
    private View view;
    private static JFrame frame;
    private static JScrollPane scrollPane;
    private static JTextArea textArea;
    private static Highlighter.HighlightPainter highlightPainter;
    private static final int DEFAULT_WIDTH = 5;
    private static final int DEFAULT_HEIGHT = 7;

    public ShowFile() {
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ShowFile.this.showFile();
            }
        });
        this.setCursor(new Cursor(12));
    }

    public Dimension getPreferredSize() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return new Dimension(100, 10);
        }
        FontMetrics fontMetrics = this.font == null ? graphics.getFontMetrics() : graphics.getFontMetrics(this.font);
        int n = fontMetrics.stringWidth(this.text);
        int n2 = fontMetrics.getHeight();
        return new Dimension(n, n2);
    }

    public float getAlignmentY() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return super.getAlignmentY();
        }
        FontMetrics fontMetrics = this.font == null ? graphics.getFontMetrics() : graphics.getFontMetrics(this.font);
        float f = fontMetrics.getMaxAscent();
        float f2 = fontMetrics.getHeight();
        return f / f2;
    }

    public void paintComponent(Graphics graphics) {
        graphics.setColor(this.color);
        if (this.font != null) {
            graphics.setFont(this.font);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getMaxAscent();
        graphics.drawString(this.text, 0, n);
        graphics.drawLine(0, n + 1, fontMetrics.stringWidth(this.text) - 1, n + 1);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getStartLine() {
        return this.startLine;
    }

    public void setStartLine(String string) {
        this.startLine = string;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getTextFont() {
        return this.font == null ? null : this.font.toString();
    }

    public void setTextFont(String string) {
        this.font = Font.decode(string);
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        FontMetrics fontMetrics = this.font == null ? graphics.getFontMetrics() : graphics.getFontMetrics(this.font);
        int n = fontMetrics.stringWidth(this.text);
        int n2 = fontMetrics.getHeight();
        this.setPreferredSize(new Dimension(n, n2));
    }

    public String getTextColor() {
        return this.color.toString();
    }

    public void setTextColor(String string) {
        this.color = Color.decode(string);
    }

    public void setViewData(View view) {
        this.view = view;
    }

    private synchronized void showFile() {
        int n;
        Object object;
        Serializable serializable;
        Object object2;
        if (frame == null) {
            object2 = Toolkit.getDefaultToolkit();
            serializable = ((Toolkit)object2).getScreenSize();
            int n2 = ((Toolkit)object2).getScreenResolution();
            frame = new JFrame();
            if (this.title != null) {
                frame.setTitle(this.title);
            }
            textArea = new JTextArea();
            textArea.setFont(new Font("Monospaced", 0, 12));
            textArea.setLineWrap(false);
            scrollPane = new JScrollPane(textArea);
            frame.setContentPane(scrollPane);
            object = new Color(0xFFFFB0);
            highlightPainter = new DefaultHighlighter.DefaultHighlightPainter((Color)object);
            int n3 = 5 * n2;
            int n4 = 7 * n2;
            frame.setBounds(serializable.width - n3, 0, n3, n4);
        }
        try {
            int n5;
            object2 = this.view.getDocument();
            serializable = ((HTMLDocument)object2).getBase();
            URL uRL = new URL((URL)serializable, this.path);
            object = new BufferedReader(new InputStreamReader(uRL.openStream()));
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[1024];
            while ((n5 = ((BufferedReader)object).read(cArray, 0, cArray.length)) != -1) {
                stringBuffer.append(cArray, 0, n5);
            }
            ((BufferedReader)object).close();
            textArea.setText(stringBuffer.toString());
        }
        catch (IOException iOException) {
            textArea.setText(iOException.toString());
        }
        textArea.setSize(textArea.getPreferredSize());
        frame.validate();
        object2 = textArea.getText();
        int n6 = n = this.startLine == null ? -1 : ((String)object2).indexOf(this.startLine);
        if (n == -1) {
            textArea.setCaretPosition(0);
        } else {
            try {
                int n7 = this.getStartOfLine((String)object2, n);
                int n8 = this.getEndOfLine((String)object2, n);
                Highlighter highlighter = textArea.getHighlighter();
                highlighter.removeAllHighlights();
                highlighter.addHighlight(n7, n8 + 1, highlightPainter);
                textArea.setCaretPosition(n7);
                Rectangle rectangle = textArea.modelToView(n7);
                JViewport jViewport = scrollPane.getViewport();
                int n9 = 50;
                if (jViewport != null && rectangle != null) {
                    jViewport.setViewPosition(new Point(rectangle.x, Math.max(0, rectangle.y - n9)));
                }
            }
            catch (BadLocationException badLocationException) {
                textArea.setCaretPosition(0);
            }
        }
        frame.setVisible(true);
    }

    int getStartOfLine(String string, int n) {
        int n2 = n;
        while (n2 > 0 && string.charAt(n2 - 1) != '\n') {
            --n2;
        }
        return n2;
    }

    int getEndOfLine(String string, int n) {
        int n2 = n;
        while (n2 < string.length() - 1 && string.charAt(n2 + 1) != '\n') {
            ++n2;
        }
        return n2;
    }
}

