/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.lib;

import com.sun.javatest.Script;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.util.StringArray;
import java.io.File;

public class StdTestScript
extends Script {
    public static final int UNKNOWN = 0;
    public static final int CERTIFY = 1;
    public static final int PRECOMPILE = 2;
    public static final int DEVELOPER = 3;
    private int mode = StdTestScript.getDefaultMode();

    public Status run(String[] stringArray, TestDescription testDescription, TestEnvironment testEnvironment) {
        Object object;
        String string;
        try {
            String[] stringArray2 = testEnvironment.lookup("script.mode");
            if (stringArray2 != null && stringArray2.length == 1) {
                this.setMode(stringArray2[0]);
            }
        }
        catch (TestEnvironment.Fault fault) {
            return Status.failed("error determining script mode: " + fault.getMessage());
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        while (n < stringArray.length) {
            string = stringArray[n];
            if (string.equals("-certify")) {
                bl = false;
                bl2 = true;
            } else if (string.equals("-precompile")) {
                bl = true;
                bl2 = false;
            } else if (string.equals("-developer")) {
                bl = true;
                bl2 = true;
            } else if (string.equals("-compile")) {
                bl = true;
            } else if (string.equals("-execute")) {
                bl2 = true;
            } else if (string.equals("-expectFail")) {
                bl3 = true;
            } else {
                return Status.failed("bad arg for script: `" + string + "'");
            }
            ++n;
        }
        if (!bl && !bl2) {
            bl = this.mode == 3 || this.mode == 2;
            boolean bl4 = bl2 = this.mode == 3 || this.mode == 1;
        }
        if (bl) {
            string = testDescription.getParameter("sources");
            if (string == null) {
                string = testDescription.getParameter("source");
            }
            object = StringArray.split(string);
            File[] fileArray = new File[((String[])object).length];
            File file = testDescription.getDir();
            int n2 = 0;
            while (n2 < fileArray.length) {
                fileArray[n2] = new File(file, ((String)object[n2]).replace('/', File.separatorChar));
                ++n2;
            }
            Status status = this.compileTogether(fileArray);
            if (!bl2) {
                if (bl3) {
                    if (status.getType() == 1) {
                        return Script.pass_compFailExp.augment(status);
                    }
                    return Script.fail_compSuccUnexp.augment(status);
                }
                return status;
            }
            if (status.isFailed()) {
                return Script.fail_compFailUnexp.augment(status);
            }
        }
        if (bl2) {
            string = testDescription.getParameter("executeClass");
            if (string == null) {
                return Script.error_noExecuteClass;
            }
            object = this.execute(string, testDescription.getParameter("executeArgs"));
            if (bl3) {
                if (((Status)object).getType() == 1) {
                    return Script.pass_execFailExp.augment((Status)object);
                }
                return Script.fail_execSuccUnexp.augment((Status)object);
            }
            return object;
        }
        return Script.error_noActionSpecified;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                this.mode = n;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void setMode(String string) {
        this.setMode(StdTestScript.parseMode(string));
    }

    private static int parseMode(String string) {
        if (string == null || string.equals("certify")) {
            return 1;
        }
        if (string.equals("precompile")) {
            return 2;
        }
        if (string.equals("developer")) {
            return 3;
        }
        return 0;
    }

    private static int getDefaultMode() {
        return StdTestScript.parseMode(System.getProperty("javatest.stdTestScript.defaultMode"));
    }
}

