/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.lib;

import com.sun.javatest.Command;
import com.sun.javatest.Status;
import com.sun.javatest.util.StringArray;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Hashtable;

public class ProcessCommand
extends Command {
    private boolean verbose;
    private static boolean useFailedOnException = Boolean.getBoolean("javatest.processCommand.useFailedOnException");
    private static final String STATUS_MARKER = "STATUS:";
    private static int serial;
    private Hashtable statusTable;
    private Status defaultStatus;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Status status;
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(System.err));
        PrintWriter printWriter2 = new PrintWriter(new OutputStreamWriter(System.out));
        try {
            ProcessCommand processCommand = new ProcessCommand();
            status = ((Command)processCommand).run(stringArray, printWriter, printWriter2);
            Object var6_5 = null;
            printWriter.flush();
            printWriter2.flush();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            printWriter.flush();
            printWriter2.flush();
            throw throwable;
        }
        status.exit();
    }

    public void setStatusForExit(int n, Status status) {
        if (this.statusTable == null) {
            this.statusTable = new Hashtable();
            if (this.defaultStatus == null) {
                this.defaultStatus = Status.error("unrecognized exit code");
            }
        }
        this.statusTable.put(new Integer(n), status);
    }

    public void setDefaultStatus(Status status) {
        if (this.statusTable == null) {
            this.statusTable = new Hashtable();
        }
        this.defaultStatus = status;
    }

    private void setStatus(String string, Status status) {
        if (string.equals("default")) {
            this.setDefaultStatus(status);
        } else {
            this.setStatusForExit(Integer.parseInt(string), status);
        }
    }

    public Status run(String[] stringArray, PrintWriter printWriter, PrintWriter printWriter2) {
        int n = 0;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            if (stringArray[n].equals("-v")) {
                this.verbose = true;
            } else if (stringArray[n].equals("-pass") && n + 2 < stringArray.length) {
                this.setStatus(stringArray[++n], Status.passed(stringArray[++n]));
            } else if (stringArray[n].equals("-fail") && n + 2 < stringArray.length) {
                this.setStatus(stringArray[++n], Status.failed(stringArray[++n]));
            } else if (stringArray[n].equals("-error") && n + 2 < stringArray.length) {
                this.setStatus(stringArray[++n], Status.error(stringArray[++n]));
            } else {
                if (stringArray[n].equals("-end")) {
                    ++n;
                    break;
                }
                return Status.error("Unrecognized option: " + stringArray[n]);
            }
            ++n;
        }
        int n2 = n;
        while (n < stringArray.length && stringArray[n].indexOf(61) != -1) {
            ++n;
        }
        String[] stringArray2 = new String[n - n2];
        System.arraycopy(stringArray, n2, stringArray2, 0, stringArray2.length);
        if (n == stringArray.length) {
            return Status.error("no command specified for " + this.getClass().getName());
        }
        String[] stringArray3 = new String[stringArray.length - n];
        System.arraycopy(stringArray, n, stringArray3, 0, stringArray3.length);
        return this.exec(stringArray3, stringArray2, printWriter, printWriter2);
    }

    public Status exec(String[] stringArray, String[] stringArray2, PrintWriter printWriter, PrintWriter printWriter2) {
        Process process = null;
        Status status = null;
        try {
            Object object;
            if (stringArray2 != null && stringArray2.length == 0) {
                object = new String[]{"="};
                stringArray2 = object;
            }
            if (this.verbose) {
                printWriter.println("Command is: " + StringArray.join(stringArray));
                if (stringArray2 == null) {
                    printWriter.println("Command environment is inherited from parent process");
                } else if (stringArray2.length == 0) {
                    printWriter.println("Command environment is empty");
                } else {
                    printWriter.println("Command environment is:");
                    int n = 0;
                    while (n < stringArray2.length) {
                        printWriter.println(stringArray2[n]);
                        ++n;
                    }
                }
            }
            process = Runtime.getRuntime().exec(stringArray, stringArray2);
            object = new InputStreamReader(process.getInputStream());
            StreamCopier streamCopier = new StreamCopier((Reader)object, printWriter2);
            streamCopier.start();
            InputStreamReader inputStreamReader = new InputStreamReader(process.getErrorStream());
            StreamCopier streamCopier2 = new StreamCopier(inputStreamReader, printWriter);
            streamCopier2.start();
            OutputStream outputStream = process.getOutputStream();
            if (outputStream != null) {
                outputStream.close();
            }
            streamCopier.waitUntilDone();
            streamCopier2.waitUntilDone();
            int n = process.waitFor();
            ((Reader)object).close();
            ((Reader)inputStreamReader).close();
            return this.getStatus(n, streamCopier2.exitStatus());
        }
        catch (InterruptedException interruptedException) {
            if (process != null) {
                process.destroy();
            }
            String string = "Program `" + stringArray[0] + "' interrupted! (timed out?)";
            status = useFailedOnException ? Status.failed(string) : Status.error(string);
        }
        catch (IOException iOException) {
            String string = "Error invoking program `" + stringArray[0] + "': " + iOException;
            status = useFailedOnException ? Status.failed(string) : Status.error(string);
        }
        return status;
    }

    protected Status getStatus(int n, Status status) {
        if (status != null) {
            return status;
        }
        if (this.statusTable != null) {
            Status status2 = (Status)this.statusTable.get(new Integer(n));
            return status2 == null ? this.defaultStatus.augment("exit code: " + n) : status2;
        }
        if (n == 0) {
            return Status.passed("exit code 0");
        }
        return Status.failed("exit code " + n);
    }

    class StreamCopier
    extends Thread {
        private BufferedReader in;
        private PrintWriter out;
        private String lastLine;
        private boolean done;

        StreamCopier(Reader reader, PrintWriter printWriter) {
            super(Thread.currentThread().getName() + "_StreamCopier_" + serial++);
            this.in = new BufferedReader(reader);
            this.out = printWriter;
            this.lastLine = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            try {
                while ((object = this.in.readLine()) != null) {
                    this.out.println((String)object);
                    if (((String)object).length() <= 0) continue;
                    this.lastLine = object;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            object = this;
            synchronized (object) {
                this.done = true;
                this.notifyAll();
            }
        }

        public synchronized boolean isDone() {
            return this.done;
        }

        public synchronized void waitUntilDone() throws InterruptedException {
            boolean bl = false;
            while (!(bl = Thread.interrupted()) && !this.done) {
                this.wait(1000L);
            }
            if (bl) {
                throw new InterruptedException();
            }
        }

        public Status exitStatus() {
            if (this.lastLine != null && this.lastLine.startsWith(ProcessCommand.STATUS_MARKER)) {
                return Status.parse(this.lastLine.substring(ProcessCommand.STATUS_MARKER.length()));
            }
            return null;
        }
    }
}

