/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.lib;

import com.sun.javatest.Script;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import java.io.File;
import java.io.PrintWriter;

public class APIScript
extends Script {
    private static final String TEST_COMPILE = "testCompile";
    private static final String TEST_EXECUTE = "testExecute";
    private String precompileClassDir;
    private static final String UNRECOGNIZED_ARG = "Unrecognized argument for script: ";

    public Status run(String[] stringArray, TestDescription testDescription, TestEnvironment testEnvironment) {
        Status status;
        PrintWriter printWriter = this.getTestResult().getTestCommentWriter();
        Status status2 = this.decodeArgs(stringArray);
        if (status2 != null) {
            return status2;
        }
        File[] fileArray = testDescription.getSourceFiles();
        if (this.precompileClassDir == null) {
            printWriter.println("Unconditionally compiling all sources");
            status = this.compileTogether(TEST_COMPILE, fileArray);
        } else {
            printWriter.println("Compiling sources only if necessary");
            status = this.compileIfNecessary(TEST_COMPILE, fileArray, this.precompileClassDir);
        }
        if (!status.isPassed()) {
            return status;
        }
        String string = testDescription.getParameter("executeClass");
        String string2 = testDescription.getParameter("executeArgs");
        Status status3 = this.execute(TEST_EXECUTE, string, string2);
        return status3;
    }

    private Status decodeArgs(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].equals("-precompileClassDir") || n + 1 >= stringArray.length) {
                return Status.failed(UNRECOGNIZED_ARG + stringArray[n]);
            }
            this.precompileClassDir = stringArray[++n];
            ++n;
        }
        return null;
    }
}

