/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.interview;

import com.sun.interview.ErrorQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.TreeQuestion;
import com.sun.interview.YesNoQuestion;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.WorkDirectory;

public class TestsInterview
extends Interview
implements Parameters.MutableTestsParameters {
    private YesNoQuestion qNeedTests = new YesNoQuestion(this, "needTests"){
        {
            this.setValue("No");
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "Yes") {
                return TestsInterview.this.qTests;
            }
            return TestsInterview.this.qEnd;
        }
    };
    private TreeQuestion.Model model = new TreeQuestion.Model(){

        public Object getRoot() {
            return TestsInterview.this.parent.getWorkDirectory().getTestResultTable().getRoot();
        }

        public int getChildCount(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (object instanceof TestResultTable.TreeNode) {
                return ((TestResultTable.TreeNode)object).getChildCount();
            }
            if (object instanceof TestResult) {
                return 0;
            }
            throw new IllegalArgumentException();
        }

        public Object getChild(Object object, int n) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (object instanceof TestResultTable.TreeNode) {
                return ((TestResultTable.TreeNode)object).getChild(n);
            }
            if (object instanceof TestResult) {
                return null;
            }
            throw new IllegalArgumentException();
        }

        public String getName(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (object instanceof TestResultTable.TreeNode) {
                return ((TestResultTable.TreeNode)object).getName();
            }
            if (object instanceof TestResult) {
                TestResult testResult = (TestResult)object;
                String string = testResult.getTestName();
                int n = string.lastIndexOf("/");
                return n == -1 ? string : string.substring(n + 1);
            }
            throw new IllegalArgumentException();
        }

        public String getPath(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (object instanceof TestResult) {
                return ((TestResult)object).getTestName();
            }
            if (object instanceof TestResultTable.TreeNode) {
                TestResultTable.TreeNode treeNode = (TestResultTable.TreeNode)object;
                if (treeNode.isRoot()) {
                    return treeNode.getName();
                }
                return this.getPath(treeNode.getParent() + "/" + treeNode.getName());
            }
            throw new IllegalArgumentException();
        }

        public boolean isLeaf(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (object instanceof TestResult) {
                return true;
            }
            if (object instanceof TestResultTable.TreeNode) {
                return false;
            }
            throw new IllegalArgumentException();
        }
    };
    private TreeQuestion qTests = new TreeQuestion(this, "tests", this.model){

        protected Question getNext() {
            TestsInterview.this.validateTests();
            if (TestsInterview.this.cachedTestsError != null) {
                return TestsInterview.this.cachedTestsError;
            }
            return TestsInterview.this.qEnd;
        }
    };
    private Question qNoTestsError = new ErrorQuestion(this, "noTests");
    private ErrorQuestion qBadTestsError = new ErrorQuestion(this, "badTests"){

        protected Object[] getTextArgs() {
            return TestsInterview.this.cachedTestsErrorArgs;
        }
    };
    private String[] cachedTestsValue;
    private Question cachedTestsError;
    private Object[] cachedTestsErrorArgs;
    private Question qEnd = new FinalQuestion(this);
    private InterviewParameters parent;

    public TestsInterview(InterviewParameters interviewParameters) throws Interview.Fault {
        super(interviewParameters, "tests");
        this.parent = interviewParameters;
        this.setResourceBundle("i18n");
        this.setHelpSet("/com/sun/javatest/moreInfo/moreInfo.hs");
        this.setFirstQuestion(this.qNeedTests);
    }

    public String[] getTests() {
        if (this.qNeedTests.getValue() == "Yes") {
            return this.qTests.getValue();
        }
        return null;
    }

    public void setTests(String[] stringArray) {
        if (stringArray == null) {
            this.setTestsMode(1);
        } else {
            this.setTestsMode(2);
            this.setSpecifiedTests(stringArray);
        }
    }

    public int getTestsMode() {
        return this.qNeedTests.getValue() == "Yes" ? 2 : 1;
    }

    public void setTestsMode(int n) {
        switch (n) {
            case 1: {
                this.qNeedTests.setValue("No");
                break;
            }
            case 2: {
                this.qNeedTests.setValue("Yes");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public String[] getSpecifiedTests() {
        return this.qTests.getValue();
    }

    public void setSpecifiedTests(String[] stringArray) {
        this.qTests.setValue(stringArray);
    }

    private void validateTests() {
        String[] stringArray = this.qTests.getValue();
        if (TestsInterview.equal(stringArray, this.cachedTestsValue)) {
            return;
        }
        this.cachedTestsValue = stringArray;
        this.cachedTestsError = null;
        WorkDirectory workDirectory = this.parent.getWorkDirectory();
        if (workDirectory == null) {
            return;
        }
        TestResultTable testResultTable = workDirectory.getTestResultTable();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (!testResultTable.validatePath(stringArray[n])) {
                this.cachedTestsError = this.qBadTestsError;
                this.cachedTestsErrorArgs = new Object[]{stringArray[n]};
                return;
            }
            ++n;
        }
    }

    private static boolean equal(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null) {
            return stringArray == stringArray2;
        }
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != stringArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

