/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.interview;

import com.sun.interview.ChoiceQuestion;
import com.sun.interview.DirectoryFileFilter;
import com.sun.interview.ErrorQuestion;
import com.sun.interview.ExtensionFileFilter;
import com.sun.interview.FileFilter;
import com.sun.interview.FileListQuestion;
import com.sun.interview.FileQuestion;
import com.sun.interview.Interview;
import com.sun.interview.NullQuestion;
import com.sun.interview.Question;
import com.sun.interview.StringQuestion;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.interview.DefaultInterviewParameters;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class SimpleInterviewParameters
extends DefaultInterviewParameters
implements Parameters.EnvParameters {
    private Question qPrecompile = new NullQuestion(this, "precompile"){

        public Question getNext() {
            return SimpleInterviewParameters.this.qEnvEnd;
        }

        public void export(Map map) {
            map.put("script.mode", "precompile");
            map.put("command.compile.java", System.getProperty("command.compile.java"));
        }
    };
    private Question qDeveloper = new NullQuestion(this, "developer"){

        public Question getNext() {
            return SimpleInterviewParameters.this.qName;
        }

        public void export(Map map) {
            map.put("script.mode", "developer");
            map.put("command.compile.java", System.getProperty("command.compile.java"));
        }
    };
    private StringQuestion qName = new StringQuestion(this, "name"){

        public Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return SimpleInterviewParameters.this.qDesc;
        }
    };
    private Question qDesc = new StringQuestion(this, "desc"){

        public Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return SimpleInterviewParameters.this.qCmdType;
        }

        public void export(Map map) {
            map.put("description", String.valueOf(this.value));
        }
    };
    private static final String AGENT = "agent";
    private static final String OTHER_VM = "otherVM";
    private Question qCmdType = new ChoiceQuestion(this, "cmdType"){
        {
            this.setChoices(new String[]{null, SimpleInterviewParameters.OTHER_VM, SimpleInterviewParameters.AGENT}, true);
        }

        public Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            if (this.value.equals(SimpleInterviewParameters.OTHER_VM)) {
                return SimpleInterviewParameters.this.qJVM;
            }
            return SimpleInterviewParameters.this.qEnvEnd;
        }

        public void export(Map map) {
            String string = this.value != null && this.value.equals(SimpleInterviewParameters.OTHER_VM) ? SimpleInterviewParameters.this.getOtherVMExecuteCommand() : "com.sun.javatest.agent.AgentCommand com.sun.javatest.lib.ExecStdTestSameJVMCmd $testExecuteClass $testExecuteArgs";
            map.put("command.execute", string);
        }
    };
    private FileQuestion qJVM = new FileQuestion(this, "jvm"){

        public Question getNext() {
            if (this.value == null || this.value.getPath().length() == 0) {
                return null;
            }
            if (!(this.value.exists() && this.value.isFile() && this.value.canRead())) {
                return SimpleInterviewParameters.this.qBadJVM;
            }
            return SimpleInterviewParameters.this.qClassPath;
        }
    };
    private Question qBadJVM = new ErrorQuestion(this, "badJVM"){

        public Object[] getTextArgs() {
            return new Object[]{SimpleInterviewParameters.this.qJVM.getValue().getPath()};
        }
    };
    private FileListQuestion qClassPath = new FileListQuestion(this, "classPath"){
        {
            FileFilter[] fileFilterArray = new FileFilter[]{new DirectoryFileFilter("Directories"), new ExtensionFileFilter(".zip", "ZIP Files"), new ExtensionFileFilter(".jar", "JAR Files")};
            this.setFilters(fileFilterArray);
        }

        public Question getNext() {
            return SimpleInterviewParameters.this.qEnvEnd;
        }
    };
    private Question qEnvEnd = new NullQuestion(this, "envEnd"){

        public Question getNext() {
            return SimpleInterviewParameters.this.getEnvSuccessorQuestion();
        }
    };
    private static final int PRECOMPILE = 1;
    private static final int CERTIFY = 2;
    private static final int DEVELOPER = 3;
    private int mode;

    public SimpleInterviewParameters() throws Interview.Fault {
        super("simple");
        this.setHelpSet("/com/sun/javatest/moreInfo/moreInfo.hs");
        this.setResourceBundle("i18n");
        this.mode = 2;
        String string = System.getProperty("SimpleInterviewParameters.mode");
        if (string != null) {
            if (string.equals("developer")) {
                this.mode = 3;
            } else if (string.equals("precompile")) {
                this.mode = 1;
            }
        }
    }

    public TestEnvironment getEnv() {
        HashMap hashMap = new HashMap();
        this.export(hashMap);
        try {
            String string = this.qName.getValue();
            if (string == null || string.length() == 0) {
                string = "unknown";
            }
            return new TestEnvironment(string, hashMap, "configuration interview");
        }
        catch (TestEnvironment.Fault fault) {
            throw new Error("should not happen");
        }
    }

    public Parameters.EnvParameters getEnvParameters() {
        return this;
    }

    public Question getEnvFirstQuestion() {
        switch (this.mode) {
            case 1: {
                return this.qPrecompile;
            }
            case 3: {
                return this.qDeveloper;
            }
        }
        return this.qName;
    }

    private String getOtherVMExecuteCommand() {
        char c = File.separatorChar;
        char c2 = File.pathSeparatorChar;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("com.sun.javatest.lib.ExecStdTestOtherJVMCmd ");
        File file = this.qJVM.getValue();
        stringBuffer.append(file == null ? "unknown_jvm" : file.getPath());
        File[] fileArray = this.qClassPath.getValue();
        if (fileArray != null && fileArray.length > 0) {
            stringBuffer.append(" -classpath ");
            int n = 0;
            while (n < fileArray.length) {
                if (n > 0) {
                    stringBuffer.append(File.pathSeparator);
                }
                stringBuffer.append(fileArray[n]);
                ++n;
            }
        }
        stringBuffer.append(" $testExecuteClass $testExecuteArgs");
        return stringBuffer.toString();
    }
}

