/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.interview;

import com.sun.interview.ErrorQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.StringQuestion;
import com.sun.interview.YesNoQuestion;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Keywords;
import com.sun.javatest.KeywordsFilter;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestFilter;
import com.sun.javatest.util.StringArray;
import java.util.Map;

public class KeywordsInterview
extends Interview
implements Parameters.MutableKeywordsParameters {
    private YesNoQuestion qNeedKeywords = new YesNoQuestion(this, "needKeywords"){
        {
            this.setValue("No");
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "Yes") {
                return KeywordsInterview.this.qKeywords;
            }
            return KeywordsInterview.this.qEnd;
        }
    };
    private KeywordsQuestion qKeywords = new KeywordsQuestion(this, "keywords"){

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            KeywordsInterview.this.updateCachedKeywordsData();
            if (KeywordsInterview.this.cachedKeywordsError != null) {
                return KeywordsInterview.this.qKeywordsError;
            }
            return KeywordsInterview.this.qEnd;
        }
    };
    private Keywords cachedKeywords;
    private String cachedKeywords_expr;
    private String cachedKeywordsError;
    private TestFilter cachedKeywordsFilter;
    private ErrorQuestion qKeywordsError = new ErrorQuestion(this, "keywordsError"){

        protected Object[] getTextArgs() {
            return new Object[]{KeywordsInterview.this.cachedKeywordsError};
        }
    };
    private Question qEnd = new FinalQuestion(this);
    private InterviewParameters parent;

    public KeywordsInterview(InterviewParameters interviewParameters) throws Interview.Fault {
        super(interviewParameters, "keywords");
        this.parent = interviewParameters;
        this.setResourceBundle("i18n");
        this.setHelpSet("/com/sun/javatest/moreInfo/moreInfo.hs");
        this.setFirstQuestion(this.qNeedKeywords);
    }

    public Keywords getKeywords() {
        if (this.qNeedKeywords.getValue() == "Yes") {
            this.updateCachedKeywordsData();
            return this.cachedKeywords;
        }
        return null;
    }

    public void setKeywords(int n, String string) {
        if (string == null) {
            this.setKeywordsMode(1);
        } else {
            this.setKeywordsMode(2);
            this.setMatchKeywords(n, string);
        }
    }

    public int getKeywordsMode() {
        return this.qNeedKeywords.getValue() == "Yes" ? 2 : 1;
    }

    public void setKeywordsMode(int n) {
        this.qNeedKeywords.setValue(n == 2 ? "Yes" : "No");
    }

    public int getMatchKeywordsMode() {
        return this.qKeywords.getMode();
    }

    public String getMatchKeywordsValue() {
        return this.qKeywords.getModeValue();
    }

    public void setMatchKeywords(int n, String string) {
        this.qKeywords.setValue(n, string);
    }

    public TestFilter getKeywordFilter() {
        if (this.qNeedKeywords.getValue() == "Yes") {
            this.updateCachedKeywordsData();
            return this.cachedKeywordsFilter;
        }
        return null;
    }

    private void updateCachedKeywordsData() {
        String string = this.qKeywords.getValue();
        if (!KeywordsInterview.equal(this.cachedKeywords_expr, string)) {
            try {
                Keywords keywords;
                int n = this.qKeywords.getMode();
                String string2 = n == 1 ? "any of" : (n == 2 ? "all of" : "expr");
                this.cachedKeywords = keywords = Keywords.create(string2, this.qKeywords.getModeValue());
                this.cachedKeywordsFilter = new KeywordsFilter(keywords);
                this.cachedKeywordsError = null;
            }
            catch (Keywords.Fault fault) {
                this.cachedKeywords = null;
                this.cachedKeywordsFilter = null;
                this.cachedKeywordsError = fault.getMessage();
            }
            this.cachedKeywords_expr = string;
        }
    }

    private static boolean equal(String string, String string2) {
        return string == null ? string2 == null : string.equals(string2);
    }

    private static abstract class KeywordsQuestion
    extends StringQuestion {
        private int mode;
        private String modeValue;

        KeywordsQuestion(Interview interview, String string) {
            super(interview, string);
        }

        public int getMode() {
            return this.mode;
        }

        public String getModeValue() {
            return this.modeValue;
        }

        public void setValue(int n, String string) {
            switch (n) {
                case 1: {
                    this.mode = 1;
                    this.modeValue = string;
                    super.setValue(this.termsToExpr(string, " | "));
                    break;
                }
                case 2: {
                    this.mode = 2;
                    this.modeValue = string;
                    super.setValue(this.termsToExpr(string, " & "));
                    break;
                }
                default: {
                    this.mode = 3;
                    this.modeValue = string;
                    super.setValue(string == null || string.length() == 0 ? null : string);
                }
            }
        }

        public void setValue(String string) {
            if (string != null && string.equals(this.getValue())) {
                return;
            }
            this.mode = 3;
            this.modeValue = string;
            super.setValue(this.modeValue);
        }

        public void load(Map map) {
            Object v = map.get(this.tag + ".mode");
            Object v2 = map.get(this.tag + ".value");
            if (v == null) {
                super.load(map);
            } else if (v instanceof String && (v2 == null || v2 instanceof String)) {
                String string = (String)v;
                String string2 = (String)v2;
                if (string.equals("allOf")) {
                    this.setValue(2, string2);
                } else if (string.equals("anyOf")) {
                    this.setValue(1, string2);
                } else {
                    this.setValue(3, string2);
                }
            }
        }

        public void save(Map map) {
            super.save(map);
            String string = this.mode == 1 ? "anyOf" : (this.mode == 2 ? "allOf" : "expr");
            map.put(this.tag + ".mode", string);
            if (this.modeValue != null) {
                map.put(this.tag + ".value", this.modeValue);
            }
        }

        private String termsToExpr(String string, String string2) {
            if (string == null || string.length() == 0) {
                return null;
            }
            String[] stringArray = StringArray.split(string);
            StringBuffer stringBuffer = new StringBuffer(string.length());
            int n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    stringBuffer.append(string2);
                }
                stringBuffer.append(stringArray[n]);
                ++n;
            }
            return stringBuffer.toString();
        }
    }
}

