/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.interview;

import com.sun.interview.ErrorQuestion;
import com.sun.interview.ExtensionFileFilter;
import com.sun.interview.FileListQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.StringQuestion;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestEnvContext;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestSuite;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;

public class EnvironmentInterview
extends Interview
implements Parameters.LegacyEnvParameters {
    private FileListQuestion qEnvFiles = new FileListQuestion(this, "envFiles"){
        {
            this.setFilter(new ExtensionFileFilter(".jte", "Environment File"));
        }

        public File getBaseDirectory() {
            TestSuite testSuite = EnvironmentInterview.this.parent.getTestSuite();
            if (testSuite == null) {
                return null;
            }
            File file = testSuite.getRoot();
            return file.isDirectory() ? file : file.getParentFile();
        }

        protected Question getNext() {
            EnvironmentInterview.this.updateCachedEnvTable();
            if (EnvironmentInterview.this.cachedEnvTableError != null) {
                return EnvironmentInterview.this.qEnvTableError;
            }
            if (EnvironmentInterview.this.cachedEnvTable == null || EnvironmentInterview.this.cachedEnvTable.getEnvNames().length == 0) {
                return EnvironmentInterview.this.qNoEnvs;
            }
            return EnvironmentInterview.this.qEnv;
        }
    };
    private TestEnvContext cachedEnvTable;
    private File[] cachedEnvTable_absFiles;
    private String cachedEnvTableError;
    private ErrorQuestion qNoEnvs = new ErrorQuestion(this, "noEnvs");
    private ErrorQuestion qEnvTableError = new ErrorQuestion(this, "envTableError"){

        protected Object[] getTextArgs() {
            return new Object[]{EnvironmentInterview.this.cachedEnvTableError};
        }
    };
    private StringQuestion qEnv = new StringQuestion(this, "env"){
        private TestEnvContext cachedEnvTable;

        public String[] getSuggestions() {
            TestEnvContext testEnvContext = EnvironmentInterview.this.getEnvTable();
            if (testEnvContext != this.cachedEnvTable) {
                Object[] objectArray;
                if (testEnvContext == null) {
                    objectArray = new String[]{};
                } else {
                    Object[] objectArray2 = testEnvContext.getEnvMenuNames();
                    Arrays.sort(objectArray2);
                    objectArray = objectArray2;
                }
                this.setSuggestions((String[])objectArray);
                this.cachedEnvTable = testEnvContext;
            }
            return super.getSuggestions();
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            EnvironmentInterview.this.updateCachedEnv();
            if (EnvironmentInterview.this.cachedEnv == null) {
                return EnvironmentInterview.this.cachedEnvError;
            }
            return EnvironmentInterview.this.qEnd;
        }
    };
    private TestEnvironment cachedEnv;
    private TestEnvContext cachedEnv_envTable;
    private String cachedEnv_envName;
    private Question cachedEnvError;
    private Object[] cachedEnvErrorArgs;
    private ErrorQuestion qEnvError = new ErrorQuestion(this, "envError"){

        protected Object[] getTextArgs() {
            return EnvironmentInterview.this.cachedEnvErrorArgs;
        }
    };
    private ErrorQuestion qEnvNotFound = new ErrorQuestion(this, "envNotFound"){

        protected Object[] getTextArgs() {
            return EnvironmentInterview.this.cachedEnvErrorArgs;
        }
    };
    private ErrorQuestion qEnvUndefinedEntry = new ErrorQuestion(this, "envUndefinedEntry"){

        protected Object[] getTextArgs() {
            return EnvironmentInterview.this.cachedEnvErrorArgs;
        }
    };
    private Question qEnd = new FinalQuestion(this);
    private InterviewParameters parent;

    public EnvironmentInterview(InterviewParameters interviewParameters) throws Interview.Fault {
        super(interviewParameters, "environment");
        this.parent = interviewParameters;
        this.setResourceBundle("i18n");
        this.setHelpSet("/com/sun/javatest/moreInfo/moreInfo.hs");
        this.setFirstQuestion(this.qEnvFiles);
    }

    public File[] getEnvFiles() {
        return this.qEnvFiles.getValue();
    }

    public File[] getAbsoluteEnvFiles() {
        return EnvironmentInterview.getAbsoluteFiles(this.parent.getTestSuite().getRootDir(), this.getEnvFiles());
    }

    public void setEnvFiles(File[] fileArray) {
        this.qEnvFiles.setValue(fileArray);
    }

    public String getEnvName() {
        return this.qEnv.getValue();
    }

    public void setEnvName(String string) {
        this.qEnv.setValue(string);
    }

    public TestEnvironment getEnv() {
        this.updateCachedEnv();
        return this.cachedEnv;
    }

    private TestEnvContext getEnvTable() {
        this.updateCachedEnvTable();
        return this.cachedEnvTable;
    }

    private void updateCachedEnvTable() {
        File[] fileArray = this.getAbsoluteEnvFiles();
        if (!EnvironmentInterview.equal(this.cachedEnvTable_absFiles, fileArray)) {
            try {
                this.cachedEnvTable = new TestEnvContext(fileArray);
                this.cachedEnvTableError = null;
            }
            catch (TestEnvContext.Fault fault) {
                this.cachedEnvTable = null;
                this.cachedEnvTableError = fault.getMessage();
            }
            this.cachedEnvTable_absFiles = fileArray;
        }
    }

    private void updateCachedEnv() {
        TestEnvContext testEnvContext = this.getEnvTable();
        String string = this.getEnvName();
        if (this.cachedEnv_envTable != testEnvContext || !EnvironmentInterview.equal(this.cachedEnv_envName, string)) {
            try {
                if (testEnvContext == null || string == null || string.length() == 0) {
                    this.cachedEnv = null;
                    this.cachedEnvError = null;
                } else {
                    this.cachedEnv = testEnvContext.getEnv(string);
                    if (this.cachedEnv == null) {
                        this.cachedEnvError = this.qEnvNotFound;
                        this.cachedEnvErrorArgs = new Object[]{string};
                    } else {
                        this.cachedEnvError = null;
                        this.cachedEnvErrorArgs = null;
                        Iterator iterator = this.cachedEnv.elements().iterator();
                        while (iterator.hasNext() && this.cachedEnvError == null) {
                            TestEnvironment.Element element = (TestEnvironment.Element)iterator.next();
                            if (element.getValue().indexOf("VALUE_NOT_DEFINED") < 0) continue;
                            this.cachedEnv = null;
                            String string2 = (element.getDefinedInEnv() == null ? "" : "env." + element.getDefinedInEnv() + ".") + element.getKey() + "=" + element.getValue();
                            this.cachedEnvError = this.qEnvUndefinedEntry;
                            this.cachedEnvErrorArgs = new Object[]{string2, element.getDefinedInFile()};
                        }
                    }
                }
            }
            catch (TestEnvironment.Fault fault) {
                this.cachedEnv = null;
                this.cachedEnvError = this.qEnvError;
                this.cachedEnvErrorArgs = new Object[]{fault.getMessage()};
            }
            this.cachedEnv_envTable = testEnvContext;
            this.cachedEnv_envName = string;
        }
    }

    private static File[] getAbsoluteFiles(File file, File[] fileArray) {
        if (fileArray == null) {
            return null;
        }
        boolean bl = true;
        int n = 0;
        while (n < fileArray.length && bl) {
            bl = fileArray[n].isAbsolute();
            ++n;
        }
        if (bl) {
            return fileArray;
        }
        File[] fileArray2 = new File[fileArray.length];
        int n2 = 0;
        while (n2 < fileArray.length) {
            File file2 = fileArray[n2];
            fileArray2[n2] = file2.isAbsolute() ? file2 : new File(file, file2.getPath());
            ++n2;
        }
        return fileArray2;
    }

    private static boolean equal(File file, File file2) {
        return file == null ? file2 == null : file.equals(file2);
    }

    private static boolean equal(File[] fileArray, File[] fileArray2) {
        if (fileArray == null || fileArray2 == null) {
            return fileArray == fileArray2;
        }
        if (fileArray.length != fileArray2.length) {
            return false;
        }
        int n = 0;
        while (n < fileArray.length) {
            if (!EnvironmentInterview.equal(fileArray[n], fileArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static boolean equal(String string, String string2) {
        return string == null ? string2 == null : string.equals(string2);
    }
}

