/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.httpd;

import com.sun.javatest.httpd.JThttpProvider;
import com.sun.javatest.httpd.RootRegistry;
import com.sun.javatest.httpd.httpURL;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Hashtable;

class RequestHandler
implements Runnable {
    private static Hashtable urlMap;
    private Socket soc;
    private PrintWriter out;
    private LineNumberReader in;
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final String BAD_METHOD = "405 Method Not Allowed";
    private static final String HTTP_CONTENT_TYPE = "Content-Type: ";
    private static final String HTTP_CONTENT_HTML = "Content-Type: text/html";
    private static I18NResourceBundle i18n;
    protected static boolean debug;
    static /* synthetic */ Class class$com$sun$javatest$httpd$RequestHandler;

    public RequestHandler(Socket socket) {
        this.soc = socket;
    }

    public void run() {
        Object object;
        String string = null;
        try {
            if (debug) {
                object = new StringBuffer();
                object.append("Handling request from ");
                object.append(this.soc.getInetAddress().getHostName());
                object.append(" (");
                object.append(this.soc.getInetAddress().getHostAddress());
                object.append(")");
                System.out.println(object.toString());
                object.setLength(0);
            }
            this.out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.soc.getOutputStream())));
            this.in = new LineNumberReader(new InputStreamReader(this.soc.getInputStream()));
            string = this.in.readLine();
            if (debug) {
                System.out.println("-------------");
                System.out.println("RH-Full request:");
                System.out.println(string);
            }
            while (debug && this.in.ready()) {
                object = this.in.readLine();
                System.out.println((String)object);
            }
            if (debug) {
                System.out.println("-------------");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        object = StringArray.split(string);
        if (debug) {
            System.out.print("Decode: " + string);
            System.out.println(" -> " + ((String[])object).length + " params.");
        }
        if (object == null || ((String[])object).length < 3) {
            if (debug) {
                System.err.println("RH-HTTP request too short.");
            }
            return;
        }
        if (object[0].equalsIgnoreCase(GET)) {
            if (debug) {
                System.out.println("RH-Processing HTTP GET request.");
            }
            this.doGet((String[])object);
        } else if (object[0].equalsIgnoreCase(POST)) {
            if (debug) {
                System.out.println("RH-Processing HTTP POST request.");
            }
            this.doPost((String[])object);
        } else {
            if (debug) {
                System.err.println("RH-Unsupported request method: " + object[0]);
            }
            this.error(this.out, BAD_METHOD, object[0] + " is an unsupported request method. " + BAD_METHOD);
            this.out.close();
            return;
        }
    }

    protected void doGet(String[] stringArray) {
        if (debug) {
            System.out.println("RH-Get processing URL: \"" + stringArray[1] + "\"");
        }
        httpURL httpURL2 = new httpURL(stringArray[1]);
        JThttpProvider jThttpProvider = RootRegistry.getInstance().getHandler(httpURL2);
        if (jThttpProvider != null) {
            jThttpProvider.serviceRequest(httpURL2, this.out);
        } else if (debug) {
            System.out.println("No handler found for: " + stringArray[1]);
        }
    }

    protected void doPost(String[] stringArray) {
    }

    protected void notFound(String[] stringArray) {
    }

    private void error(PrintWriter printWriter, String string, String string2) {
        printWriter.print("HTTP/1.1 ");
        printWriter.println(string);
        printWriter.println(HTTP_CONTENT_HTML);
        printWriter.print("<html><head><title>");
        printWriter.print(string);
        printWriter.println("</title></head><body>");
        printWriter.print(i18n.getString("handler.err.txt"));
        printWriter.println("<br>");
        printWriter.println(string);
        printWriter.println("</body></html>");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$httpd$RequestHandler == null ? (class$com$sun$javatest$httpd$RequestHandler = RequestHandler.class$("com.sun.javatest.httpd.RequestHandler")) : class$com$sun$javatest$httpd$RequestHandler);
        debug = Boolean.getBoolean("debug." + (class$com$sun$javatest$httpd$RequestHandler == null ? (class$com$sun$javatest$httpd$RequestHandler = RequestHandler.class$("com.sun.javatest.httpd.RequestHandler")) : class$com$sun$javatest$httpd$RequestHandler).getName());
    }
}

