/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.finder;

import com.sun.javatest.TestFinder;
import com.sun.javatest.finder.CommentStream;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TagTestFinder
extends TestFinder {
    private File currFile;
    private HashMap excludeList = new HashMap();
    private HashMap extensionTable = new HashMap();
    private boolean fastScan = false;
    private String initialTag = "test";
    private static final String[] excludeNames = new String[]{"SCCS", "deleted_files"};
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$finder$TagTestFinder == null ? (class$com$sun$javatest$finder$TagTestFinder = TagTestFinder.class$("com.sun.javatest.finder.TagTestFinder")) : class$com$sun$javatest$finder$TagTestFinder);
    static /* synthetic */ Class class$com$sun$javatest$finder$JavaCommentStream;
    static /* synthetic */ Class class$com$sun$javatest$finder$CommentStream;
    static /* synthetic */ Class class$com$sun$javatest$finder$TagTestFinder;

    public TagTestFinder() {
        this.exclude(excludeNames);
        this.addExtension(".java", class$com$sun$javatest$finder$JavaCommentStream == null ? (class$com$sun$javatest$finder$JavaCommentStream = TagTestFinder.class$("com.sun.javatest.finder.JavaCommentStream")) : class$com$sun$javatest$finder$JavaCommentStream);
    }

    protected int decodeArg(String[] stringArray, int n) throws TestFinder.Fault {
        if ("-fast".equalsIgnoreCase(stringArray[n])) {
            this.fastScan = true;
            return 1;
        }
        return super.decodeArg(stringArray, n);
    }

    public void scan(File file) {
        this.currFile = file;
        if (file.isDirectory()) {
            this.scanDirectory(file);
        } else {
            this.scanFile(file);
        }
    }

    protected File getCurrentFile() {
        return this.currFile;
    }

    public void exclude(String string) {
        this.excludeList.put(string, string);
    }

    public void exclude(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            this.excludeList.put(string, string);
            ++n;
        }
    }

    public void addExtension(String string, Class clazz) {
        if (!string.startsWith(".")) {
            throw new IllegalArgumentException("extension must begin with `.'");
        }
        if (!(class$com$sun$javatest$finder$CommentStream == null ? (class$com$sun$javatest$finder$CommentStream = TagTestFinder.class$("com.sun.javatest.finder.CommentStream")) : class$com$sun$javatest$finder$CommentStream).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("class must be a subtype of " + (class$com$sun$javatest$finder$CommentStream == null ? (class$com$sun$javatest$finder$CommentStream = TagTestFinder.class$("com.sun.javatest.finder.CommentStream")) : class$com$sun$javatest$finder$CommentStream).getName());
        }
        this.extensionTable.put(string, clazz);
    }

    public Class getClassForExtension(String string) {
        return (Class)this.extensionTable.get(string);
    }

    public void setInitialTag(String string) {
        this.initialTag = string;
    }

    public String getInitialTag() {
        return this.initialTag;
    }

    private void scanDirectory(File file) {
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (!this.excludeList.containsKey(string)) {
                File file2 = new File(file, string);
                if (file2.isDirectory()) {
                    this.foundFile(file2);
                } else {
                    String string2;
                    int n2 = string.indexOf(46);
                    if (n2 != -1 && this.extensionTable.containsKey(string2 = string.substring(n2))) {
                        this.foundFile(file2);
                    }
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void scanFile(File file) {
        block19: {
            String string;
            int n = 0;
            String string2 = file.getName();
            int n2 = string2.indexOf(46);
            if (n2 == -1) {
                return;
            }
            String string3 = string2.substring(n2);
            Class clazz = (Class)this.extensionTable.get(string3);
            if (clazz == null) {
                this.error(i18n, "tag.noParser", new Object[]{file, string3});
                return;
            }
            CommentStream commentStream = null;
            try {
                commentStream = (CommentStream)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                this.error(i18n, "tag.cantCreateClass", new Object[]{clazz.getName(), string3});
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                this.error(i18n, "tag.cantAccessClass", new Object[]{clazz.getName(), string3});
                return;
            }
            commentStream.init(new BufferedReader(new FileReader(file)));
            if (this.fastScan) {
                commentStream.setFastScan(true);
            }
            while ((string = commentStream.readComment()) != null) {
                Map map = this.parseComment(string, file);
                if (map.isEmpty()) continue;
                if (map.get("id") == null) {
                    if (n != 0) {
                        map.put("id", "id" + new Integer(n).toString());
                    }
                    ++n;
                }
                map.remove("test");
                this.foundTestDescription(map, file, 0);
            }
            Object var11_14 = null;
            try {
                commentStream.close();
            }
            catch (IOException iOException) {}
            break block19;
            {
                catch (FileNotFoundException fileNotFoundException) {
                    this.error(i18n, "tag.cantFindFile", file);
                    Object var11_15 = null;
                    try {
                        commentStream.close();
                    }
                    catch (IOException iOException) {}
                    break block19;
                }
                catch (IOException iOException) {
                    this.error(i18n, "tag.ioError", file);
                    Object var11_16 = null;
                    try {
                        commentStream.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                try {
                    commentStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    protected Map parseComment(String string, File file) {
        HashMap hashMap = new HashMap();
        int n = 0;
        int n2 = 0;
        while ((n = this.findTagStart(string, n2)) != -1) {
            n2 = this.findTagEnd(string, n);
            String string2 = string.substring(n, n2);
            int n3 = 0;
            while (n3 < string2.length() && !Character.isWhitespace(string2.charAt(n3))) {
                ++n3;
            }
            String string3 = string2.substring(1, n3);
            while (n3 < string2.length() && Character.isWhitespace(string2.charAt(n3))) {
                ++n3;
            }
            String string4 = string2.substring(n3);
            string4 = string4.replace('\n', ' ').replace('\r', ' ').trim();
            if (hashMap.isEmpty() && this.initialTag != null && !string3.equals(this.initialTag)) {
                return hashMap;
            }
            this.processEntry(hashMap, string3, string4);
        }
        return hashMap;
    }

    private int findTagStart(String string, int n) {
        while ((n = string.indexOf("@", n)) != -1 && n < string.length() - 1) {
            if (n == 0 && !Character.isWhitespace(string.charAt(n + 1)) || n > 0 && !Character.isWhitespace(string.charAt(n + 1)) && Character.isWhitespace(string.charAt(n - 1))) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private int findTagEnd(String string, int n) {
        int n2 = this.findTagStart(string, n + 1);
        if (n2 == -1) {
            return string.length();
        }
        return n2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

