/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.finder;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFinder;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;

public class ShowTests {
    private TestFinder testFinder;
    private PrintStream out;
    private boolean nodes;
    private boolean fullTests;
    static /* synthetic */ Class class$com$sun$javatest$finder$ShowTests;

    public static void main(String[] stringArray) {
        block5: {
            try {
                if (stringArray.length == 0) {
                    ShowTests.usage(System.out);
                    break block5;
                }
                ShowTests showTests = new ShowTests();
                showTests.run(stringArray);
            }
            catch (BadArgs badArgs) {
                System.err.println("Bad Arguments: " + badArgs.getMessage());
                ShowTests.usage(System.err);
                System.exit(1);
            }
            catch (Fault fault) {
                System.err.println("Error: " + fault.getMessage());
                System.exit(2);
            }
            catch (IOException iOException) {
                System.err.println("Error: " + iOException);
                System.exit(3);
            }
        }
    }

    private static void usage(PrintStream printStream) {
        String string = System.getProperty("program", "java " + (class$com$sun$javatest$finder$ShowTests == null ? (class$com$sun$javatest$finder$ShowTests = ShowTests.class$("com.sun.javatest.finder.ShowTests")) : class$com$sun$javatest$finder$ShowTests).getName());
        printStream.println("Usage:");
        printStream.println("  " + string + "[options]  test-suite");
        printStream.println("Options:");
        printStream.println("  -finder finderClass finderArgs... -end");
        printStream.println("                          specify the test finder to be used");
        printStream.println("  -initial initial-file   specify a starting point (optional)");
        printStream.println("  -o output-file          output file (default is standard output)");
        printStream.println("  -nodes                  show nodes in the tree");
        printStream.println("  -fulltests              show contents of tests");
    }

    public void run(String[] stringArray) throws BadArgs, Fault, IOException {
        File file = null;
        String string = null;
        String[] stringArray2 = null;
        File file2 = null;
        File file3 = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase("-finder") && n + 1 < stringArray.length) {
                string = stringArray[++n];
                int n2 = ++n;
                while (n < stringArray.length - 1 && !stringArray[n].equalsIgnoreCase("-end")) {
                    ++n;
                }
                stringArray2 = new String[n - n2];
                System.arraycopy(stringArray, n2, stringArray2, 0, stringArray2.length);
            } else if (stringArray[n].equalsIgnoreCase("-initial") && n + 1 < stringArray.length) {
                file3 = new File(stringArray[++n]);
            } else if (stringArray[n].equalsIgnoreCase("-o") && n + 1 < stringArray.length) {
                file2 = new File(stringArray[++n]);
            } else if (stringArray[n].equalsIgnoreCase("-nodes")) {
                this.nodes = true;
            } else if (stringArray[n].equalsIgnoreCase("-fulltests")) {
                this.fullTests = true;
            } else {
                if (stringArray[n].startsWith("-")) {
                    throw new BadArgs(stringArray[n]);
                }
                file = new File(stringArray[n]);
            }
            ++n;
        }
        if (string == null) {
            throw new BadArgs("no test finder specified");
        }
        if (file == null) {
            throw new BadArgs("testsuite.html file not specified");
        }
        this.testFinder = this.initializeTestFinder(string, stringArray2, file);
        if (file3 == null) {
            file3 = this.testFinder.getRoot();
        }
        this.out = file2 == null ? System.out : new PrintStream(new BufferedOutputStream(new FileOutputStream(file2)));
        this.list(file3);
    }

    private TestFinder initializeTestFinder(String string, String[] stringArray, File file) throws Fault {
        TestFinder testFinder;
        try {
            Class<?> clazz = Class.forName(string);
            testFinder = (TestFinder)clazz.newInstance();
            testFinder.init(stringArray, file, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Fault("Error: Can't find class for TestFinder specified");
        }
        catch (InstantiationException instantiationException) {
            throw new Fault("Error: Can't create new instance of TestFinder");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Fault("Error: Illegal Access Exception");
        }
        catch (TestFinder.Fault fault) {
            throw new Fault("Error: Can't initialize test-finder: " + fault.getMessage());
        }
        return testFinder;
    }

    private void list(File file) {
        int n;
        if (this.nodes) {
            this.out.println(file);
        }
        this.testFinder.read(file);
        TestDescription[] testDescriptionArray = this.testFinder.getTests();
        File[] fileArray = this.testFinder.getFiles();
        if (testDescriptionArray != null) {
            n = 0;
            while (n < testDescriptionArray.length) {
                TestDescription testDescription = testDescriptionArray[n];
                this.out.println("    " + testDescription.getRootRelativeURL());
                if (this.fullTests) {
                    Iterator iterator = testDescription.getParameterKeys();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        String string2 = testDescription.getParameter(string);
                        this.out.print("        ");
                        this.out.print(string);
                        this.pad(string, 15);
                        this.out.print(string2);
                        this.out.println();
                    }
                }
                ++n;
            }
        }
        if (fileArray != null) {
            n = 0;
            while (n < fileArray.length) {
                this.list(fileArray[n]);
                ++n;
            }
        }
    }

    void pad(String string, int n) {
        int n2 = string.length();
        while (n2 < n) {
            this.out.write(32);
            ++n2;
        }
        this.out.write(32);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class Fault
    extends Exception {
        Fault(String string) {
            super(string);
        }
    }

    public class BadArgs
    extends Exception {
        BadArgs(String string) {
            super(string);
        }
    }
}

