/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.finder;

import com.sun.javatest.TestFinder;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Vector;

public class HTMLTestFinder
extends TestFinder {
    private Hashtable namesInFile = new Hashtable();
    private Hashtable excludeList = new Hashtable(excludeNames.length);
    private static final String[] excludeNames = new String[]{"SCCS", "deleted_files"};
    private Hashtable extensionTable;
    private static final String[] extensions = new String[]{".html", ".htm"};
    public static final int WEB_WALK = 1;
    public static final int DIR_WALK = 2;
    private int mode = 2;
    private boolean ignoreErrors = false;
    private File validatedRoot;
    private File currFile;
    private Reader input;
    private int c;
    private int line;
    private StringBuffer text;
    private String endTestDescriptionTag;
    private Hashtable params;
    private String defTerm;
    private Vector tableRow;
    private String lastName;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$finder$HTMLTestFinder == null ? (class$com$sun$javatest$finder$HTMLTestFinder = HTMLTestFinder.class$("com.sun.javatest.finder.HTMLTestFinder")) : class$com$sun$javatest$finder$HTMLTestFinder);
    static /* synthetic */ Class class$com$sun$javatest$finder$HTMLTestFinder;

    public HTMLTestFinder() {
        int n = 0;
        while (n < excludeNames.length) {
            this.excludeList.put(excludeNames[n], excludeNames[n]);
            ++n;
        }
        this.extensionTable = new Hashtable(extensions.length);
        int n2 = 0;
        while (n2 < extensions.length) {
            this.extensionTable.put(extensions[n2], extensions[n2]);
            ++n2;
        }
    }

    protected int decodeArg(String[] stringArray, int n) throws TestFinder.Fault {
        if (stringArray[n].equalsIgnoreCase("-webWalk")) {
            this.mode = 1;
            return 1;
        }
        if (stringArray[n].equalsIgnoreCase("-dirWalk")) {
            this.mode = 2;
            return 1;
        }
        if (stringArray[n].equalsIgnoreCase("-IGNORE-ERRORS")) {
            this.ignoreErrors = true;
            return 1;
        }
        return super.decodeArg(stringArray, n);
    }

    public File getRoot() {
        File file = super.getRoot();
        if (this.mode == 2 && file.isFile()) {
            this.validatedRoot = new File(file.getParent());
        } else {
            if (this.mode == 1 && file.isDirectory()) {
                throw new IllegalStateException(i18n.getString("html.badRootForWebWalk", file.getPath()));
            }
            this.validatedRoot = new File(file.getPath());
        }
        return this.validatedRoot;
    }

    protected void localizedError(String string) {
        if (!this.ignoreErrors) {
            super.localizedError(string);
        }
    }

    public void setMode(int n) {
        switch (n) {
            case 1: 
            case 2: {
                this.mode = n;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public int getMode() {
        return this.mode;
    }

    protected void scan(File file) {
        if (file.isDirectory()) {
            this.scanDirectory(file);
        } else {
            this.scanFile(file);
        }
    }

    private void scanDirectory(File file) {
        if (this.mode == 1) {
            return;
        }
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (!this.excludeList.containsKey(string)) {
                File file2 = new File(file, string);
                if (file2.isDirectory()) {
                    this.foundFile(file2);
                } else {
                    String string2;
                    int n2 = string.lastIndexOf(46);
                    if (n2 != -1 && this.extensionTable.containsKey(string2 = string.substring(n2))) {
                        this.foundFile(file2);
                    }
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanFile(File file) {
        this.input = null;
        this.lastName = null;
        this.namesInFile.clear();
        try {
            this.input = new BufferedReader(new FileReader(file));
            this.currFile = file;
            this.line = 1;
            this.nextCh();
            block24: while (this.c >= 0) {
                switch (this.c) {
                    case 60: {
                        String string;
                        this.nextCh();
                        this.skipSpace();
                        switch (this.c) {
                            case 33: {
                                this.nextCh();
                                if (this.c != 45) continue block24;
                                this.nextCh();
                                if (this.c != 45) continue block24;
                                this.nextCh();
                                this.skipComment();
                                break;
                            }
                            case 47: {
                                this.nextCh();
                                string = this.scanIdentifier();
                                if (string.equals("dl")) {
                                    this.endDefList();
                                } else if (string.equals("td") || string.equals("th")) {
                                    this.endTableData();
                                } else if (string.equals("tr") || string.equals("table")) {
                                    this.endTableRow();
                                }
                                this.skipTag();
                                if (!this.inTestDescription() || !string.equals(this.endTestDescriptionTag)) continue block24;
                                this.foundTestDescription(this.params, file, this.line);
                                this.params = null;
                                break;
                            }
                            default: {
                                string = this.scanIdentifier();
                                if (string.equals("a")) {
                                    this.scanLink(file);
                                    break;
                                }
                                if (string.equals("table")) {
                                    this.scanTable(file);
                                    break;
                                }
                                if (string.equals("tr")) {
                                    this.scanTableRow();
                                    break;
                                }
                                if (string.equals("td") || string.equals("th")) {
                                    this.scanTableData();
                                    break;
                                }
                                if (string.equals("dl")) {
                                    this.scanDefList(file);
                                    break;
                                }
                                if (string.equals("dt")) {
                                    this.scanDefTerm();
                                    break;
                                }
                                if (string.equals("dd")) {
                                    this.scanDefData();
                                    break;
                                }
                                this.skipTag();
                                break;
                            }
                        }
                        continue block24;
                    }
                    case 9: 
                    case 10: 
                    case 12: 
                    case 13: 
                    case 32: {
                        if (this.text != null && this.text.length() > 0 && this.text.charAt(this.text.length() - 1) != ' ') {
                            this.text.append(' ');
                        }
                        this.nextCh();
                        break;
                    }
                    case 38: {
                        String string;
                        String string2 = null;
                        this.nextCh();
                        if (this.c == 35) {
                            int n = 0;
                            this.nextCh();
                            string = "#";
                            while (48 <= this.c && this.c <= 57) {
                                string = string + (char)this.c;
                                n = n * 10 + (this.c - 48);
                                this.nextCh();
                            }
                            string2 = "" + (char)n;
                        } else {
                            string = this.scanIdentifier();
                            if (string.equals("lt")) {
                                string2 = "<";
                            } else if (string.equals("gt")) {
                                string2 = ">";
                            } else if (string.equals("amp")) {
                                string2 = "&";
                            } else if (string.equals("copy")) {
                                string2 = "\ufffd";
                            }
                            if (string2 == null) {
                                string2 = "&" + string + (char)this.c;
                            }
                        }
                        if (this.c != 59) {
                            if (!Character.isWhitespace((char)this.c)) {
                                string = string + (char)this.c;
                            }
                            this.error(i18n, "html.badEscape", new Object[]{string, file});
                        }
                        if (this.text != null) {
                            this.text.append(string2);
                        }
                        this.nextCh();
                        break;
                    }
                    default: {
                        if (this.text != null) {
                            this.text.append((char)this.c);
                        }
                        this.nextCh();
                    }
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.error(i18n, "html.cantFindFile", file);
        }
        catch (IOException iOException) {
            this.error(i18n, "html.ioError", new Object[]{file, new Integer(this.line), iOException});
        }
        finally {
            if (this.input != null) {
                try {
                    this.input.close();
                }
                catch (IOException iOException) {}
                this.input = null;
            }
        }
    }

    protected File getCurrentFile() {
        return this.currFile;
    }

    private void nextCh() throws IOException {
        this.c = this.input.read();
        if (this.c == 10) {
            ++this.line;
        }
    }

    private boolean inTestDescription() {
        return this.params != null;
    }

    private void scanTable(File file) throws IOException {
        if (TestFinder.debug) {
            System.err.println("scanning table starting in line " + this.line);
        }
        String string = this.lastName;
        this.skipSpace();
        while (this.c != 62) {
            String string2 = this.scanIdentifier();
            String string3 = this.scanValue();
            this.skipSpace();
            if (string2.equals("class") && "TestDescription".equals(string3)) {
                this.params = new Hashtable();
                this.endTestDescriptionTag = "table";
                continue;
            }
            if (!string2.equals("id")) continue;
            string = string3;
        }
        this.nextCh();
        if (this.params != null && string != null) {
            this.processEntry(this.params, "id", string);
        }
    }

    private void scanTableRow() throws IOException {
        this.skipTag();
        if (this.params != null) {
            this.endTableRow();
            this.tableRow = new Vector();
        }
    }

    private void endTableRow() throws IOException {
        if (this.params != null && this.tableRow != null) {
            this.endTableData();
            if (this.tableRow.size() == 2) {
                this.processEntry(this.params, (String)this.tableRow.elementAt(0), (String)this.tableRow.elementAt(1));
            }
            this.tableRow = null;
        }
    }

    private void scanTableData() throws IOException {
        this.skipTag();
        if (this.params != null && this.tableRow != null) {
            this.endTableData();
            this.text = new StringBuffer();
        }
    }

    private void endTableData() throws IOException {
        if (this.params != null && this.tableRow != null && this.text != null) {
            while (this.text.length() > 0 && this.text.charAt(this.text.length() - 1) == ' ') {
                this.text.setLength(this.text.length() - 1);
            }
            this.tableRow.addElement(new String(this.text));
            this.text = null;
        }
    }

    private void scanDefList(File file) throws IOException {
        String string = this.lastName;
        this.skipSpace();
        while (this.c != 62) {
            String string2 = this.scanIdentifier();
            String string3 = this.scanValue();
            this.skipSpace();
            if (string2.equals("class") && "TestDescription".equals(string3)) {
                this.params = new Hashtable();
                this.endTestDescriptionTag = "dl";
                continue;
            }
            if (!string2.equals("id")) continue;
            string = string3;
        }
        this.nextCh();
        if (this.params != null && string != null) {
            this.processEntry(this.params, "id", string);
        }
    }

    private void scanDefTerm() throws IOException {
        this.skipTag();
        if (this.params != null) {
            if (this.defTerm != null && this.text != null) {
                while (this.text.length() > 0 && this.text.charAt(this.text.length() - 1) == ' ') {
                    this.text.setLength(this.text.length() - 1);
                }
                String string = new String(this.text);
                this.processEntry(this.params, this.defTerm, string);
            }
            this.defTerm = null;
            this.text = new StringBuffer();
        }
    }

    private void scanDefData() throws IOException {
        this.skipTag();
        if (this.params != null && this.text != null) {
            while (this.text.length() > 0 && this.text.charAt(this.text.length() - 1) == ' ') {
                this.text.setLength(this.text.length() - 1);
            }
            this.defTerm = new String(this.text);
            this.text = new StringBuffer();
        }
    }

    private void endDefList() throws IOException {
        if (this.params != null) {
            if (this.defTerm != null && this.text != null) {
                while (this.text.length() > 0 && this.text.charAt(this.text.length() - 1) == ' ') {
                    this.text.setLength(this.text.length() - 1);
                }
                String string = new String(this.text);
                this.processEntry(this.params, this.defTerm, string);
            }
            this.defTerm = null;
            this.text = null;
        }
    }

    private String scanIdentifier() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            if (this.c >= 97 && this.c <= 122) {
                stringBuffer.append((char)this.c);
                this.nextCh();
                continue;
            }
            if (this.c >= 65 && this.c <= 90) {
                stringBuffer.append((char)(97 + (this.c - 65)));
                this.nextCh();
                continue;
            }
            if (this.c >= 48 && this.c <= 57) {
                stringBuffer.append((char)this.c);
                this.nextCh();
                continue;
            }
            if (this.c != 45) break;
            stringBuffer.append((char)this.c);
            this.nextCh();
        }
        if (stringBuffer.length() == 0) {
            throw new IOException("Identifier expected");
        }
        return stringBuffer.toString();
    }

    private void scanLink(File file) throws IOException {
        this.skipSpace();
        while (this.c != 62) {
            Comparable<Integer> comparable;
            String string = this.scanIdentifier();
            String string2 = this.scanValue();
            this.skipSpace();
            if (this.mode == 1 && string.equals("href") && string2.indexOf(58) == -1 && !string2.startsWith("/") && !string2.startsWith("../")) {
                int n = string2.lastIndexOf(35);
                if (n != -1) {
                    string2 = string2.substring(0, n);
                }
                string2 = string2.trim();
                comparable = new File(file.getParent(), string2.replace('/', File.separatorChar));
                String string3 = ((File)comparable).getPath();
                if (string3.endsWith(".html") || string3.endsWith(".htm")) {
                    this.foundFile((File)comparable);
                }
            }
            if (!string.equals("name")) continue;
            this.lastName = string2;
            Integer n = new Integer(this.line);
            comparable = this.namesInFile.put(string2, n);
            if (comparable == null) continue;
            this.error(i18n, "html.multipleName", new Object[]{string2, file, n, comparable});
        }
        this.nextCh();
    }

    private String scanValue() throws IOException {
        this.skipSpace();
        if (this.c != 61) {
            return "";
        }
        int n = -1;
        this.nextCh();
        this.skipSpace();
        if (this.c == 39 || this.c == 34) {
            n = this.c;
            this.nextCh();
            this.skipSpace();
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n < 0 && this.c != 32 && this.c != 9 && this.c != 10 && this.c != 13 && this.c != 62 || n >= 0 && this.c != n) {
            if (this.c == -1 || this.c == 10 || this.c == 13) {
                this.error(i18n, "html.quoteMismatch", new Object[]{this.currFile, new Integer(this.line)});
                break;
            }
            stringBuffer.append((char)this.c);
            this.nextCh();
        }
        if (this.c == n) {
            this.nextCh();
        }
        this.skipSpace();
        return stringBuffer.toString();
    }

    private void skipComment() throws IOException {
        int n = 0;
        while (this.c != -1 && (n < 2 || this.c != 62)) {
            n = this.c == 45 ? ++n : 0;
            this.nextCh();
        }
        this.nextCh();
    }

    private void skipSpace() throws IOException {
        while (this.c == 32 || this.c == 9 || this.c == 10 || this.c == 13) {
            this.nextCh();
        }
    }

    private void skipTag() throws IOException {
        this.skipSpace();
        while (this.c != 62) {
            String string = this.scanIdentifier();
            if (string == "") {
                throw new IOException("error parsing HTML input");
            }
            String string2 = this.scanValue();
            this.skipSpace();
        }
        this.nextCh();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

